/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ResultsTimingsTableExtractor
implements ModelExtractor<List<List<String>>> {
    @Override
    public List<List<String>> extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        ArrayList<List<String>> features = new ArrayList<List<String>>();
        if (model.trainInfo != null) {
            features.add(Arrays.asList("Preprocessed in", this.asSecond(model.trainInfo.preprocessingTime)));
            features.add(Arrays.asList("Trained in", this.asSecond(model.trainInfo.trainingTime)));
            if (model.trainInfo.progress != null && model.trainInfo.progress.top_level_done != null) {
                List<ModelTrainInfo.TrainProgress.TopLevelDone> doneElements = model.trainInfo.progress.top_level_done;
                for (ModelTrainInfo.TrainProgress.TopLevelDone element : doneElements) {
                    features.add(Arrays.asList(element.name, this.asSecond(element.time)));
                }
            }
        } else {
            throw new IOException("Training details not found.");
        }
        return features;
    }

    private String asSecond(Long millis) throws IOException {
        if (millis < 0L) {
            throw new IOException("Negative time found (" + millis + ").");
        }
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis);
        millis = millis - TimeUnit.SECONDS.toMillis(seconds);
        return seconds + "." + Math.round(millis.floatValue() / 100.0f) + "s";
    }
}

