/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.clustering.flow;

import com.dataiku.dip.analysis.ml.DKUMLUtils;
import com.dataiku.dip.analysis.ml.clustering.extract.ForcedSampleExtractor;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringClusterRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.AbstractPythonRecipeRunner;
import com.dataiku.dip.dataflow.exec.AbstractSparkBasedRecipeRunner;
import com.dataiku.dip.dataflow.exec.ContainerRecipeParams;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.exec.SparkExecutionEnginesHelper;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.recipes.InitializableAbortableRecipeRunner;
import com.dataiku.dip.recipes.code.spark.SparkRecipeUtils;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.resources.ResourcesGatherer;
import com.dataiku.dip.spark.SparkJob;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.CollectionUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ClusteringClusterRecipeRunner
implements InitializableAbortableRecipeRunner,
RecipeRunnerWithPayload {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    protected VariablesService variablesService;
    @Autowired
    protected APITicketService apiTicketService;
    private InitializableAbortableRecipeRunner abortableRunner = null;
    private ClusteringClusterRecipePayloadParams desc;
    private final ResourcesGatherer gatherer = new ResourcesGatherer();
    private AuthCtx authCtx;
    private final JobActivity activity;
    private final FlowRecipe recipe;
    private final String projectKey;
    private static DKULogger logger;

    public ClusteringClusterRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe();
        this.projectKey = this.recipe.getProjectKey();
        activity.initStatus();
    }

    @Override
    public void setPayload(String payload) {
        this.desc = (ClusteringClusterRecipePayloadParams)JSON.parse((String)payload, ClusteringClusterRecipePayloadParams.class);
    }

    @Override
    public void init() {
        SpringUtils.getInstance().autowire((Object)this.gatherer);
        this.authCtx = this.authCtxService.getAuthCtx();
    }

    private InitializableAbortableRecipeRunner createRunner(final AutoDelete tmpFolder, final DatasetLocUtils.DatasetLoc outputLoc, ContainerExecSelection containerSelection, final ContainerExecRuntimeConfig clusteringContainerConfig) throws IOException {
        switch (this.desc.backendType) {
            case PY_MEMORY: {
                final File additionalLogsDir = FlowJobUtils.getJobMadeDir("clustering-recipe", "additional-logs");
                final File mainLogFile = FlowJobUtils.getJobTouchedFile("clustering-recipe", "python.log");
                JobContext.getCurrentActivitySummary().engineType = "DSS";
                return new AbstractPythonRecipeRunner(this.activity){

                    @Override
                    public void run() throws Exception {
                        FilesystemACLUtils.grantFSFullACLs(ClusteringClusterRecipeRunner.this.authCtx, this.projectKey, new File[]{tmpFolder});
                        String envName = ClusteringClusterRecipeRunner.this.desc.envName;
                        logger.info((Object)("Run clustering in code env " + StringUtils.defaultIfBlank((String)envName, (String)"built-in") + " (set at deploy-time)"));
                        if (clusteringContainerConfig == null) {
                            this.executeModule(envName, (File)tmpFolder, "dataiku.doctor.clustering.reg_cluster_recipe", tmpFolder.getAbsolutePath(), outputLoc.getSmartName(this.recipe.getProjectKey()), ClusteringClusterRecipeRunner.this.desc.filterInputColumns && ClusteringClusterRecipeRunner.this.desc.keptInputColumns != null ? JSON.json(ClusteringClusterRecipeRunner.this.desc.keptInputColumns) : "");
                        } else {
                            List<String> readableAndWritablePaths = Collections.singletonList(tmpFolder.getAbsolutePath());
                            CodeEnvModel.UsedCodeEnvRef codeEnvRef = new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, envName);
                            JsonObject params = new JsonObject();
                            params.addProperty("outputDatasetSmartName", outputLoc.getSmartName(this.recipe.getProjectKey()));
                            if (!ClusteringClusterRecipeRunner.this.desc.filterInputColumns || ClusteringClusterRecipeRunner.this.desc.keptInputColumns == null) {
                                params.addProperty("keptInputColumns", (String)null);
                            } else {
                                params.add("keptInputColumns", (JsonElement)JSON.toJsonArray(ClusteringClusterRecipeRunner.this.desc.keptInputColumns));
                            }
                            switch (clusteringContainerConfig.type) {
                                case DOCKER: {
                                    this.executeDockerCodeRecipe(codeEnvRef, clusteringContainerConfig, (File)tmpFolder, mainLogFile, tmpFolder, RemoteRunsRegistry.ExecutionType.RECIPE_CLUSTERING_CLUSTER_PYTHON, params.toString(), Collections.emptyMap(), readableAndWritablePaths, readableAndWritablePaths);
                                    break;
                                }
                                case KUBERNETES: {
                                    this.executeKubernetesCodeRecipe(codeEnvRef, clusteringContainerConfig, (File)tmpFolder, mainLogFile, additionalLogsDir, tmpFolder, RemoteRunsRegistry.ExecutionType.RECIPE_CLUSTERING_CLUSTER_PYTHON, params.toString(), Collections.emptyMap(), readableAndWritablePaths, readableAndWritablePaths, new KubernetesExecUtils.KubernetesFailureCodeProvider(){

                                        @Override
                                        public InfoMessage.MessageCode codeForOOMKilled() {
                                            return RecipeCodes.ERR_RECIPE_ML_TRAINING_K8S_OOM;
                                        }
                                    });
                                }
                            }
                        }
                    }

                    @Override
                    public void init() throws Exception {
                    }
                };
            }
            case H2O: 
            case MLLIB: {
                JobContext.getCurrentActivitySummary().engineType = "SPARK";
                if (containerSelection.containerMode == ContainerExecSelection.ContainerExecMode.EXPLICIT_CONTAINER) {
                    logger.warn((Object)("Ignoring container configuration " + containerSelection.containerConf + ", not compatible with Spark ML engine"));
                }
                final String hiveDb = SparkRecipeUtils.getHiveMetastoreDatabase(this.activity, this.datasetsDAO);
                return new AbstractSparkBasedRecipeRunner(this.activity){

                    @Override
                    public void run() throws Exception {
                        SerializedShakerScript expandedScript = ClusteringClusterRecipeRunner.this.desc.script.expandedDeepCopy(this.variablesService.getContext(this.projectKey));
                        ClusteringClusterRecipeRunner.this.gatherer.gatherAndCompute(ClusteringClusterRecipeRunner.this.authCtx, this.projectKey, expandedScript.steps);
                        JSON.prettyToFile((Object)expandedScript, (File)new File((File)tmpFolder, "script.json"));
                        JSON.prettyToFile(ClusteringClusterRecipeRunner.this.gatherer.getResourceMapping(), (File)new File((File)tmpFolder, "resource_mapping.json"));
                        this.runSpark("clustering", ClusteringClusterRecipeRunner.this.desc.sparkParams.sparkExecutionEngine, new SparkExecutionEnginesHelper.SparkRecipeJobBuilder(){

                            @Override
                            public <T extends SparkJob> T buildSparkJob(SparkJobHelper<T> helper, File runDir, SparkSettings sparkSettings, List<SimpleKeyValue> effectiveConf) throws Exception {
                                return helper.makeClassJobWithNonSecretGlobalFiles("DSS (cluster): " + activity.id(), effectiveConf, ClusteringClusterRecipeRunner.this.gatherer.getResourceFiles(), ClusteringClusterRecipeRunner.this.desc.backendType == MLTask.BackendType.H2O, "com.dataiku.dip.spark.MLLibClusteringClusterJob", recipe.getProjectKey(), tmpFolder.getAbsolutePath(), outputLoc.getSmartName(recipe.getProjectKey()));
                            }

                            @Override
                            public SparkOverrideConfig getRecipeOverrideConf() {
                                return ClusteringClusterRecipeRunner.this.desc.sparkParams.sparkConf;
                            }

                            @Override
                            public Map<String, String> getContextOverrideConf() {
                                return CollectionUtils.appendableSSMap().put("spark.dku.ml.preparedDF.storageLevel", ClusteringClusterRecipeRunner.this.desc.sparkParams.sparkPreparedDFStorageLevel).put("spark.dku.ml.repartitionNonHDFS", String.valueOf(ClusteringClusterRecipeRunner.this.desc.sparkParams.sparkRepartitionNonHDFS)).put("spark.dku.ml.useGlobalMetastore", Boolean.toString(ClusteringClusterRecipeRunner.this.desc.sparkParams.sparkUseGlobalMetastore)).put("spark.dku.ml.hiveDb", StringUtils.defaultIfBlank((String)hiveDb, (String)"")).get();
                            }

                            @Override
                            public List<File> getExtraRecursiveFolders() {
                                return Lists.newArrayList((Object[])new File[]{tmpFolder});
                            }
                        }, null);
                    }

                    @Override
                    public void init() throws Exception {
                    }
                };
            }
        }
        throw new NotImplementedException("Unsupported backend type: " + String.valueOf((Object)this.desc.backendType));
    }

    @Override
    public void run() throws Exception {
        AutoDelete tmpFolder = FlowJobUtils.getTmpFolder("clustering-recipe", "spec");
        File splitFolder = new File((File)tmpFolder, "split");
        DKUFileUtils.mkdirs((File)splitFolder);
        DatasetLocUtils.DatasetLoc outputLoc = DatasetLocUtils.resolveFull(this.activity.getSubgraph().getSingleTargetDataset().getFullName());
        ContainerExecSelection containerSelection = this.recipe.getModel().getParamsAs(ContainerRecipeParams.class).getContainerSelection();
        ContainerExecRuntimeConfig clusteringContainerConfig = new ContainerExecConfigSelector().selectForML_autoTXN(this.authCtx, this.projectKey, containerSelection, this.desc.backendType);
        FlowDataset inputFDS = ((RecipeRunnableSubgraph)this.activity.getSubgraph()).getSingleSourceDatasetForRole("main");
        Dataset inputDataset = inputFDS.getMandatory(this.datasetsDAO);
        if (this.desc.expectedPreparationOutputSchema == null) {
            logger.info((Object)"1.4-migrated recipe, inferring preparation output schema");
            assert (this.desc.script.steps.size() == 0);
            this.desc.expectedPreparationOutputSchema = inputDataset.getSchema();
        }
        ForcedSampleExtractor fsg = new ForcedSampleExtractor(this.authCtx, inputDataset, this.desc.sampling, this.desc.script, this.desc.expectedPreparationOutputSchema, splitFolder);
        SplitDesc splitDesc = fsg.compute();
        JSON.prettyToFile((Object)splitDesc, (File)DKUFileUtils.getWithin((File)tmpFolder, (String[])new String[]{"split", "split.json"}));
        JSON.prettyToFile((Object)this.desc.preprocessing, (File)DKUFileUtils.getWithin((File)tmpFolder, (String[])new String[]{"rpreprocessing_params.json"}));
        JSON.prettyToFile((Object)this.desc.modeling, (File)DKUFileUtils.getWithin((File)tmpFolder, (String[])new String[]{"rmodeling_params.json"}));
        InitializableAbortableRecipeRunner runner = this.createRunner(tmpFolder, outputLoc, containerSelection, clusteringContainerConfig);
        this.startRunner(runner);
    }

    @Override
    public void notifyBeforeAborting() {
        if (this.abortableRunner != null) {
            this.abortableRunner.notifyBeforeAborting();
        }
    }

    private void startRunner(InitializableAbortableRecipeRunner runner) throws Exception {
        SpringUtils.getInstance().autowire((Object)runner);
        runner.init();
        this.abortableRunner = runner;
        runner.run();
    }

    static {
        DKUMLUtils.loadClasses();
        ScriptStep.loadClass();
        logger = DKULogger.getLogger((String)"dku.recipes.clustering");
    }
}

