/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction;

import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.shaker.analysis.NumericalVariableAnalyzer;
import com.dataiku.dip.shaker.facet.AlphanumFacetBuilder;
import com.dataiku.dip.shaker.facet.ArrayFacetBuilder;
import com.dataiku.dip.shaker.facet.FacetUtils;
import com.dataiku.dip.shaker.filter.FilterRequest;
import com.dataiku.dip.shaker.filter.FilteringExecutor;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.server.TableSortingService;
import com.dataiku.dip.shaker.types.JSONArrayMeaning;
import com.dataiku.dip.utils.DKULogger;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModelDataUtilsService {
    @Autowired
    private TableSortingService sortingService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.modellikedata");

    public void applyFiltersAndSorts(MemScriptRunner.TableWithReport twr, FilterRequest filters, List<SerializedShakerScript.TableSorting> sorting) throws Exception {
        if (sorting != null) {
            logger.info((Object)"Sorting table");
            this.sortingService.prepareSorting(sorting, twr.table);
        }
        if (filters != null) {
            FilteringExecutor executor = new FilteringExecutor(filters);
            logger.info((Object)"Refreshing filtering/faceting");
            executor.execute(twr.table);
            twr.filters = executor.getFilterResult();
            twr.facets = executor.getFaceting();
            logger.info((Object)"done");
        }
    }

    public DataService.ColumnDetailedAnalysis getDetailedColumnAnalysis(MemTable table, SerializedShakerScript ss, String column, int alphanumMaxResults) {
        DataService.ColumnDetailedAnalysis ret = new DataService.ColumnDetailedAnalysis();
        MemColumn cd = table.column(column);
        FacetUtils.Sort facetSort = FacetUtils.Sort.COUNT;
        ret.alphanumFacet = new AlphanumFacetBuilder().build(table, facetSort, alphanumMaxResults, cd);
        if (cd.selectedType != null && cd.selectedType.type.getClass() == JSONArrayMeaning.class) {
            ret.arrayFacet = new ArrayFacetBuilder().build(table, facetSort, alphanumMaxResults, cd);
        }
        if (cd.selectedType != null && cd.selectedType.type.isDouble()) {
            NumericalVariableAnalyzer analyzer = new NumericalVariableAnalyzer(40);
            analyzer.niceBounds = false;
            analyzer.analyse(table, column, null);
            analyzer.compute();
            ret.numericalAnalysis = analyzer.getOut();
        }
        return ret;
    }
}

