/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model;

import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.utils.polyjson.RichJsonReader;
import com.dataiku.dip.utils.polyjson.RichJsonWriter;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class MLTaskAdapter
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> typeToken) {
        if (!MLTask.class.isAssignableFrom(typeToken.getRawType())) {
            return null;
        }
        return new TypeAdapter<MLTask>(){
            final Map<Class<? extends MLTask>, TypeAdapter<MLTask>> adapterCache = new ConcurrentHashMap<Class<? extends MLTask>, TypeAdapter<MLTask>>();

            private TypeAdapter<MLTask> lookupSubClassAdapter(Class<? extends MLTask> subClass) {
                TypeAdapter adapter = this.adapterCache.get(subClass);
                if (adapter == null) {
                    adapter = gson.getDelegateAdapter((TypeAdapterFactory)MLTaskAdapter.this, TypeToken.get(subClass));
                    this.adapterCache.put(subClass, (TypeAdapter<MLTask>)adapter);
                }
                return adapter;
            }

            public void write(JsonWriter jsonWriter, MLTask t) throws IOException {
                TypeAdapter<MLTask> concreteAdapter = this.lookupSubClassAdapter(t.getClass());
                RichJsonWriter richWriter = RichJsonWriter.fromWriter((JsonWriter)jsonWriter);
                richWriter.beginObject();
                int captures = 0;
                if (t.taskType != null) {
                    richWriter.writeProperty("taskType", t.taskType.name());
                    richWriter.beginCapture("taskType");
                    ++captures;
                }
                if (t instanceof PredictionMLTask && ((PredictionMLTask)t).predictionType != null) {
                    richWriter.writeProperty("predictionType", ((PredictionMLTask)t).predictionType.name());
                    richWriter.beginCapture("predictionType");
                    ++captures;
                }
                richWriter.beginFlatten();
                concreteAdapter.write((JsonWriter)richWriter, (Object)t);
                richWriter.endFlatten();
                for (int i = 0; i < captures; ++i) {
                    richWriter.endCapture();
                }
                richWriter.endObject();
            }

            public MLTask read(JsonReader jsonReader) throws IOException {
                MLTaskClassResolver resolver = new MLTaskClassResolver();
                Class<? extends MLTask> mlTaskClass = null;
                RichJsonReader richReader = RichJsonReader.fromReader((JsonReader)jsonReader);
                richReader.beginLookahead();
                richReader.beginObject();
                while (richReader.hasNext() && mlTaskClass == null) {
                    String nextName = richReader.nextName();
                    if ("taskType".equals(nextName)) {
                        resolver.mlTaskType = MLTask.MLTaskType.valueOf(richReader.nextString());
                    } else if ("predictionType".equals(nextName)) {
                        resolver.predictionType = PredictionMLTask.PredictionType.valueOf(richReader.nextString());
                    } else if ("backendType".equals(nextName)) {
                        resolver.backendType = MLTask.BackendType.valueOf(richReader.nextString());
                    } else if ("treatmentVariable".equals(nextName)) {
                        resolver.treatmentVariable = richReader.nextString();
                    } else {
                        richReader.skipValue();
                        continue;
                    }
                    mlTaskClass = resolver.resolve();
                }
                if (mlTaskClass == null) {
                    mlTaskClass = resolver.resolveLastChance();
                }
                if (mlTaskClass == null) {
                    throw new IllegalArgumentException("Unrecognized task type");
                }
                richReader.endLookahead();
                return (MLTask)this.lookupSubClassAdapter(mlTaskClass).read((JsonReader)richReader);
            }
        }.nullSafe();
    }

    private static class MLTaskClassResolver {
        MLTask.MLTaskType mlTaskType = null;
        PredictionMLTask.PredictionType predictionType = null;
        MLTask.BackendType backendType = null;
        String treatmentVariable = null;

        private MLTaskClassResolver() {
        }

        @Nullable
        Class<? extends MLTask> resolve() {
            if (this.mlTaskType == null) {
                return null;
            }
            switch (this.mlTaskType) {
                case CLUSTERING: {
                    return ClusteringMLTask.class;
                }
                case PREDICTION: {
                    if (this.predictionType != null) {
                        switch (this.predictionType) {
                            case BINARY_CLASSIFICATION: 
                            case REGRESSION: 
                            case MULTICLASS: {
                                return PredictionMLTask.ClassicalPredictionMLTask.class;
                            }
                            case DEEP_HUB_IMAGE_OBJECT_DETECTION: 
                            case DEEP_HUB_IMAGE_CLASSIFICATION: {
                                return PredictionMLTask.DeepHubPredictionMLTask.class;
                            }
                            case TIMESERIES_FORECAST: {
                                return PredictionMLTask.TimeseriesForecastingMLTask.class;
                            }
                            case CAUSAL_BINARY_CLASSIFICATION: 
                            case CAUSAL_REGRESSION: {
                                return PredictionMLTask.CausalPredictionMLTask.class;
                            }
                        }
                    }
                    if (this.treatmentVariable != null) {
                        return PredictionMLTask.CausalPredictionMLTask.class;
                    }
                    if (this.backendType == MLTask.BackendType.DEEP_HUB) {
                        return PredictionMLTask.DeepHubPredictionMLTask.class;
                    }
                    return null;
                }
            }
            return null;
        }

        @Nullable
        Class<? extends MLTask> resolveLastChance() {
            return this.mlTaskType == MLTask.MLTaskType.PREDICTION ? PredictionMLTask.ClassicalPredictionMLTask.class : null;
        }
    }
}

