/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.clustering.algorithms.python;

import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringParameterChecks;
import com.dataiku.dip.analysis.model.clustering.PreTrainClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.algorithms.python.ScikitAlgorithmMeta;
import com.dataiku.dip.analysis.model.core.WorkSet;
import java.util.ArrayList;
import java.util.List;

public class HDBScanMeta
extends ScikitAlgorithmMeta {
    @Override
    public String generateName(PreTrainClusteringModelingParams rpmp) {
        return "HDBScan (mcsr=" + rpmp.min_cluster_size_ratio + ")";
    }

    @Override
    public String generateDescription(PreTrainClusteringModelingParams rpmp) {
        return "min_cluster_size_ratio=" + rpmp.min_cluster_size_ratio;
    }

    @Override
    public void validateParameters(ClusteringModelingParams pmp, ClusteringMLTask task, ClusteringParameterChecks checks) {
        ClusteringModelingParams.HDBScanParams hdbscan = task.modeling.hdb_scan_clustering;
        if (hdbscan.enabled) {
            checks.checkAllStrictlyBetween(hdbscan.min_cluster_size_ratio, 0.0, 0.5, "HDBSCAN requires a cluster size ratio between 0 and 0.5");
        }
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(ClusteringModelingParams pmp, ClusteringMLTask task) {
        ArrayList<WorkSet.ModelingSet> ret = new ArrayList<WorkSet.ModelingSet>();
        ClusteringModelingParams.HDBScanParams hdbscan = task.modeling.hdb_scan_clustering;
        if (hdbscan.enabled) {
            for (double min_cluster_size_ratio : hdbscan.min_cluster_size_ratio) {
                PreTrainClusteringModelingParams rcmp = new PreTrainClusteringModelingParams(PreTrainClusteringModelingParams.Algorithm.HDBSCAN);
                rcmp.min_cluster_size_ratio = min_cluster_size_ratio;
                ret.add(new WorkSet.ModelingSet(rcmp));
            }
        }
        return ret;
    }
}

