/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.PostTrainModelingParams;
import com.dataiku.dip.analysis.model.core.PreTrainModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;

public class PostTrainPredictionModelingParams
implements PostTrainModelingParams {
    public PreTrainPredictionModelingParams.Algorithm algorithm;
    public RandomForestParams rf;
    public RandomForestParams extra_trees;
    public GBTParams gbt;
    public DTParams dt;
    public LogitParams logit;
    public NeuralNetworkParams neural_network;
    public SVMParams2 svm;
    public LeastSquareParams least_squares;
    public SGDParams sgd;
    public RidgeParams ridge;
    public LassoParams lasso;
    public LARSParams lars;
    public KNNParams knn;
    public LightGBMParams lightgbm;
    public XGBoostParams xgboost;
    public DeepNeuralNetworkParams deep_neural_network;
    public JsonObject plugin_python;
    public KerasCodeParams keras;
    public TrivialIdentityTimeseriesParams trivial_identity_timeseries_params;
    public SeasonalNaiveParams seasonal_naive_timeseries_params;
    public AutoArimaParams auto_arima_timeseries_params;
    public ArimaParams arima_timeseries_params;
    public ETSParams ets_params;
    public SeasonalLoessParams seasonal_loess_timeseries_params;
    public ProphetParams prophet_timeseries_params;
    public GluonTSNPTSForecasterParams gluonts_npts_timeseries_params;
    public GluonTSTorchDeepARParams gluonts_torch_deepar_timeseries_params;
    public GluonTSTorchSimpleFeedForwardParams gluonts_torch_simple_feedforward_timeseries_params;
    public GluonTSMXNetSimpleFeedForwardParams gluonts_simple_feedforward_timeseries_params;
    public GluonTSMXNetDeepARParams gluonts_deepar_timeseries_params;
    public GluonTSMXNetTransformerParams gluonts_transformer_timeseries_params;
    public GluonTSMXNetMQCNNParams gluonts_mqcnn_timeseries_params;
    public CausalForestParams causal_forest_params;
    public PredictionModelingParams.CausalLearningMethod causal_method;
    public PredictionModelingParams.CausalMetaLearner meta_learner;
    public MLLibLogisticRegressionParams mllib_logit;
    public MLLibLinearRegressionParams mllib_linreg;
    public MLLibDecisionTreeParams mllib_dt;
    public MLLibRandomForestParams mllib_rf;
    public MLLibRandomForestParams mllib_gbt;
    public MLLibNaiveBayesParams mllib_naive_bayes;
    public boolean skipExpensiveReports;

    @Override
    public ModelTrainInfo.PostSearchDescription generatePostSearchDescription(ModelTrainInfo.PreSearchDescription preSearchDescription, PreTrainModelingParams before) {
        ModelTrainInfo.PostSearchDescription desc = this.algorithm.meta.generatePostTrainDescription(preSearchDescription, (PreTrainPredictionModelingParams)before, this);
        if (this.causal_method != null) {
            desc.withSVParam("Causal learning method", this.causal_method.name());
            if (this.meta_learner != null) {
                desc.withSVParam("Meta-learner", this.meta_learner.displayName);
            }
        }
        return desc;
    }

    @Override
    public String getAlgorithmName() {
        if (PredictionModelingParams.CausalLearningMethod.META_LEARNER.equals((Object)this.causal_method)) {
            return this.meta_learner.displayName + " | " + this.algorithm.name();
        }
        return this.algorithm.name();
    }

    public static class MLLibNaiveBayesParams {
        public double lambda;
    }

    public static class MLLibRandomForestParams {
        public PredictionModelingParams.MLLibRfImpurity impurity;
        public int max_bins;
        public int max_depth;
        public float min_info_gain;
        public int min_instance_per_node;
        public float subsampling_rate;
        public int num_trees;
        public PredictionModelingParams.MLLibRfFeatureSubsetStrategy subset_strategy;
        public float step_size;
    }

    public static class MLLibDecisionTreeParams {
        public int max_depth;
        public int max_bins;
        public double min_info_gain;
        public int min_instance_per_node;
    }

    public static class MLLibLinearRegressionParams {
        public double reg_param;
        public double enet_param;
    }

    public static class MLLibLogisticRegressionParams {
        public double reg_param;
        public double enet_param;
    }

    public static class CausalForestParams {
        public int n_estimators;
        public String criterion;
        public int max_depth;
        public int min_samples_leaf;
        public String selection_mode;
        public int max_features;
        public double max_feature_prop;
        public boolean honest;
    }

    public static class GluonTSMXNetMQCNNParams {
        public long context_length;
        public boolean use_timeseries_identifiers_as_features;
        public List<Long> decoder_mlp_dim_seq;
        public List<Long> channels_seq;
        public List<Long> dilation_seq;
        public List<Long> kernel_size_seq;
        public boolean scaling;
        public double learning_rate;
        public int batch_size;
        public int epochs;
        public int num_batches_per_epoch;
        public int seed;
    }

    public static class GluonTSMXNetTransformerParams {
        public long context_length;
        public boolean use_timeseries_identifiers_as_features;
        public String distr_output;
        public long model_dim;
        public long inner_ff_dim_scale;
        public long num_heads;
        public double dropout_rate;
        public int num_parallel_samples;
        public double learning_rate;
        public int batch_size;
        public int epochs;
        public int num_batches_per_epoch;
        public int seed;
    }

    public static class GluonTSMXNetDeepARParams {
        public long context_length;
        public boolean use_timeseries_identifiers_as_features;
        public String distr_output;
        public long num_layers;
        public long num_cells;
        public String cell_type;
        public String dropoutcell_type;
        public double dropout_rate;
        public double alpha;
        public double beta;
        public boolean scaling;
        public int num_parallel_samples;
        public double minimum_scale;
        public double learning_rate;
        public int batch_size;
        public int epochs;
        public int num_batches_per_epoch;
        public int seed;
    }

    public static class GluonTSMXNetSimpleFeedForwardParams {
        public long context_length;
        public String distr_output;
        public String batch_normalization;
        public String mean_scaling;
        public List<Long> num_hidden_dimensions;
        public int num_parallel_samples;
        public double learning_rate;
        public int batch_size;
        public int epochs;
        public int num_batches_per_epoch;
        public int seed;
    }

    public static class GluonTSTorchSimpleFeedForwardParams {
        public long context_length;
        public String distr_output;
        public String batch_normalization;
        public List<Long> num_hidden_dimensions;
        public double learning_rate;
        public double weight_decay;
        public int batch_size;
        public int epochs;
        public int num_batches_per_epoch;
        public int seed;
    }

    public static class GluonTSTorchDeepARParams {
        public long context_length;
        public boolean use_timeseries_identifiers_as_features;
        public String distr_output;
        public long num_layers;
        public long num_cells;
        public double dropout_rate;
        public boolean scaling;
        public int num_parallel_samples;
        public double learning_rate;
        public double weight_decay;
        public int patience;
        public int batch_size;
        public int epochs;
        public int num_batches_per_epoch;
        public int seed;
    }

    public static class GluonTSNPTSForecasterParams {
        public long context_length;
        public String kernel_type;
        public double exp_kernel_weights;
        public boolean use_seasonal_model;
        public boolean use_default_time_features;
        public double feature_scale;
        public int seed;
    }

    public static class ProphetParams {
        public String growth;
        public double floor;
        public Double cap;
        public int n_changepoints;
        public double changepoint_range;
        public String yearly_seasonality;
        public String weekly_seasonality;
        public String daily_seasonality;
        public int seed;
        public String seasonality_mode;
        public double seasonality_prior_scale;
        public double changepoint_prior_scale;
        public double holidays_prior_scale;
        public boolean _use_external_features;
    }

    public static class SeasonalLoessParams {
        public long period;
        public long seasonal;
        public long trend;
        public long low_pass;
        public String seasonal_deg;
        public String trend_deg;
        public String low_pass_deg;
        public long seasonal_jump;
        public long trend_jump;
        public long low_pass_jump;
    }

    public static class ETSParams {
        public String trend;
        public String damped_trend;
        public String seasonal;
        public String error;
        public int seasonal_periods;
        public int seed;
        public boolean include_unstable;
    }

    public static class ArimaParams {
        public int p = 0;
        public int d = 0;
        public int q = 0;
        public int P = 0;
        public int D = 0;
        public int Q = 0;
        public int s = 7;
        public String trend = "n";
        public int trend_offset = 1;
        public boolean enforce_stationarity = true;
        public boolean enforce_invertibility = true;
        public boolean concentrate_scale = false;
    }

    public static class AutoArimaParams {
        public Map<String, Integer> p;
        public Map<String, Integer> q;
        public Map<String, Integer> d;
        public Map<String, Integer> P;
        public Map<String, Integer> Q;
        public Map<String, Integer> D;
        public long m;
        public String information_criterion;
        public String test;
        public String seasonal_test;
        public String method;
        public boolean stationary;
    }

    public static class SeasonalNaiveParams {
        public long season_length;
    }

    public static class TrivialIdentityTimeseriesParams {
    }

    public static class KerasCodeParams {
        public int epochs;
        public boolean oneDimensionalOutput = false;
        public int completedEpochs;
        public int keptModelEpoch;
    }

    public static class DeepNeuralNetworkParams {
        public double learning_rate;
        public long hidden_layers;
        public long units;
        public long max_epochs;
        public long batch_size;
        public String device;
        public long epochs;
        public float dropout;
        public float reg_l2;
        public float reg_l1;
        public boolean early_stopping_enabled;
        public long early_stopping_patience;
        public double early_stopping_threshold;
    }

    public static class XGBoostParams {
        public int max_depth;
        public float learning_rate;
        public int n_estimators;
        public boolean silent;
        public String objective;
        public String booster;
        public int nthread;
        public float gamma;
        public float min_child_weight;
        public float max_delta_step;
        public float subsample;
        public float colsample_bytree;
        public float colsample_bylevel;
        public float alpha;
        public float lambda;
        public int seed;
        public boolean impute_missing;
        public double missing;
        public double base_score;
        public double scale_pos_weight;
        public float tweedie_variance_power;
    }

    public static class LightGBMParams {
        public String boosting_type;
        public long num_leaves;
        public long max_depth;
        public double learning_rate;
        public long n_estimators;
        public long subsample_for_bin;
        public String objective;
        public double min_split_gain;
        public double min_child_weight;
        public long min_child_samples;
        public double subsample;
        public long subsample_freq;
        public double colsample_bytree;
        public double reg_alpha;
        public double reg_lambda;
        public long random_state;
        public long n_jobs;
        public String importance_type;
    }

    public static class KNNParams {
        public int k;
        public boolean distance_weighting;
        public String algorithm;
        public int p;
        public int leaf_size;
    }

    public static class LARSParams {
        public int max_features;
        public int K;
    }

    public static class LassoParams {
        public float alpha;
    }

    public static class RidgeParams {
        public float alpha;
    }

    public static class SGDParams {
        public float alpha;
        public float l1_ratio;
        public String loss;
        public String penalty;
        public Integer n_iter;
        public double epsilon;
    }

    public static class LeastSquareParams {
    }

    public class SVMParams2 {
        public float C;
        public String gamma;
        public float custom_gamma;
        public String kernel;
        public float coef0;
        public float tol;
        public int max_iter;
    }

    public static class NeuralNetworkParams {
        public int layer_sizes;
    }

    public static class LogitParams {
        public String penalty;
        public PredictionModelingParams.LogisticRegressionClassifierMultiClass multi_class;
        public float C;
    }

    public static class DTParams {
        public int max_depth;
        public String criterion;
        public int min_samples_leaf;
        public String splitter;
    }

    public static class GBTParams {
        public int n_estimators;
        public float learning_rate;
        public String loss;
        public int max_depth;
        public int max_features;
        public int min_samples_leaf;
        public double max_feature_prop;
        public String selection_mode;
    }

    public static class RandomForestParams {
        public int estimators;
        public int max_tree_depth;
        public int min_samples_leaf;
        public String selection_mode;
        public int max_features;
        public double max_feature_prop;
    }
}

