/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.analysis.model.core.ResolvedPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesScenariosMetadata;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.input.formats.vendor.opencsv.CSVReader;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@UIModel
public class TimeseriesInteractiveScoringScenarios {
    public Map<String, TimeseriesScenarioData> scenarios = new HashMap<String, TimeseriesScenarioData>();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.analysis.ml.timeseries.interactive-scoring");

    public static class InteractiveScenarioFolder {
        private final File folder;
        private final Map<String, String> identifiersMapping;
        private final ResolvedPreprocessingParams params;

        public InteractiveScenarioFolder(File modelFolder, ResolvedPreprocessingParams params) throws IOException {
            this.params = params;
            File interactiveScoringFolder = DKUFileUtils.getWithin((File)modelFolder, (String[])new String[]{"interactive-scoring-analysis"});
            if (!interactiveScoringFolder.exists()) {
                throw new IOException("interactive-scoring-analysis folder does not exist");
            }
            this.folder = interactiveScoringFolder;
            File mappingFile = DKUFileUtils.getWithinFollowLink((File)this.folder, (String[])new String[]{"identifiers_mapping.json"});
            if (!mappingFile.exists()) {
                throw new IOException("identifiers_mapping.json does not exist in interactive-scoring-analysis folder. Updating/Reading scenarios won't be available until scenarios are created");
            }
            this.identifiersMapping = (Map)JSON.parseFile((File)mappingFile, Map.class);
        }

        public Map<String, TimeseriesInteractiveScoringScenarios> parseScenarios() throws IOException {
            TimeseriesInteractiveScoringColumnInfo columnInfo = TimeseriesInteractiveScoringColumnInfo.extractTimeseriesColumnInfo(this.params);
            HashMap<String, TimeseriesInteractiveScoringScenarios> result = new HashMap<String, TimeseriesInteractiveScoringScenarios>();
            for (Map.Entry<String, String> entry : this.identifiersMapping.entrySet()) {
                String identifier = entry.getKey();
                String identifierHash = entry.getValue();
                File identifierScenariosFolder = DKUFileUtils.getWithin((File)this.folder, (String[])new String[]{identifierHash});
                TimeseriesScenariosMetadata tsIdentifiersMetadata = ModelLikeId.parseJsonFile(DKUFileUtils.getWithinFollowLink((File)identifierScenariosFolder, (String[])new String[]{"scenarios_metadata.json"}), TimeseriesScenariosMetadata.class);
                Set<String> scenarioIds = tsIdentifiersMetadata.names.keySet();
                for (String scenarioId : scenarioIds) {
                    File scenarioFile = DKUFileUtils.getWithinFollowLink((File)identifierScenariosFolder, (String[])new String[]{"scenario-" + scenarioId + ".csv"});
                    if (!scenarioFile.exists()) {
                        logger.warn((Object)("scenario file " + identifierHash + "/scenario-" + scenarioId + ".csv does not exist in interactive-scoring-analysis folder for identifier " + identifier));
                        continue;
                    }
                    CSVReader reader = new CSVReader((Reader)new InputStreamReader(DKUFileUtils.readWithAutoDecompress((File)scenarioFile)), '\t');
                    String[] header = reader.readNext();
                    if (header == null) {
                        logger.warn((Object)("Empty scenario file " + identifierHash + "/scenario-" + scenarioId + ".csv in interactive-scoring-analysis folder for identifier " + identifier));
                        continue;
                    }
                    HashMap<String, Integer> headerMapping = new HashMap<String, Integer>();
                    for (int i = 0; i < header.length; ++i) {
                        headerMapping.put(header[i], i);
                    }
                    if (!headerMapping.containsKey(columnInfo.dateColumn)) {
                        logger.warn((Object)("Date column " + columnInfo.dateColumn + " not found in scenario file " + identifierHash + "/scenario-" + scenarioId + ".csv in interactive-scoring-analysis folder for identifier " + identifier));
                        continue;
                    }
                    if (columnInfo.externalFeatureColumns.stream().anyMatch(c2 -> !headerMapping.containsKey(c2))) {
                        logger.warn((Object)("One of external feature columns " + String.valueOf(columnInfo.externalFeatureColumns) + " not found in scenario file " + identifierHash + "/scenario-" + scenarioId + ".csv in interactive-scoring-analysis folder for identifier " + identifier));
                        continue;
                    }
                    TimeseriesInteractiveScoringScenarios perTimeseriesScenarios = result.computeIfAbsent(identifier, k -> new TimeseriesInteractiveScoringScenarios());
                    try {
                        String[] row;
                        while ((row = reader.readNext()) != null) {
                            TimeseriesScenarioData scenarioData = perTimeseriesScenarios.scenarios.computeIfAbsent(tsIdentifiersMetadata.names.get(scenarioId), k -> new TimeseriesScenarioData());
                            scenarioData.dates.add(row[(Integer)headerMapping.get(columnInfo.dateColumn)]);
                            for (String featCol : columnInfo.externalFeatureColumns) {
                                String val = row[(Integer)headerMapping.get(featCol)];
                                scenarioData.externalFeatures.computeIfAbsent(featCol, k -> new ArrayList()).add(val);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Exception while parsing scenarios for identifier " + identifier + ": " + e.getMessage()));
                    }
                }
            }
            return result;
        }

        public void updateTimeseriesScenarios(String timeseriesIdentifier, TimeseriesInteractiveScoringScenarios perTimeseriesScenarios) throws IOException {
            TimeseriesInteractiveScoringColumnInfo columnInfo = TimeseriesInteractiveScoringColumnInfo.extractTimeseriesColumnInfo(this.params);
            String identifierHash = this.identifiersMapping.get(timeseriesIdentifier);
            if (identifierHash == null) {
                throw new IOException("No hash found in mapping for identifier: " + timeseriesIdentifier);
            }
            File identifierScenariosFolder = DKUFileUtils.getWithin((File)this.folder, (String[])new String[]{identifierHash});
            TimeseriesScenariosMetadata tsIdentifiersMetadata = ModelLikeId.parseJsonFile(DKUFileUtils.getWithinFollowLink((File)identifierScenariosFolder, (String[])new String[]{"scenarios_metadata.json"}), TimeseriesScenariosMetadata.class);
            for (Map.Entry<String, TimeseriesScenarioData> scenarioEntry : perTimeseriesScenarios.scenarios.entrySet()) {
                File scenarioFile = DKUFileUtils.getWithinFollowLink((File)identifierScenariosFolder, (String[])new String[]{"scenario-" + tsIdentifiersMetadata.getScenarioId(scenarioEntry.getKey()) + ".csv"});
                TimeseriesScenarioData scenarioData = scenarioEntry.getValue();
                scenarioData.writeToCSV(scenarioFile, columnInfo.dateColumn);
                logger.info((Object)("Updated scenario " + scenarioEntry.getKey() + "to scenario-" + tsIdentifiersMetadata.getScenarioId(scenarioEntry.getKey()) + ".csv"));
            }
        }

        private record TimeseriesInteractiveScoringColumnInfo(String dateColumn, List<String> identifierColumns, List<String> externalFeatureColumns) {
            private static TimeseriesInteractiveScoringColumnInfo extractTimeseriesColumnInfo(ResolvedPreprocessingParams params) {
                Map<String, FeaturePreprocessingParams> features = params.per_feature;
                String dateColumn = null;
                ArrayList<String> identifierColumns = new ArrayList<String>();
                ArrayList<String> externalFeatureColumns = new ArrayList<String>();
                for (Map.Entry<String, FeaturePreprocessingParams> entry : features.entrySet()) {
                    String featureName = entry.getKey();
                    FeaturePreprocessingParams.Role role = entry.getValue().role;
                    switch (role) {
                        case TIME: {
                            dateColumn = featureName;
                            break;
                        }
                        case TIMESERIES_IDENTIFIER: {
                            identifierColumns.add(featureName);
                            break;
                        }
                        case INPUT: {
                            externalFeatureColumns.add(featureName);
                        }
                    }
                }
                return new TimeseriesInteractiveScoringColumnInfo(dateColumn, identifierColumns, externalFeatureColumns);
            }
        }
    }

    public static class TimeseriesScenarioData {
        public List<String> dates = new ArrayList<String>();
        public Map<String, List<String>> externalFeatures = new HashMap<String, List<String>>();

        private String rowToString(List<String> row) {
            return row.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining("\t")) + "\n";
        }

        public void writeToCSV(File scenarioFile, String dateColumn) throws IOException {
            StringBuilder sb = new StringBuilder();
            ArrayList<String> header = new ArrayList<String>();
            header.add(dateColumn);
            header.addAll(this.externalFeatures.keySet());
            sb.append(this.rowToString(header));
            for (int i = 0; i < this.dates.size(); ++i) {
                ArrayList<String> row = new ArrayList<String>();
                row.add(this.dates.get(i));
                for (String featCol : this.externalFeatures.keySet()) {
                    List<String> values = this.externalFeatures.get(featCol);
                    row.add(values != null && i < values.size() ? values.get(i) : "");
                }
                sb.append(this.rowToString(row));
            }
            DKUFileUtils.writeFileUTF8((File)scenarioFile, (String)sb.toString());
        }
    }
}

