/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction.algorithms.spark;

import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionParameterChecks;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.algorithms.spark.MLLibAlgorithmMeta;
import com.dataiku.dip.analysis.model.prediction.algorithms.spark.MLLibRandomForestMeta;
import java.util.ArrayList;
import java.util.List;

public class MLLibGBTMeta
extends MLLibAlgorithmMeta {
    @Override
    public String generateName(PreTrainPredictionModelingParams rpmp) {
        return "Gradient Boosting (MLLib)";
    }

    @Override
    public ModelTrainInfo.PreSearchDescription generatePreTrainDescription(PreTrainPredictionModelingParams rpmp) {
        return new ModelTrainInfo.PreSearchDescription(rpmp).withMVParam("trees", rpmp.mllib_gbt_grid.num_trees).withMVParam("max_depth", rpmp.mllib_gbt_grid.max_depth).withMVParam("learning_rate", rpmp.mllib_gbt_grid.step_size);
    }

    @Override
    public ModelTrainInfo.PostSearchDescription generatePostTrainDescription(ModelTrainInfo.PreSearchDescription descBefore, PreTrainPredictionModelingParams before, PostTrainPredictionModelingParams after) {
        return new ModelTrainInfo.PostSearchDescription().withSVParam("trees", after.mllib_gbt.num_trees).withSVParam("max_depth", after.mllib_gbt.max_depth).withSVParam("learning_rate", Float.valueOf(after.mllib_gbt.step_size));
    }

    @Override
    public void validateParameters(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, PredictionParameterChecks checks) {
        PredictionModelingParams.MLLibTreesEnsembleGridParams gbtp = pmp.mllib_gbt;
        if (gbtp == null || !gbtp.enabled) {
            return;
        }
        String algo = "MLLib GBT";
        MLLibRandomForestMeta.checkMLLibRFParams(gbtp, task, checks, algo);
        checks.checkNumericalDimension(gbtp.step_size, algo + "Step size (Gradient Boosted Trees)");
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, int gsFolds) {
        PredictionModelingParams.MLLibTreesEnsembleGridParams gbtp = pmp.mllib_gbt;
        ArrayList<WorkSet.ModelingSet> ret = new ArrayList<WorkSet.ModelingSet>();
        if (gbtp == null || !gbtp.enabled) {
            return ret;
        }
        if (task.predictionType == PredictionMLTask.PredictionType.REGRESSION) {
            gbtp.impurity = PredictionModelingParams.MLLibRfImpurity.variance;
        }
        PreTrainPredictionModelingParams rcmp = new PreTrainPredictionModelingParams(PreTrainPredictionModelingParams.Algorithm.MLLIB_GBT, pmp);
        rcmp.max_ensemble_nodes_serialized = pmp.max_ensemble_nodes_serialized;
        rcmp.mllib_gbt_grid = gbtp;
        WorkSet.ModelingSet ms = new WorkSet.ModelingSet(rcmp);
        rcmp.gridLength = gbtp.max_depth.getLength() * gbtp.num_trees.getLength();
        ms.estimatedTrains = rcmp.gridLength > 1 ? rcmp.gridLength * gsFolds + 1 : 1;
        ret.add(ms);
        return ret;
    }

    @Override
    public boolean hasProbabilities(PreTrainPredictionModelingParams rpmp) {
        return true;
    }

    @Override
    public boolean isJavaCompatible(ResolvedClassicalPredictionCoreParams coreParams) {
        switch (coreParams.prediction_type) {
            case REGRESSION: 
            case BINARY_CLASSIFICATION: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPythonCompatible(ResolvedClassicalPredictionCoreParams coreParams) {
        switch (coreParams.prediction_type) {
            case REGRESSION: 
            case BINARY_CLASSIFICATION: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSQLCompatible(ResolvedClassicalPredictionCoreParams coreParams) {
        return true;
    }

    @Override
    public PreTrainPredictionModelingParams regridifyToPreTrain(PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PreTrainPredictionModelingParams ret = this.getCopyWithGridStrategy(usedToTrain);
        ret.mllib_gbt_grid.max_depth.setToSingleValueGrid(Long.valueOf(optimized.mllib_gbt.max_depth));
        ret.mllib_gbt_grid.num_trees.setToSingleValueGrid(Long.valueOf(optimized.mllib_gbt.num_trees));
        return ret;
    }

    @Override
    public void regridifyToMLTask(PredictionModelingParams target, PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PreTrainPredictionModelingParams preTrain = this.regridifyToPreTrain(optimized, usedToTrain);
        target.mllib_gbt = preTrain.mllib_gbt_grid;
        target.mllib_gbt.enabled = true;
    }

    @Override
    public void refreshMLTask(PredictionModelingParams target, PreTrainPredictionModelingParams usedToTrain) {
        target.mllib_gbt = usedToTrain.mllib_gbt_grid;
        target.mllib_gbt.enabled = true;
    }
}

