/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.preprocessing;

import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.NumFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.PredictionPreprocessingParams;

public abstract class TabularPredictionPreprocessingParams
extends PredictionPreprocessingParams {
    public FeatureSelectionParams feature_selection_params = new FeatureSelectionParams();
    public double preprocessingFitSampleRatio = 1.0;
    public long preprocessingFitSampleSeed = 1337L;

    public boolean isMonotonicConstrainedEnabled() {
        return this.per_feature.values().stream().anyMatch(p -> p.role == FeaturePreprocessingParams.Role.INPUT && p.type == FeaturePreprocessingParams.FeatureType.NUMERIC && ((NumFeaturePreprocessingParams)p).monotonic != NumFeaturePreprocessingParams.MonotonicConstraintMethod.NONE);
    }

    public boolean isKeepMissingAsNaNEnabled() {
        return this.per_feature.values().stream().anyMatch(p -> p.role == FeaturePreprocessingParams.Role.INPUT && p.type == FeaturePreprocessingParams.FeatureType.NUMERIC && (((NumFeaturePreprocessingParams)p).missing_handling == NumFeaturePreprocessingParams.MissingHandlingMethod.KEEP_NAN_OR_DROP || ((NumFeaturePreprocessingParams)p).missing_handling == NumFeaturePreprocessingParams.MissingHandlingMethod.KEEP_NAN_OR_IMPUTE));
    }

    public static class FeatureSelectionParams {
        public FeatureSelectionMethod method = FeatureSelectionMethod.NONE;
        public RandomForestParams random_forest_params = new RandomForestParams();
        public LassoParams lasso_params = new LassoParams();
        public PCAParams pca_params = new PCAParams();
        public CorrelationParams correlation_params = new CorrelationParams();
        public CustomParams custom_params = new CustomParams();

        public static class RandomForestParams {
            public int n_trees = 30;
            public int depth = 10;
            public int n_features = 25;
        }

        public static class LassoParams {
            public double[] alpha = new double[]{0.01, 0.1, 1.0, 10.0, 100.0};
            public boolean cross_validate = true;
        }

        public static class PCAParams {
            public int n_features = 25;
            public double variance_proportion = 0.9;
        }

        public static class CorrelationParams {
            public double min_abs_correlation = 0.0;
            public double max_abs_correlation = 1.0;
            public int n_features = 25;
        }

        public static class CustomParams {
            public String code = "# type your code here";
        }
    }

    public static enum FeatureSelectionMethod {
        NONE,
        RANDOM_FOREST,
        LASSO,
        CORRELATION,
        PCA,
        CUSTOM;

    }
}

