/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.actual;

import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.projects.importexport.model.BundleContainerSettings;
import com.dataiku.dip.projects.importexport.model.ProjectRemappingSettings;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.webapps.WebAppsService;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractProjectDeploymentHeavyStatus
extends AbstractDeploymentHeavyStatus {
    @Nullable
    public String name;
    @Nullable
    public ProjectDeployerScenarioMonitoring monitoring;
    @Nullable
    public List<WebAppsService.BackendInfo> webappBackendInfoList;

    public AbstractProjectDeploymentHeavyStatus() {
    }

    public AbstractProjectDeploymentHeavyStatus(String deploymentId, String infraId) {
        super(deploymentId, infraId);
    }

    public void setOutOfSync(String message, DeployerCodes code) {
        this.setMessageAndHealthWithSeverity(InfoMessage.warning((InfoMessage.MessageCode)code, (String)message), DeploymentHealth.OUT_OF_SYNC);
    }

    public void setOutOfSync(String message) {
        this.setOutOfSync(message, DeployerCodes.ERR_PROJECT_DEPLOYER_AUTOMATION_NODE_PROJECT_OUT_OF_SYNC);
    }

    public static class InfoMap {
        public final Map<String, Info> map = new HashMap<String, Info>();

        public void putHeavyStatusInfo(String projectKey, Info info) {
            this.map.put(projectKey, info);
        }
    }

    public static class Info {
        public String activeBundleId;
        public Map<String, Boolean> scenarioActiveState = new HashMap<String, Boolean>();
        public List<WebAppsService.BackendInfo> webappBackendInfoList = new ArrayList<WebAppsService.BackendInfo>();
        public boolean isProjectAdmin;
        public boolean projectExists;
        public boolean disabledAutomaticTriggers;
        public BundleContainerSettings.PythonEnvsBehavior codeEnvsBehavior = new BundleContainerSettings.PythonEnvsBehavior();
        public List<ProjectRemappingSettings.ConnectionRemapping> connectionRemappings = new ArrayList<ProjectRemappingSettings.ConnectionRemapping>();
        public List<ProjectRemappingSettings.ContainerExecRemapping> containerExecRemappings = new ArrayList<ProjectRemappingSettings.ContainerExecRemapping>();
        public JsonObject localVariables;
        public ProjectDeployerScenarioMonitoring monitoring;
        public String errorMessage;
        public String name;
    }

    public static class ProjectDeployerScenarioMonitoring {
        public List<String> failed = new ArrayList<String>();
        public List<String> warning = new ArrayList<String>();
        public List<String> successful = new ArrayList<String>();
        public List<String> aborted = new ArrayList<String>();
        public List<String> running = new ArrayList<String>();
        public boolean hasScenarios;
        public boolean hasActiveScenarios;

        public void addScenarioOutcome(ScenarioRun run) {
            if (run.result == null) {
                this.running.add(run.scenario.name);
            } else {
                switch (run.result.outcome) {
                    case SUCCESS: {
                        this.successful.add(run.scenario.name);
                        break;
                    }
                    case FAILED: {
                        this.failed.add(run.scenario.name);
                        break;
                    }
                    case WARNING: {
                        this.warning.add(run.scenario.name);
                        break;
                    }
                    case ABORTED: {
                        this.aborted.add(run.scenario.name);
                    }
                }
            }
        }

        public void mergeFrom(@Nonnull ProjectDeployerScenarioMonitoring other) {
            this.hasScenarios = this.hasScenarios || other.hasScenarios;
            this.hasActiveScenarios = this.hasActiveScenarios || other.hasActiveScenarios;
            this.failed.addAll(other.failed);
            this.warning.addAll(other.warning);
            this.successful.addAll(other.successful);
            this.aborted.addAll(other.aborted);
            this.running.addAll(other.running);
        }

        public ProjectDeployerScenarioMonitoring copy() {
            ProjectDeployerScenarioMonitoring ret = new ProjectDeployerScenarioMonitoring();
            ret.failed = new ArrayList<String>(this.failed);
            ret.aborted = new ArrayList<String>(this.aborted);
            ret.warning = new ArrayList<String>(this.warning);
            ret.running = new ArrayList<String>(this.running);
            ret.successful = new ArrayList<String>(this.successful);
            ret.hasScenarios = this.hasScenarios;
            ret.hasActiveScenarios = this.hasActiveScenarios;
            return ret;
        }
    }
}

