/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.actual.azureml;

import com.dataiku.dip.apideployer.datamodel.actual.AbstractFullyManagedDeploymentSummary;
import com.dataiku.dip.apideployer.datamodel.actual.azureml.AzureMLDataModelBuilder;
import com.dataiku.dip.apideployer.datamodel.config.AzureMLAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AzureMLAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deploymentinfo.AzureMLDeploymentInfo;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLEnvironment;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLModel;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLOnlineDeployment;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLOnlineEndpoint;
import com.dataiku.dip.externalinfras.azureml.http.AzureMLHttpClient;
import com.dataiku.dip.variables.VariablesContext;
import java.io.IOException;
import javax.annotation.Nonnull;

public class AzureMLDeploymentSummary
extends AbstractFullyManagedDeploymentSummary {
    public String azSubscription;
    public String azResourceGroup;
    public String azWorkspace;
    public String azTenantId;
    public AzureMLModel model;
    public AzureMLEnvironment environment;
    public AzureMLOnlineEndpoint onlineEndpoint;
    public AzureMLOnlineDeployment onlineDeployment;

    public AzureMLDeploymentInfo asDeploymentInfo() {
        AzureMLDeploymentInfo deploymentInfo = new AzureMLDeploymentInfo(this.infraId, this.deploymentId);
        deploymentInfo.containerImageUri = this.environment.image;
        deploymentInfo.azSubscription = this.azSubscription;
        deploymentInfo.azResourceGroup = this.azResourceGroup;
        deploymentInfo.azWorkspace = this.azWorkspace;
        deploymentInfo.azTenantId = this.azTenantId;
        deploymentInfo.azModelName = this.model.name;
        deploymentInfo.azModelVersion = this.model.getVersion();
        deploymentInfo.modelProvisioningState = this.model.provisioningState;
        deploymentInfo.modelSystemData = this.model.systemData;
        deploymentInfo.azEnvironmentName = this.environment.name;
        deploymentInfo.azEnvironmentVersion = this.environment.getVersion();
        deploymentInfo.environmentProvisioningState = this.environment.provisioningState;
        deploymentInfo.environmentSystemData = this.environment.systemData;
        deploymentInfo.azOnlineEndpointName = this.onlineEndpoint.name;
        deploymentInfo.onlineEndpointProvisioningState = this.onlineEndpoint.provisioningState;
        deploymentInfo.onlineEndpointSystemData = this.onlineEndpoint.systemData;
        deploymentInfo.azOnlineDeploymentName = this.onlineDeployment.name;
        deploymentInfo.onlineDeploymentProvisioningState = this.onlineDeployment.provisioningState;
        deploymentInfo.onlineDeploymentSystemData = this.onlineDeployment.systemData;
        return deploymentInfo;
    }

    public AzureMLDeploymentSummary(String infraId, String deploymentId, String azSubscription, String azResourceGroup, String azWorkspace, String azTenantId) {
        super(infraId, deploymentId);
        this.azSubscription = azSubscription;
        this.azResourceGroup = azResourceGroup;
        this.azWorkspace = azWorkspace;
        this.azTenantId = azTenantId;
    }

    private AzureMLDeploymentSummary() {
    }

    private AzureMLDeploymentSummary(String infraId, String deploymentId) {
        super(infraId, deploymentId);
    }

    public static class AzureMLDeploymentSummaryBuilder {
        private AzureMLDeploymentSummaryBuilder() {
        }

        public static AzureMLDeploymentSummary buildFromLocalConfig(@Nonnull AzureMLAPIDeployment deployment, @Nonnull AzureMLAPIDeploymentInfra infra, @Nonnull VariablesContext vc, @Nonnull AzureMLDeploymentInfo deploymentInfo) {
            AzureMLDeploymentSummary deploymentSummary = new AzureMLDeploymentSummary(deployment.infraId, deployment.id);
            deploymentSummary.azSubscription = deploymentInfo.azSubscription;
            deploymentSummary.azResourceGroup = deploymentInfo.azResourceGroup;
            deploymentSummary.azWorkspace = deploymentInfo.azWorkspace;
            deploymentSummary.azTenantId = deploymentInfo.azTenantId;
            deploymentSummary.model = AzureMLDataModelBuilder.buildModelFromLocalConfig(deployment, infra, vc, deploymentInfo.getModelIdentifier());
            deploymentSummary.environment = AzureMLDataModelBuilder.buildEnvironmentFromLocalConfig(deployment, infra, vc, deploymentInfo.getEnvironmentIdentifier(), deploymentInfo.containerImageUri);
            deploymentSummary.onlineEndpoint = AzureMLDataModelBuilder.buildOnlineEndpointFromLocalConfig(deployment, infra, vc, deploymentInfo.getOnlineEndpointIdentifier(), deploymentInfo.getOnlineDeploymentIdentifier().name);
            deploymentSummary.onlineDeployment = AzureMLDataModelBuilder.buildOnlineDeploymentFromLocalConfig(deployment, infra, vc, deploymentInfo.getOnlineDeploymentIdentifier(), deploymentInfo.azOnlineEndpointName, deploymentInfo.getModelRef(), deploymentInfo.getEnvironmentRef());
            return deploymentSummary;
        }

        public static AzureMLDeploymentSummary buildFromRemoteConfig_NT(AzureMLHttpClient azureMLClient, AzureMLDeploymentInfo deploymentInfo) throws IOException {
            AzureMLDeploymentSummary deploymentSummary = new AzureMLDeploymentSummary(deploymentInfo.infraId, deploymentInfo.deploymentId);
            deploymentSummary.azSubscription = deploymentInfo.azSubscription;
            deploymentSummary.azResourceGroup = deploymentInfo.azResourceGroup;
            deploymentSummary.azWorkspace = deploymentInfo.azWorkspace;
            deploymentSummary.azTenantId = deploymentInfo.azTenantId;
            deploymentSummary.model = AzureMLDataModelBuilder.buildModelFromRemoteConfig_NT(azureMLClient, deploymentInfo.getModelIdentifier());
            deploymentSummary.environment = AzureMLDataModelBuilder.buildEnvironmentFromRemoteConfig_NT(azureMLClient, deploymentInfo.getEnvironmentIdentifier());
            deploymentSummary.onlineEndpoint = AzureMLDataModelBuilder.buildOnlineEndpointFromRemoteConfig_NT(azureMLClient, deploymentInfo.getOnlineEndpointIdentifier());
            deploymentSummary.onlineDeployment = AzureMLDataModelBuilder.buildOnlineDeploymentFromRemoteConfig_NT(azureMLClient, deploymentInfo.getOnlineDeploymentIdentifier());
            return deploymentSummary;
        }
    }
}

