/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.actual.databricks;

import com.dataiku.dip.apideployer.datamodel.actual.common.DeploymentResourceComparator;
import com.dataiku.dip.apideployer.datamodel.actual.databricks.AbstractDatabricksEndpointComparator;
import com.dataiku.dip.apideployer.datamodel.config.DatabricksAPIDeploymentInfra;
import com.dataiku.dip.externalinfras.databricks.DatabricksUtils;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServedEntity;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServingEndpointDetailedConfig;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServingEndpointDetails;
import com.dataiku.dip.externalinfras.databricks.datamodel.actual.DatabricksEndpoint;
import com.dataiku.dip.externalinfras.databricks.datamodel.actual.DatabricksEndpointConfig;
import com.dataiku.dip.externalinfras.databricks.datamodel.actual.DatabricksModelVersion;
import com.dataiku.dip.utils.CollectionUtils;
import com.dataiku.dip.utils.StringUtils;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DatabricksEndpointDetailsComparator
extends AbstractDatabricksEndpointComparator<DatabricksServingEndpointDetails> {
    @Nullable
    private final DatabricksModelVersion localModelVersion;

    public DatabricksEndpointDetailsComparator(@Nonnull DatabricksEndpoint endpoint, @Nullable DatabricksModelVersion localModelVersion) {
        super(endpoint);
        this.localModelVersion = localModelVersion;
    }

    @Override
    public Set<String> reportRecoverableOutOfSyncFields(@Nonnull DatabricksServingEndpointDetails deployedEndpoint) {
        Set<String> outOfSyncFields = super.reportRecoverableOutOfSyncFields(deployedEndpoint);
        DatabricksServingEndpointDetailedConfig deployedConfig = deployedEndpoint.getLatestConfig();
        Optional<DatabricksServedEntity> deployedServedEntityOpt = DatabricksUtils.getServedEntity(this.localModelVersion, deployedConfig);
        if (deployedServedEntityOpt.isPresent()) {
            outOfSyncFields.addAll(DatabricksEndpointDetailsComparator.reportServedEntityOutOfSyncFields(deployedServedEntityOpt.get(), this.localEndpoint.config));
        } else {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Model in endpoint", DatabricksEndpointDetailsComparator.getDeployedModelVersionName(deployedConfig), this.localModelVersion));
        }
        return outOfSyncFields;
    }

    @Nullable
    private static String getDeployedModelVersionName(@Nullable DatabricksServingEndpointDetailedConfig deployedConfig) {
        if (deployedConfig == null || deployedConfig.servedEntities == null || deployedConfig.servedEntities.isEmpty()) {
            return null;
        }
        DatabricksServedEntity firstModel = deployedConfig.servedEntities.get(0);
        String firstName = String.format("%s-%s", firstModel.entityName, firstModel.entityVersion);
        if (deployedConfig.servedEntities.size() == 1) {
            return firstName;
        }
        return firstName + " (and others)";
    }

    @Nonnull
    private static Set<String> reportServedEntityOutOfSyncFields(@Nonnull DatabricksServedEntity servedEntity, @Nonnull DatabricksEndpointConfig localConfig) {
        HashSet<String> outOfSyncFields = new HashSet<String>();
        if (!CollectionUtils.equalsOrBothEmpty(servedEntity.environmentVars, localConfig.environmentVars)) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Environment variables", DeploymentResourceComparator.censorValues(servedEntity.environmentVars), DeploymentResourceComparator.censorValues(localConfig.environmentVars)));
        }
        DatabricksAPIDeploymentInfra.ServedEntitySettings localEntitySettings = localConfig.servedEntitySettings;
        if (servedEntity.scaleToZeroEnabled != localEntitySettings.isScaleToZeroEnabled) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Scale to zero", servedEntity.scaleToZeroEnabled, localEntitySettings.isScaleToZeroEnabled));
        }
        if (!StringUtils.equalsOrBothBlank((String)servedEntity.workloadSize, (String)localEntitySettings.workloadSize)) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Compute scale-out", servedEntity.workloadSize, localEntitySettings.workloadSize));
        }
        if (!StringUtils.equalsOrBothBlank((String)servedEntity.workloadType, (String)localEntitySettings.workloadType)) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Compute type", servedEntity.workloadType, localEntitySettings.workloadType));
        }
        return outOfSyncFields;
    }
}

