/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.infra;

import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.datamodel.config.VertexAIAPIDeploymentInfra;
import com.dataiku.dip.apideployer.infra.ApiNodeInfraManager;
import com.dataiku.dip.apideployer.monitoring.ActivityMetric;
import com.dataiku.dip.apideployer.monitoring.VertexAIActivityMetricsFetchingService;
import com.dataiku.dip.connections.VertexAIModelDeploymentConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.vertexai.VertexAIUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.auth.oauth2.GoogleCredentials;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class VertexAIInfraManager
implements ApiNodeInfraManager {
    private final VertexAIAPIDeploymentInfra infra;
    @Autowired
    private VertexAIActivityMetricsFetchingService activityMetricsFetchingService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.infra.vertexai.manager");

    public VertexAIInfraManager(VertexAIAPIDeploymentInfra infra) {
        this.infra = infra;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public InfoMessage.InfoMessages checkInfraStatus_NT(AuthCtx authCtx) {
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        boolean isMissingProject = StringUtils.isBlank((String)this.infra.gcpProjectId);
        boolean isMissingRegion = StringUtils.isBlank((String)this.infra.gcpRegion);
        if (isMissingProject || isMissingRegion) {
            if (isMissingProject) {
                messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_VERTEXAI_MISSING_PROJECT, "GCP project is empty.");
            }
            if (isMissingRegion) {
                messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_VERTEXAI_MISSING_REGION, "GCP region is empty.");
            }
            return messages;
        }
        try {
            VertexAIModelDeploymentConnection connection = (VertexAIModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(authCtx, this.infra.authConnection);
            GoogleCredentials credentials = VertexAIUtils.getGoogleCredentials_NT(authCtx, connection);
            VertexAIUtils.from(this.infra.gcpRegion, this.infra.gcpProjectId, credentials, connection).retrieveEndpoints_NT();
        }
        catch (Exception e) {
            String errorMessage = "Vertex AI request failed with error " + String.valueOf(e);
            messages.withFatal((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_VERTEXAI_ERROR, errorMessage);
            logger.error((Object)errorMessage);
        }
        return messages;
    }

    @Override
    public ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint getActivityMetrics_NT(AuthCtx authCtx, int connectTimeout, int socketTimeout, String overridingConnectionName) {
        return this.activityMetricsFetchingService.getInfraActivityMetrics_NT(authCtx, this.infra, overridingConnectionName);
    }
}

