/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.AutomationNodeManagedEnvUtils;
import com.dataiku.dip.code.CodeEnvCodes;
import com.dataiku.dip.code.CodeEnvImportUtils;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvUtilsBase;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DSSInternalCodeEnvsService {
    @Autowired
    private DesignNodeCodeEnvsService designNodeEnvsService;
    @Autowired
    private AutomationNodeCodeEnvsService automationNodeEnvsService;
    private static final String OBJECT_DETECTION_CODE_ENV_LATEST_VERSION = "1";
    private static final String IMAGE_CLASSIFICATION_CODE_ENV_LATEST_VERSION = "1";
    private static final String PROXY_MODELS_CODE_ENV_LATEST_VERSION = "1";
    private static final String DATABRICKS_UTILS_CODE_ENV_LATEST_VERSION = "1";
    private static final String PII_DETECTION_CODE_ENV_LATEST_VERSION = "1";
    private static final String HUGGINGFACE_LOCAL_CODE_ENV_LATEST_VERSION = "1";
    private static final String RAG_CODE_ENV_LATEST_VERSION = "1";
    private static final String DOCUMENT_EXTRACTION_CODE_ENV_LATEST_VERSION = "1";
    private static final String INTERNAL_CODE_ENV_PREFIX = "INTERNAL_";
    private static final Map<Pair<DSSInternalCodeEnvType, String>, List<StandardPythonInterpreter>> supportedInterpreterMap = new HashMap<Pair<DSSInternalCodeEnvType, String>, List<StandardPythonInterpreter>>();
    private static final DKULogger logger;

    public static String getCodeEnvName(DSSInternalCodeEnvType dssInternalCodeEnvType) {
        return new DSSInternalCodeEnv(dssInternalCodeEnvType).getCodeEnvName();
    }

    public DSSInternalCodeEnvType getDSSInternalCodeEnvTypeForDeepHub(PredictionMLTask.PredictionType predictionType) {
        if (predictionType == PredictionMLTask.PredictionType.DEEP_HUB_IMAGE_OBJECT_DETECTION) {
            return DSSInternalCodeEnvType.DEEP_HUB_IMAGE_OBJECT_DETECTION_CODE_ENV;
        }
        if (predictionType == PredictionMLTask.PredictionType.DEEP_HUB_IMAGE_CLASSIFICATION) {
            return DSSInternalCodeEnvType.DEEP_HUB_IMAGE_CLASSIFICATION_CODE_ENV;
        }
        throw new IllegalArgumentException("Unsupported prediction type for DeepHub: " + String.valueOf((Object)predictionType));
    }

    public static List<StandardPythonInterpreter> getSupportedInterpreters(DSSInternalCodeEnvType dssInternalCodeEnvType, @Nullable String version) {
        DSSInternalCodeEnv dssInternalCodeEnv = new DSSInternalCodeEnv(dssInternalCodeEnvType, version);
        Pair codeEnvTypeVersionPair = new Pair((Object)dssInternalCodeEnv.codeEnvType, (Object)dssInternalCodeEnv.version);
        return supportedInterpreterMap.getOrDefault(codeEnvTypeVersionPair, Collections.emptyList());
    }

    public static List<StandardPythonInterpreter> getSupportedInterpreters(DSSInternalCodeEnvType dssInternalCodeEnvType) {
        return DSSInternalCodeEnvsService.getSupportedInterpreters(dssInternalCodeEnvType, null);
    }

    public static Optional<StandardPythonInterpreter> getPreferredInstalledInterpreterOrNull(DSSInternalCodeEnvType internalCodeEnvType, @Nullable String version, List<StandardPythonInterpreter> availablePythonInterpreters) {
        List<StandardPythonInterpreter> supportedPythonInterpreters = DSSInternalCodeEnvsService.getSupportedInterpreters(internalCodeEnvType, version);
        if (supportedPythonInterpreters == null || supportedPythonInterpreters.isEmpty()) {
            logger.errorV("No supported interpreter installed for internal code env '%s' with version '%s'.", new Object[]{internalCodeEnvType, version});
            return Optional.empty();
        }
        if (availablePythonInterpreters == null || availablePythonInterpreters.isEmpty()) {
            logger.error((Object)"No interpreter was found on the machine.");
            return Optional.empty();
        }
        StandardPythonInterpreter preferredInterpreter = StandardPythonInterpreter.getPreferredInIntersectionOrNull(supportedPythonInterpreters, availablePythonInterpreters);
        if (preferredInterpreter == null) {
            logger.errorV("None of the installed interpreters are supported for internal code env '%s' with version '%s'.", new Object[]{internalCodeEnvType, version});
            return Optional.empty();
        }
        logger.infoV("Preferred interpreter found for internal code env '%s' with version '%s': '%s'.", new Object[]{internalCodeEnvType, version, preferredInterpreter});
        return Optional.of(preferredInterpreter);
    }

    public Optional<CodeEnvModel.CodeEnvListItem> getCodeEnv_NT(DSSInternalCodeEnvType dssInternalCodeEnvType) throws IOException {
        return this.getCodeEnv_NT(dssInternalCodeEnvType, null);
    }

    public Optional<CodeEnvModel.CodeEnvListItem> getCodeEnv_NT(DSSInternalCodeEnvType dssInternalCodeEnvType, @Nullable String codeEnvVersion) throws IOException {
        CodeEnvModel.PythonEnvDesc desc;
        DSSInternalCodeEnv dssInternalCodeEnv = new DSSInternalCodeEnv(dssInternalCodeEnvType, codeEnvVersion);
        String codeEnvName = dssInternalCodeEnv.getCodeEnvName();
        try {
            switch (ApplicationConfigurator.getNodeType()) {
                case AUTOMATION: {
                    desc = AutomationNodeManagedEnvUtils.getEnvDesc(AutomationNodeCodeEnvsService.getEnvRootDir(CodeEnvModel.EnvLang.PYTHON, codeEnvName), CodeEnvModel.PythonEnvDesc.class);
                    break;
                }
                case DESIGN: {
                    desc = (CodeEnvModel.PythonEnvDesc)this.designNodeEnvsService.getEnvDesc(CodeEnvModel.EnvLang.PYTHON, codeEnvName);
                    break;
                }
                default: {
                    throw new Error("unsupported node type: " + String.valueOf((Object)ApplicationConfigurator.getNodeType()));
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
            desc = null;
        }
        if (desc == null) {
            return Optional.empty();
        }
        return Optional.of(CodeEnvUtilsBase.getListItemFromDesc(desc, codeEnvName));
    }

    public FutureResponse<CodeEnvModel.EnvCreationResult> createCodeEnv(AuthCtx authCtx, DSSInternalCodeEnvType dssInternalCodeEnvType, @Nullable String codeEnvVersion, String pythonInterpreter) throws Exception {
        DSSInternalCodeEnv dssInternalCodeEnv = new DSSInternalCodeEnv(dssInternalCodeEnvType, codeEnvVersion);
        CodeEnvModel.EnvLang envLang = CodeEnvModel.EnvLang.PYTHON;
        String envName = dssInternalCodeEnv.getCodeEnvName();
        File envFolder = dssInternalCodeEnv.getResourceSpecFolder();
        AutoDelete tempFolder = CodeEnvImportUtils.getTempImportFolder("import-dss-internal-" + envFolder.getName());
        DKUFileUtils.copyDirectory((File)envFolder, (File)tempFolder);
        File descFile = new File((File)tempFolder, "desc.json");
        CodeEnvModel.PythonEnvDesc envDesc = (CodeEnvModel.PythonEnvDesc)JSON.parse((String)DKUFileUtils.readFileToStringUTF8OrEmpty((File)descFile), CodeEnvModel.PythonEnvDesc.class);
        envDesc.pythonInterpreter = StandardPythonInterpreter.valueOf(pythonInterpreter);
        Pair codeEnvTypeVersionPair = new Pair((Object)dssInternalCodeEnv.codeEnvType, (Object)dssInternalCodeEnv.version);
        if (!supportedInterpreterMap.containsKey(codeEnvTypeVersionPair)) {
            throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_CREATION_FAILED, "Unknown version of DSS internal code env type for " + String.valueOf((Object)dssInternalCodeEnv.codeEnvType) + " with version: " + dssInternalCodeEnv.version);
        }
        if (!supportedInterpreterMap.get(codeEnvTypeVersionPair).contains((Object)envDesc.pythonInterpreter)) {
            throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_CREATION_FAILED, String.format("DSS internal code env type '%s' is only available for python: '%s'", new Object[]{dssInternalCodeEnv.codeEnvType, supportedInterpreterMap.get(codeEnvTypeVersionPair)}));
        }
        JSON.prettyToFile((Object)envDesc, (File)descFile);
        switch (ApplicationConfigurator.getNodeType()) {
            case AUTOMATION: {
                return this.automationNodeEnvsService.startImportEnv(authCtx, authCtx.getIdentifier(), envDesc.deploymentMode, envName, envLang, (File)tempFolder, (File)tempFolder, CodeEnvModel.CodeEnvUpdateSettings.forInternalEnv());
            }
            case DESIGN: {
                return this.designNodeEnvsService.startImportEnv(authCtx, authCtx.getIdentifier(), envDesc.deploymentMode, envName, envLang, (File)tempFolder, (File)tempFolder, CodeEnvModel.CodeEnvUpdateSettings.forInternalEnv());
            }
        }
        throw new Error("unsupported node type: " + String.valueOf((Object)ApplicationConfigurator.getNodeType()));
    }

    public FutureResponse<CodeEnvModel.EnvUpdateResult> updateCodeEnv(AuthCtx authCtx, DSSInternalCodeEnv dssInternalCodeEnv) throws Exception {
        return switch (ApplicationConfigurator.getNodeType()) {
            case ApplicationConfigurator.DSSNodeType.AUTOMATION -> this.automationNodeEnvsService.startUpdateEnvAccordingToSpec(authCtx, CodeEnvModel.EnvLang.PYTHON, dssInternalCodeEnv.getCodeEnvName(), CodeEnvModel.CodeEnvUpdateSettings.forInternalEnv());
            case ApplicationConfigurator.DSSNodeType.DESIGN -> this.designNodeEnvsService.startUpdateEnvAccordingToSpec(authCtx, CodeEnvModel.EnvLang.PYTHON, dssInternalCodeEnv.getCodeEnvName(), CodeEnvModel.CodeEnvUpdateSettings.forInternalEnv());
            default -> throw new Error("unsupported node type: " + String.valueOf((Object)ApplicationConfigurator.getNodeType()));
        };
    }

    public CodeEnvModel.CodeEnvListItem enrichCodeEnvListItemWithWarning(CodeEnvModel.CodeEnvListItem codeEnv, DSSInternalCodeEnvType dssInternalCodeEnvType, String internalCodeEnvVersion) throws IOException {
        if (codeEnv == null) {
            return null;
        }
        DSSInternalCodeEnv dssInternalCodeEnv = new DSSInternalCodeEnv(dssInternalCodeEnvType, internalCodeEnvVersion);
        CodeEnvModel.EnvSpecData<CodeEnvModel.AbstractEnvDesc> specData = switch (ApplicationConfigurator.getNodeType()) {
            case ApplicationConfigurator.DSSNodeType.AUTOMATION -> {
                File envRootDir = AutomationNodeCodeEnvsService.getEnvRootDir(CodeEnvModel.EnvLang.PYTHON, dssInternalCodeEnv.getCodeEnvName());
                File descFolder = DKUFileUtils.getWithin((File)envRootDir, (String[])new String[]{"desc"});
                CodeEnvModel.PythonEnvDesc desc = AutomationNodeManagedEnvUtils.getEnvDesc(envRootDir, CodeEnvModel.PythonEnvDesc.class);
                yield this.automationNodeEnvsService.getEnvSpecData(descFolder, desc, CodeEnvModel.EnvLang.PYTHON);
            }
            case ApplicationConfigurator.DSSNodeType.DESIGN -> this.designNodeEnvsService.getEnvSpecData(CodeEnvModel.EnvLang.PYTHON, dssInternalCodeEnv.getCodeEnvName());
            default -> throw new Error("unsupported node type: " + String.valueOf((Object)ApplicationConfigurator.getNodeType()));
        };
        return codeEnv.withOutdatedRequirementsWarning(dssInternalCodeEnv, specData).withOutdatedContainerImagesWarning();
    }

    static {
        supportedInterpreterMap.put((Pair<DSSInternalCodeEnvType, String>)new Pair((Object)DSSInternalCodeEnvType.DEEP_HUB_IMAGE_CLASSIFICATION_CODE_ENV, (Object)"1"), Arrays.asList(StandardPythonInterpreter.PYTHON36, StandardPythonInterpreter.PYTHON37, StandardPythonInterpreter.PYTHON38, StandardPythonInterpreter.PYTHON39, StandardPythonInterpreter.PYTHON310, StandardPythonInterpreter.PYTHON311, StandardPythonInterpreter.PYTHON312));
        supportedInterpreterMap.put((Pair<DSSInternalCodeEnvType, String>)new Pair((Object)DSSInternalCodeEnvType.DEEP_HUB_IMAGE_OBJECT_DETECTION_CODE_ENV, (Object)"1"), Arrays.asList(StandardPythonInterpreter.PYTHON36, StandardPythonInterpreter.PYTHON37, StandardPythonInterpreter.PYTHON38, StandardPythonInterpreter.PYTHON39, StandardPythonInterpreter.PYTHON310, StandardPythonInterpreter.PYTHON311, StandardPythonInterpreter.PYTHON312));
        supportedInterpreterMap.put((Pair<DSSInternalCodeEnvType, String>)new Pair((Object)DSSInternalCodeEnvType.PROXY_MODELS_CODE_ENV, (Object)"1"), Arrays.asList(StandardPythonInterpreter.PYTHON39, StandardPythonInterpreter.PYTHON310));
        supportedInterpreterMap.put((Pair<DSSInternalCodeEnvType, String>)new Pair((Object)DSSInternalCodeEnvType.DATABRICKS_UTILS_CODE_ENV, (Object)"1"), Arrays.asList(StandardPythonInterpreter.PYTHON39, StandardPythonInterpreter.PYTHON310));
        supportedInterpreterMap.put((Pair<DSSInternalCodeEnvType, String>)new Pair((Object)DSSInternalCodeEnvType.PII_DETECTION_CODE_ENV, (Object)"1"), Arrays.asList(StandardPythonInterpreter.PYTHON39, StandardPythonInterpreter.PYTHON310, StandardPythonInterpreter.PYTHON311, StandardPythonInterpreter.PYTHON312, StandardPythonInterpreter.PYTHON313));
        supportedInterpreterMap.put((Pair<DSSInternalCodeEnvType, String>)new Pair((Object)DSSInternalCodeEnvType.HUGGINGFACE_LOCAL_CODE_ENV, (Object)"1"), Arrays.asList(StandardPythonInterpreter.PYTHON39, StandardPythonInterpreter.PYTHON310, StandardPythonInterpreter.PYTHON311, StandardPythonInterpreter.PYTHON312));
        supportedInterpreterMap.put((Pair<DSSInternalCodeEnvType, String>)new Pair((Object)DSSInternalCodeEnvType.RAG_CODE_ENV, (Object)"1"), Arrays.asList(StandardPythonInterpreter.PYTHON39, StandardPythonInterpreter.PYTHON310, StandardPythonInterpreter.PYTHON311, StandardPythonInterpreter.PYTHON312, StandardPythonInterpreter.PYTHON313));
        supportedInterpreterMap.put((Pair<DSSInternalCodeEnvType, String>)new Pair((Object)DSSInternalCodeEnvType.DOCUMENT_EXTRACTION_CODE_ENV, (Object)"1"), Arrays.asList(StandardPythonInterpreter.PYTHON39, StandardPythonInterpreter.PYTHON310, StandardPythonInterpreter.PYTHON311, StandardPythonInterpreter.PYTHON312, StandardPythonInterpreter.PYTHON313));
        logger = DKULogger.getLogger((String)"dku.code.envs.dssinternal");
    }

    public static class DSSInternalCodeEnv {
        public final DSSInternalCodeEnvType codeEnvType;
        public final String version;

        public DSSInternalCodeEnv(DSSInternalCodeEnvType codeEnvType, String version) {
            this.codeEnvType = codeEnvType;
            if (StringUtils.isBlank((String)version)) {
                switch (codeEnvType) {
                    case PROXY_MODELS_CODE_ENV: {
                        version = "1";
                        break;
                    }
                    case DEEP_HUB_IMAGE_CLASSIFICATION_CODE_ENV: {
                        version = "1";
                        break;
                    }
                    case DEEP_HUB_IMAGE_OBJECT_DETECTION_CODE_ENV: {
                        version = "1";
                        break;
                    }
                    case DATABRICKS_UTILS_CODE_ENV: {
                        version = "1";
                        break;
                    }
                    case PII_DETECTION_CODE_ENV: {
                        version = "1";
                        break;
                    }
                    case HUGGINGFACE_LOCAL_CODE_ENV: {
                        version = "1";
                        break;
                    }
                    case RAG_CODE_ENV: {
                        version = "1";
                        break;
                    }
                    case DOCUMENT_EXTRACTION_CODE_ENV: {
                        version = "1";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported code env type: " + String.valueOf((Object)codeEnvType));
                    }
                }
            }
            this.version = version;
        }

        public DSSInternalCodeEnv(DSSInternalCodeEnvType dssInternalCodeEnvType) {
            this(dssInternalCodeEnvType, null);
        }

        public String getCodeEnvName() {
            return DSSInternalCodeEnv.getNameWithoutVersionId(this.codeEnvType) + this.version;
        }

        public File getResourceSpecFolder() {
            return DKUApp.getResourceFile((String[])new String[]{"code-envs", "python", this.codeEnvType.name.replace("_", "-"), "v" + this.version});
        }

        private static String getNameWithoutVersionId(DSSInternalCodeEnvType ceType) {
            return ceType.getPrefixedName() + "_v";
        }

        public static DSSInternalCodeEnv fromName(String codeEnvName) {
            for (DSSInternalCodeEnvType curCET : DSSInternalCodeEnvType.values()) {
                String nameWithoutVersionId = DSSInternalCodeEnv.getNameWithoutVersionId(curCET);
                if (!StringUtils.startsWith((String)codeEnvName, (String)nameWithoutVersionId)) continue;
                DSSInternalCodeEnvType ceType = curCET;
                String ceVersion = codeEnvName.substring(nameWithoutVersionId.length());
                return new DSSInternalCodeEnv(ceType, ceVersion);
            }
            throw new IllegalArgumentException("Code env name incompatible with DSS_INTERNAL deployment mode.");
        }

        public boolean isCompatibleWithInterpreter(StandardPythonInterpreter pythonInterpreter) {
            return DSSInternalCodeEnvsService.getSupportedInterpreters(this.codeEnvType, this.version).contains((Object)pythonInterpreter);
        }
    }

    public static enum DSSInternalCodeEnvType {
        DEEP_HUB_IMAGE_CLASSIFICATION_CODE_ENV("image_classification"),
        DEEP_HUB_IMAGE_OBJECT_DETECTION_CODE_ENV("object_detection"),
        PROXY_MODELS_CODE_ENV("proxy_models"),
        DATABRICKS_UTILS_CODE_ENV("databricks_utils"),
        PII_DETECTION_CODE_ENV("pii_detection"),
        HUGGINGFACE_LOCAL_CODE_ENV("huggingface_local"),
        RAG_CODE_ENV("retrieval_augmented_generation"),
        DOCUMENT_EXTRACTION_CODE_ENV("document_extraction");

        public final String name;

        private DSSInternalCodeEnvType(String name) {
            this.name = name;
        }

        public String getPrefixedName() {
            return DSSInternalCodeEnvsService.INTERNAL_CODE_ENV_PREFIX + this.name;
        }

        public static boolean isInternalCodeEnvName(String envName) {
            for (DSSInternalCodeEnvType curCET : DSSInternalCodeEnvType.values()) {
                if (!StringUtils.startsWith((String)envName, (String)curCET.getPrefixedName())) continue;
                return true;
            }
            return false;
        }
    }
}

