/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionCredentialUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.ConnectionWithPerUserOAuth2Credentials;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SimpleSQLDSSConnectionWithBasicCredential;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.security.model.OAuth2Client;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.sql.DenodoSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class DenodoConnection
extends SimpleSQLDSSConnectionWithBasicCredential
implements ConnectionWithEncryptedFields,
ConnectionWithPerUserOAuth2Credentials {
    public Params params = new Params();
    public static final String connectionType = "Denodo";
    private SQLDialect dialect = null;

    @Override
    public Params getParams() {
        return this.params;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public SQLDialect getDialect() {
        if (this.dialect == null) {
            this.dialect = new DenodoSQLDialect();
        }
        return this.dialect;
    }

    @Override
    String getDriver() {
        return "com.denodo.vdp.jdbc.Driver";
    }

    @Override
    String getJdbcUrl() {
        if (this.params.useURL) {
            if (StringUtils.isBlank((String)this.params.url)) {
                throw ErrorContext.iae((String)"Denodo connection JDBC URL is not set");
            }
            return this.params.url;
        }
        return String.format("jdbc:vdb://%s:%s/%s", this.params.host, this.params.port, this.params.db);
    }

    @Override
    public SQLConnectionProvider.SQLConnectionData getConnectionData_NT(AuthCtx authCtx, String projectKey) throws DKUSecurityException, SQLException {
        SerializableDenodoCredentials creds = this.getFullyResolvedCredentials_sqlLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), SerializableDenodoCredentials.class);
        SQLConnectionProvider.GenericSQLConnectionData cd = new SQLConnectionProvider.GenericSQLConnectionData(this.getType(), this.getDialect(), (AbstractSQLConnection)this, this.getDriver(), this.getJdbcUrl(), this.getJarsDirectory());
        this.fillConnectionData(cd);
        String publishCatalogsAsSchemas = "true";
        for (AbstractSQLConnection.CustomDatabaseProperty p : this.params.properties) {
            if (!"publishCatalogsAsSchemas".equals(p.name)) continue;
            publishCatalogsAsSchemas = p.value;
        }
        cd.withProperty("publishCatalogsAsSchemas", publishCatalogsAsSchemas);
        if (creds.authType == AuthType.PASSWORD) {
            cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("user", creds.user, false));
            cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("password", creds.password, true));
        } else if (creds.authType == AuthType.OAUTH2) {
            cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("useOAuth2", "true", false));
            cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("accessToken", creds.accessToken, true));
        }
        return cd;
    }

    @Override
    String getDisplayableJdbcUrl() {
        return this.params.useURL && StringUtils.isNotBlank((String)this.params.displayedUrl) ? this.params.displayedUrl : this.getJdbcUrl();
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
        this.params.appSecret = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.appSecret);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
        this.params.appSecret = cryptoService.decryptIfEncrypted(this.params.appSecret);
    }

    @Override
    public boolean actuallyHasBasicCredential() {
        return this.params.authType == AuthType.PASSWORD;
    }

    @Override
    public boolean actuallyHasPerUserOAuth2Credential() {
        return this.credentialsMode == DSSConnection.CredentialsMode.PER_USER && this.params.authType == AuthType.OAUTH2;
    }

    @Override
    public boolean hasRefreshTokenRotation() {
        return this.params.refreshTokenRotation;
    }

    @Override
    public boolean mustResolveOnBackend() {
        return this.hasRefreshTokenRotation() || super.mustResolveOnBackend();
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(SerializableDenodoCredentials.class));
        SerializableDenodoCredentials creds = new SerializableDenodoCredentials();
        creds.authType = this.params.authType;
        if (creds.authType == AuthType.PASSWORD) {
            ICredentialsService.BasicCredential basicCreds = ConnectionCredentialUtils.getDecryptedBasicCredential_autoTXN(this, ctx.authCtx);
            creds.user = basicCreds.user;
            creds.password = basicCreds.password;
        } else if (creds.authType == AuthType.OAUTH2) {
            OAuth2Client.AccessTokenResult accessTokenResult = this.getAccessToken(ctx.authCtx, this.getProxySettings());
            creds.accessToken = accessTokenResult.getAccessToken();
            creds.accessTokenExpiresOn = accessTokenResult.getExpiresOn() == null ? -1L : accessTokenResult.getExpiresOn().getTime();
        }
        return clazz.cast(creds);
    }

    @Override
    public OAuth2Client buildOAuth2Client(ProxySettings proxySettings, AuthCtx authCtx) throws DKUSecurityException {
        boolean useCache = this.getDkuPropertiesAsParams().getBoolParam("dku.connection.oauth.enableCache", true);
        return new OAuth2Client.Builder().authorizationEndpoint(this.params.authorizationEndpoint).tokenEndpoint(this.params.tokenEndpoint).clientId(this.params.appId).clientSecret(this.params.appSecret).scope(this.params.scope).usePkce(true).proxy(proxySettings).useAccessTokenCache(useCache).build();
    }

    @Override
    public ICredentialsService.OAuth2Credential getResolvedOAuth2Credential(AuthCtx authCtx) {
        return new ICredentialsService.OAuth2Credential(this.getAccessToken(authCtx, this.getProxySettings()).getAccessToken());
    }

    public OAuth2Client.AccessTokenResult getAccessToken(AuthCtx authCtx, ProxySettings proxySettings) {
        PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        this.decryptFields(cryptoService);
        boolean useCache = this.getDkuPropertiesAsParams().getBoolParam("dku.connection.oauth.enableCache", true);
        logger.info((Object)"Exchanging user's refresh token for an access token");
        try {
            OAuth2Client oAuth2Client = this.buildOAuth2Client(proxySettings, authCtx);
            if (this.credentialsMode == DSSConnection.CredentialsMode.PER_USER) {
                return this.getAccessTokenFromRefreshTokenAndUpdateIfNeeded(authCtx, oAuth2Client, false);
            }
            return oAuth2Client.acquireAccessTokenResultWithClientCredentialsGrant(useCache);
        }
        catch (DKUSecurityException e) {
            throw new CodedRuntimeException(e.getCode(), "Failed to get OAuth2 access token", (Throwable)e);
        }
        catch (ParseException | IOException | URISyntaxException e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Failed to get OAuth2 access token", e);
        }
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParamsWithStdFields {
        public int port;
        public AuthType authType = AuthType.PASSWORD;
        public String appId;
        public String appSecret;
        public String authorizationEndpoint;
        public String tokenEndpoint;
        public String scope;
        public boolean refreshTokenRotation;
    }

    static class SerializableDenodoCredentials
    implements ICredentialsService.BasicCredentialConvertible,
    OAuth2Client.AccessTokenCredentialConvertible {
        public AuthType authType;
        public String user;
        public String password;
        public String accessToken;
        public long accessTokenExpiresOn;

        SerializableDenodoCredentials() {
        }

        @Override
        public ICredentialsService.BasicCredential toBasicCredential() {
            return new ICredentialsService.BasicCredential(this.user, this.password);
        }

        @Override
        public OAuth2Client.SerializableAccessTokenResult toSerializableAccessTokenResult() {
            return new OAuth2Client.SerializableAccessTokenResult(this.accessToken, this.accessTokenExpiresOn);
        }
    }

    public static enum AuthType {
        PASSWORD,
        OAUTH2;

    }
}

