/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SimpleDSSConnectionWithBasicCredential;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.variables.VariablesContext;
import java.util.ArrayList;
import java.util.List;

public class DynamoDBConnection
extends SimpleDSSConnectionWithBasicCredential
implements ConnectionWithEncryptedFields {
    public Params params = new Params();
    public static final String connectionType = "DynamoDB";

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
        if (!this.params.useDefaultCredentials) {
            this.params.accessKey = vc.expand(this.params.accessKey);
            this.params.secretKey = vc.expand(this.params.secretKey);
        }
        this.params.regionOrEndpoint = vc.expand(this.params.regionOrEndpoint);
        this.params.hostname = vc.expand(this.params.hostname);
    }

    @Override
    public boolean actuallyHasBasicCredential() {
        return this.params != null && !this.params.useDefaultCredentials;
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.accessKey, this.params.secretKey);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        if (securitySettings.secureSecretKeys) {
            this.params.secretKey = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.secretKey);
        }
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.secretKey = cryptoService.decryptIfEncrypted(this.params.secretKey);
    }

    @Override
    public List<AbstractSQLConnection.CustomDatabaseProperty> getDkuProperties() {
        return this.params.dkuProperties;
    }

    @Override
    public String toString() {
        return "DynamoDBConnection{name='" + this.name + "', type='" + this.type + "', params=" + String.valueOf(this.params) + "}";
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testDynamoDB(authCtx, this);
    }

    public static class Params
    extends DSSConnection.DkuConnectionParams {
        public boolean useDefaultCredentials = false;
        public String accessKey;
        public String secretKey;
        public String regionOrEndpoint;
        public ConnectionMode mode;
        public int port;
        public String hostname;
        public CapacityMode rwCapacityMode;
        public long readCapacity = 1L;
        public long writeCapacity = 1L;
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();

        public String toString() {
            return "Params{useDefaultCredentials=" + this.useDefaultCredentials + ", accessKey='" + this.accessKey + "', regionOrEndpoint='" + this.regionOrEndpoint + "', mode=" + String.valueOf((Object)this.mode) + ", port=" + this.port + ", hostname='" + this.hostname + "', rwCapacityMode=" + String.valueOf((Object)this.rwCapacityMode) + ", readCapacity=" + this.readCapacity + ", writeCapacity=" + this.writeCapacity + "}";
        }

        public static enum ConnectionMode {
            LOCAL,
            WEBSERVICE;

        }

        public static enum CapacityMode {
            ON_DEMAND,
            PROVISIONED;

        }
    }
}

