/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.custom;

import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.agents.tools.AgentToolsRegistry;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.coreservices.MLBaseService;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPluginsService;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.prediction.CustomPythonPredictionAlgoService;
import com.dataiku.dip.analysis.ml.prediction.LoadedCustomPythonPredictionAlgoDesc;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterRegistry;
import com.dataiku.dip.cluster.ClustersService;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.custom.IElementLoadedDesc;
import com.dataiku.dip.custom.IPluginifiedHolderMeta;
import com.dataiku.dip.custom.IPluginifiedMeta;
import com.dataiku.dip.custom.UnavailablePluginItemInfo;
import com.dataiku.dip.dao.AnalysisCoreDAO;
import com.dataiku.dip.dao.ClustersDAO;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderBuildersRegistry;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnavailableDSSObjectException;
import com.dataiku.dip.exceptions.UnavailableTypeException;
import com.dataiku.dip.export.CustomExportersRegistry;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.lambda.mgmt.LambdaServicesDAO;
import com.dataiku.dip.llm.governance.GuardrailsPipelineSettings;
import com.dataiku.dip.llm.governance.GuardrailsRegistry;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import com.dataiku.dip.llm.promptstudio.PromptStudioDAO;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.metrics.checks.CheckType;
import com.dataiku.dip.metrics.checks.CustomPythonCheck;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.pivot.frontend.model.ChartType;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.projectstandards.ProjectStandardsCheck;
import com.dataiku.dip.projectstandards.ProjectStandardsConfigurableCheckRegistry;
import com.dataiku.dip.projectstandards.ProjectStandardsService;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.nlp.prompt.PromptRecipePayloadParams;
import com.dataiku.dip.savedmodels.SavedModelsAgentsBaseService;
import com.dataiku.dip.savedmodels.agents.AgentTypesRegistry;
import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.scheduler.runnables.DSSRunnableRegistry;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRegistry;
import com.dataiku.dip.scheduler.steps.FlowComputableSpecification;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepRegistry;
import com.dataiku.dip.scheduler.triggers.TriggerRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.server.controllers.PluginsController;
import com.dataiku.dip.server.services.ExploresService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.sql.AbstractSqlQueryWithSchemaBuilder;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppRegistry;
import com.dataiku.dip.webapps.WebAppsDAO;
import com.dataiku.dip.webapps.plugins.CustomWebAppDesc;
import com.dataiku.dip.webapps.plugins.CustomWebAppsService;
import com.dataiku.dip.webapps.plugins.LoadedCustomWebApp;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.DSSLambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.DSSPredictionEndpointConfig;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.google.api.client.util.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluginUsagesInspector {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ClustersDAO clustersDAO;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private LambdaServicesDAO lambdaServicesDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private ScenariosDAO scenariosDAO;
    @Autowired
    private WebAppsDAO webAppsDAO;
    @Autowired
    private AnalysisCoreDAO analysisCoreDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private MLPluginsService mlPluginsService;
    @Autowired
    private CustomPythonPredictionAlgoService customPythonPredictionAlgoService;
    @Autowired
    private MLBaseService mLBaseService;
    @Autowired
    private PredictionSMMgmtService predictionSMMgmtService;
    @Autowired
    private SavedModelsCRUDService smCRUDService;
    @Autowired
    private ProjectStandardsService projectStandardsService;
    @Autowired
    private ExploresService exploresService;
    @Autowired
    private CustomWebAppsService customWebAppsService;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private AgentToolsDAO agentToolsDAO;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private PromptStudioDAO promptStudioDAO;
    @Autowired
    public VariablesService variablesService;
    @Autowired
    public ClustersService clustersService;
    @Autowired
    IPermissionsService permissionsService;
    @Autowired
    IPluginsRegistryService pluginsRegistry;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.plugin.usages");

    public void restrictToAdminAndDevPluginDeveloper(AuthCtx authCtx, String pluginId) throws DKUSecurityException, CodedException {
        InstalledPluginDesc installedDesc = PluginsController.getInstalledPluginDesc(this.pluginsRegistry, pluginId);
        try {
            if (installedDesc.origin == InstalledPluginDesc.PluginOrigin.DEV) {
                this.permissionsService.checkDevelopPluginPrivilege(authCtx);
            } else {
                this.permissionsService.checkAdmin(authCtx);
            }
        }
        catch (Exception exception) {
            logger.warnV((Throwable)exception, "Plugin %s is restricted to admins and plugin developers", new Object[]{pluginId});
            throw new DKUSecurityException("Restricted to admins and plugin developers");
        }
    }

    public PluginUsages getUsages(AuthCtx authCtx, String projectKey, String pluginId) throws DKUSecurityException, CodedException {
        this.restrictToAdminAndDevPluginDeveloper(authCtx, pluginId);
        return this.getUsages(projectKey, pluginId);
    }

    public PluginUsages getUsages(String projectKey, String pluginId) {
        PluginUsages pluginUsages = new PluginUsages();
        this.getUsages(projectKey, pluginId, pluginUsages);
        return pluginUsages;
    }

    private void getUsages(String projectKey, String pluginId, PluginUsages usages) {
        assert (null != usages);
        if (StringUtils.isBlank((String)projectKey)) {
            MissingType missingType;
            try {
                for (String string : this.listProjectKeys_autoTxn()) {
                    this.getUsages(string, pluginId, usages);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to list uses of plugin " + pluginId + " in all projects"), (Throwable)e);
            }
            try {
                for (Cluster cluster : this.listClusters_autoTxn()) {
                    try {
                        this.getUsages(cluster, pluginId, cluster, null, usages);
                    }
                    catch (UnavailableTypeException ute) {
                        missingType = new MissingType(ute.missingType, "cluster", null, null, ute.missingPluginId);
                        logger.warn((Object)("Found missing type " + missingType.missingType));
                        usages.missingTypes.add(missingType);
                    }
                    catch (UnavailableDSSObjectException udoe) {
                        missingType = new MissingType(udoe.unavailableStepInfo.elementId, "cluster", null, null, udoe.unavailableStepInfo.pluginId);
                        logger.warnV("Found missing type %s in at least one %s in project %s", new Object[]{missingType.missingType, missingType.objectType, null});
                        usages.missingTypes.add(missingType);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unable to list uses of plugin " + pluginId + " in cluster " + cluster.id), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to list uses of plugin " + pluginId + " in all clusters"), (Throwable)e);
            }
            try {
                for (DSSConnection dSSConnection : this.listConnections_autoTxn()) {
                    try {
                        this.getConnectionUsages(dSSConnection, pluginId, dSSConnection, projectKey, usages);
                    }
                    catch (UnavailableTypeException ute) {
                        missingType = new MissingType(ute.missingType, "connection", null, null, ute.missingPluginId);
                        logger.warn((Object)("Found missing type " + missingType.missingType));
                        usages.missingTypes.add(missingType);
                    }
                    catch (UnavailableDSSObjectException udoe) {
                        missingType = new MissingType(udoe.unavailableStepInfo.elementId, "connection", null, null, udoe.unavailableStepInfo.pluginId);
                        logger.warnV("Found missing type %s in at least one %s in project %s", new Object[]{missingType.missingType, missingType.objectType, null});
                        usages.missingTypes.add(missingType);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unable to list uses of plugin " + pluginId + " in connection " + dSSConnection.name), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to list uses of plugin " + pluginId + " in all connections"), (Throwable)e);
            }
            try {
                for (ProjectStandardsCheck projectStandardsCheck : this.listProjectStandards()) {
                    try {
                        this.getUsages(projectStandardsCheck, pluginId, projectStandardsCheck, null, usages);
                    }
                    catch (UnavailableTypeException ute) {
                        missingType = new MissingType(ute.missingType, this.getCategoryName(projectStandardsCheck), null, this.getObjectId(projectStandardsCheck), ute.missingPluginId);
                        logger.warnV("Found missing type %s", new Object[]{missingType.missingType});
                        usages.missingTypes.add(missingType);
                    }
                    catch (UnavailableDSSObjectException udoe) {
                        missingType = new MissingType(udoe.unavailableStepInfo.elementId, this.getCategoryName(projectStandardsCheck), null, this.getObjectId(projectStandardsCheck), udoe.unavailableStepInfo.pluginId);
                        logger.warn((Object)("Found missing type " + missingType.missingType + " in at least one " + missingType.objectType));
                        usages.missingTypes.add(missingType);
                    }
                    catch (Exception e) {
                        logger.warnV("Error analyzing project standards check " + projectStandardsCheck.id, new Object[]{e});
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to list uses of plugin " + pluginId + " in all project standards checks" + projectKey), (Throwable)e);
            }
            try (Transaction t = this.transactionService.beginRead();){
                usages.missingTypes.addAll(this.clustersDAO.listMissingTypes());
            }
            catch (Exception e) {
                logger.error((Object)("Unable to list uses of plugin " + pluginId + " in all clusters"), (Throwable)e);
            }
        } else {
            MissingType missingType;
            try {
                for (SerializedRecipe serializedRecipe : this.listRecipes_autoTxn(projectKey)) {
                    try {
                        this.getRecipeUsages(serializedRecipe, pluginId, serializedRecipe, projectKey, usages);
                    }
                    catch (UnavailableTypeException ute) {
                        missingType = new MissingType(ute.missingType, "serialized recipe", projectKey, null, ute.missingPluginId);
                        logger.warn((Object)("Found missing type " + missingType.missingType));
                        usages.missingTypes.add(missingType);
                    }
                    catch (UnavailableDSSObjectException udoe) {
                        missingType = new MissingType(udoe.unavailableStepInfo.elementId, "serialized recipe", projectKey, null, udoe.unavailableStepInfo.pluginId);
                        logger.warnV("Found missing type " + missingType.missingType + " in at least one " + missingType.objectType + " in project " + projectKey, new Object[0]);
                        usages.missingTypes.add(missingType);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unable to list uses of plugin " + pluginId + " in recipe " + serializedRecipe.getId() + " of project " + projectKey), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to list uses of plugin " + pluginId + " in recipes of project " + projectKey), (Throwable)e);
            }
            try {
                List<LoadedCustomWebApp> pluginWebapps = this.customWebAppsService.list().stream().filter(webApp -> StringUtils.equals((String)pluginId, (String)webApp.ownerPluginId)).toList();
                for (SerializedDataset dataset : this.listDatasets_autoTxn(projectKey)) {
                    try {
                        this.getUsages(dataset, pluginId, dataset, projectKey, usages);
                    }
                    catch (UnavailableTypeException ute) {
                        MissingType missingType2 = new MissingType(ute.missingType, "dataset", projectKey, null, ute.missingPluginId);
                        logger.warn((Object)("Found missing type " + missingType2.missingType));
                        usages.missingTypes.add(missingType2);
                    }
                    catch (UnavailableDSSObjectException udoe) {
                        MissingType missingType2 = new MissingType(udoe.unavailableStepInfo.elementId, "dataset", projectKey, null, udoe.unavailableStepInfo.pluginId);
                        logger.warnV("Found missing type " + missingType2.missingType + " in at least one " + missingType2.objectType + " in project " + projectKey, new Object[0]);
                        usages.missingTypes.add(missingType2);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unable to list uses of plugin " + pluginId + " in dataset " + dataset.getId() + " of project " + projectKey), (Throwable)e);
                    }
                    Transaction t = this.transactionService.retrieveOrBeginRead();
                    try {
                        for (LoadedCustomWebApp webApp2 : pluginWebapps) {
                            try {
                                this.getWebappExploreUsage(projectKey, webApp2, dataset, usages);
                            }
                            catch (UnavailableTypeException ute) {
                                MissingType missingType3 = new MissingType(ute.missingType, this.getCategoryName(webApp2), projectKey, this.getObjectId(webApp2), ute.missingPluginId);
                                logger.warnV("Found missing type %s for %s %s in project %s", new Object[]{missingType3.missingType, missingType3.objectType, missingType3.objectId, projectKey});
                                usages.missingTypes.add(missingType3);
                            }
                            catch (UnavailableDSSObjectException udoe) {
                                MissingType missingType3 = new MissingType(udoe.unavailableStepInfo.elementId, "dataset", projectKey, null, udoe.unavailableStepInfo.pluginId);
                                logger.warn((Object)("Found missing type " + missingType3.missingType + " in at least one " + missingType3.objectType + " in project " + projectKey));
                                usages.missingTypes.add(missingType3);
                            }
                            catch (Exception e) {
                                logger.errorV((Throwable)e, "Error analyzing webapp %s of project %s", new Object[]{webApp2.getId(), projectKey});
                            }
                        }
                    }
                    finally {
                        if (t == null) continue;
                        t.close();
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to list uses of plugin " + pluginId + " in datasets of project " + projectKey), (Throwable)e);
            }
            try {
                for (Scenario scenario : this.listScenarios_autoTxn(projectKey)) {
                    try {
                        this.getUsages(scenario, pluginId, scenario, projectKey, usages);
                    }
                    catch (UnavailableTypeException ute) {
                        missingType = new MissingType(ute.missingType, "scenario", projectKey, null, ute.missingPluginId);
                        logger.warn((Object)("Found missing type " + missingType.missingType));
                        usages.missingTypes.add(missingType);
                    }
                    catch (UnavailableDSSObjectException udoe) {
                        missingType = new MissingType(udoe.unavailableStepInfo.elementId, "scenario", projectKey, null, udoe.unavailableStepInfo.pluginId);
                        logger.warn((Object)("Found missing type " + missingType.missingType + " in at least one " + missingType.objectType + " in project " + projectKey));
                        usages.missingTypes.add(missingType);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unable to list uses of plugin " + pluginId + " in scenario " + scenario.id + " of project " + projectKey), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to list uses of plugin " + pluginId + " in scenarios of project " + projectKey), (Throwable)e);
            }
            try {
                for (WebApp webApp2 : this.listWebApps_autoTxn(projectKey)) {
                    try {
                        this.getUsages(webApp2, pluginId, webApp2, projectKey, usages);
                    }
                    catch (UnavailableTypeException ute) {
                        missingType = new MissingType(ute.missingType, "webapp", projectKey, null, ute.missingPluginId);
                        logger.warn((Object)("Found missing type " + missingType.missingType));
                        usages.missingTypes.add(missingType);
                    }
                    catch (UnavailableDSSObjectException udoe) {
                        missingType = new MissingType(udoe.unavailableStepInfo.elementId, "webapp", projectKey, null, udoe.unavailableStepInfo.pluginId);
                        logger.warn((Object)("Found missing type " + missingType.missingType + " in at least one " + missingType.objectType + " in project " + projectKey));
                        usages.missingTypes.add(missingType);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unable to list uses of plugin " + pluginId + " in webapp " + webApp2.getId() + " of project " + projectKey), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to list uses of plugin " + pluginId + " in webapps of project " + projectKey), (Throwable)e);
            }
            try {
                for (AnalysisCoreParams analysisCoreParams : this.listAnalyses_autoTxn(projectKey)) {
                    try {
                        this.getAnalysisUsages(analysisCoreParams, pluginId, analysisCoreParams, projectKey, usages);
                    }
                    catch (UnavailableTypeException ute) {
                        missingType = new MissingType(ute.missingType, this.getCategoryName(analysisCoreParams), projectKey, this.getObjectId(analysisCoreParams), ute.missingPluginId);
                        logger.warnV("Found missing type %s for %s %s in project %s", new Object[]{missingType.missingType, missingType.objectType, missingType.objectId, projectKey});
                        usages.missingTypes.add(missingType);
                    }
                    catch (UnavailableDSSObjectException udoe) {
                        missingType = new MissingType(udoe.unavailableStepInfo.elementId, "analysis", projectKey, null, udoe.unavailableStepInfo.pluginId);
                        logger.warn((Object)("Found missing type " + missingType.missingType + " in at least one " + missingType.objectType + " in project " + projectKey));
                        usages.missingTypes.add(missingType);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unable to list uses of plugin " + pluginId + " in analysis " + analysisCoreParams.getFullId()), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to list uses of plugin " + pluginId + " in analysis of project " + projectKey), (Throwable)e);
            }
            try {
                for (SavedModel savedModel : this.listSavedModels_autoTxn(projectKey)) {
                    try {
                        this.getSavedModelsUsages(savedModel, pluginId, savedModel, projectKey, usages);
                    }
                    catch (UnavailableTypeException ute) {
                        missingType = new MissingType(ute.missingType, this.getCategoryName(savedModel), projectKey, this.getObjectId(savedModel), ute.missingPluginId);
                        logger.warnV("Found missing type %s for %s %s in project %s", new Object[]{missingType.missingType, missingType.objectType, missingType.objectId, projectKey});
                        usages.missingTypes.add(missingType);
                    }
                    catch (UnavailableDSSObjectException udoe) {
                        missingType = new MissingType(udoe.unavailableStepInfo.elementId, "saved model", projectKey, null, udoe.unavailableStepInfo.pluginId);
                        logger.warn((Object)("Found missing type " + missingType.missingType + " in at least one " + missingType.objectType + " in project " + projectKey));
                        usages.missingTypes.add(missingType);
                    }
                    catch (Exception e) {
                        logger.warnV((Throwable)e, "Error analyzing saved model %s", new Object[]{savedModel.getFullId()});
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to list uses of plugin " + pluginId + " in saved models of project " + projectKey), (Throwable)e);
            }
            try {
                for (AgentTool agentTool : this.listAgentTools_autoTxn(projectKey)) {
                    try {
                        this.getAgentToolUsages(agentTool, pluginId, agentTool, projectKey, usages);
                    }
                    catch (UnavailableTypeException ute) {
                        missingType = new MissingType(ute.missingType, this.getCategoryName(agentTool), projectKey, this.getObjectId(agentTool), ute.missingPluginId);
                        logger.warnV("Found missing type %s for %s %s in project %s", new Object[]{missingType.missingType, missingType.objectType, missingType.objectId, projectKey});
                        usages.missingTypes.add(missingType);
                    }
                    catch (UnavailableDSSObjectException udoe) {
                        missingType = new MissingType(udoe.unavailableStepInfo.elementId, "agent tool", projectKey, null, udoe.unavailableStepInfo.pluginId);
                        logger.warn((Object)("Found missing type " + missingType.missingType + " in at least one " + missingType.objectType + " in project " + projectKey));
                        usages.missingTypes.add(missingType);
                    }
                    catch (Exception e) {
                        logger.warnV((Throwable)e, "Error analyzing agent tool %s", new Object[]{agentTool.getFullId()});
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to list uses of plugin " + pluginId + " in agent tools of project " + projectKey), (Throwable)e);
            }
            try {
                for (PromptStudio promptStudio : this.listPromptStudios_autoTxn(projectKey)) {
                    try {
                        this.getPromptStudioUsages(promptStudio, pluginId, promptStudio, projectKey, usages);
                    }
                    catch (UnavailableTypeException ute) {
                        missingType = new MissingType(ute.missingType, this.getCategoryName(promptStudio), projectKey, this.getObjectId(promptStudio), ute.missingPluginId);
                        logger.warnV("Found missing type %s for %s %s in project %s", new Object[]{missingType.missingType, missingType.objectType, missingType.objectId, projectKey});
                        usages.missingTypes.add(missingType);
                    }
                    catch (UnavailableDSSObjectException udoe) {
                        missingType = new MissingType(udoe.unavailableStepInfo.elementId, "prompt studio", projectKey, null, udoe.unavailableStepInfo.pluginId);
                        logger.warn((Object)("Found missing type " + missingType.missingType + " in at least one " + missingType.objectType + " in project " + projectKey));
                        usages.missingTypes.add(missingType);
                    }
                    catch (Exception e) {
                        logger.warnV((Throwable)e, "Error analyzing prompt studio %s", new Object[]{promptStudio.getFullId()});
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to list uses of plugin " + pluginId + " in prompt studios of project " + projectKey), (Throwable)e);
            }
            try {
                this.getVirtualWebappUsage(projectKey, pluginId, usages);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to list uses of plugin " + pluginId + " in virtual webapps of project " + projectKey), (Throwable)e);
            }
            try {
                for (LambdaService lambdaService : this.listLambdaService_autoTxn(projectKey)) {
                    try {
                        this.getLambdaServicesUsages(lambdaService, pluginId, lambdaService, projectKey, usages);
                    }
                    catch (UnavailableTypeException ute) {
                        missingType = new MissingType(ute.missingType, this.getCategoryName(lambdaService), projectKey, this.getObjectId(lambdaService), ute.missingPluginId);
                        logger.warnV("Found missing type %s for %s %s in project %s", new Object[]{missingType.missingType, missingType.objectType, missingType.objectId, projectKey});
                        usages.missingTypes.add(missingType);
                    }
                    catch (UnavailableDSSObjectException udoe) {
                        missingType = new MissingType(udoe.unavailableStepInfo.elementId, "virtual webapp", projectKey, null, udoe.unavailableStepInfo.pluginId);
                        logger.warn((Object)("Found missing type " + missingType.missingType + " in at least one " + missingType.objectType + " in project " + projectKey));
                        usages.missingTypes.add(missingType);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Error analyzing usage of lambda service " + lambdaService.id + " of project " + projectKey), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to list uses of plugin " + pluginId + " in API designer services of project " + projectKey), (Throwable)e);
            }
        }
    }

    private List<String> listProjectKeys_autoTxn() throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.projectsService.listProjectKeys();
        }
        try (Transaction t = this.transactionService.beginRead();){
            List<String> list = this.projectsService.listProjectKeys();
            return list;
        }
    }

    private List<LambdaService> listLambdaService_autoTxn(String projectKey) throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.lambdaServicesDAO.listUnsafe(projectKey);
        }
        try (Transaction t = this.transactionService.beginRead();){
            List<LambdaService> list = this.lambdaServicesDAO.listUnsafe(projectKey);
            return list;
        }
    }

    private List<Cluster> listClusters_autoTxn() throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.clustersDAO.listUnsafe();
        }
        try (Transaction t = this.transactionService.beginRead();){
            List<Cluster> list = this.clustersDAO.listUnsafe();
            return list;
        }
    }

    private List<DSSConnection> listConnections_autoTxn() throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return new ArrayList<DSSConnection>(this.connectionsDAO.listUnsafe().values());
        }
        try (Transaction t = this.transactionService.beginRead();){
            ArrayList<DSSConnection> arrayList = new ArrayList<DSSConnection>(this.connectionsDAO.listUnsafe().values());
            return arrayList;
        }
    }

    private List<Scenario> listScenarios_autoTxn(String projectKey) throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.scenariosDAO.listUnsafe(projectKey);
        }
        try (Transaction t = this.transactionService.beginRead();){
            List<Scenario> list = this.scenariosDAO.listUnsafe(projectKey);
            return list;
        }
    }

    private List<AgentTool> listAgentTools_autoTxn(String projectKey) throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.agentToolsDAO.listUnsafe(projectKey);
        }
        try (Transaction t = this.transactionService.beginRead();){
            List<AgentTool> list = this.agentToolsDAO.listUnsafe(projectKey);
            return list;
        }
    }

    private List<PromptStudio> listPromptStudios_autoTxn(String projectKey) throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.promptStudioDAO.listUnsafe(projectKey);
        }
        try (Transaction t = this.transactionService.beginRead();){
            List<PromptStudio> list = this.promptStudioDAO.listUnsafe(projectKey);
            return list;
        }
    }

    private List<ProjectStandardsCheck> listProjectStandards() throws IOException {
        return this.projectStandardsService.getChecksUnsafe();
    }

    private List<SerializedDataset> listDatasets_autoTxn(String projectKey) throws IOException {
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            List ret = this.datasetsDAO.listUnsafe(projectKey);
            for (DatasetLocUtils.DatasetLoc datasetLoc : this.projectsService.getExposedDatasets(projectKey)) {
                try {
                    SerializedDataset accessibleDataset = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(datasetLoc);
                    if (accessibleDataset == null) continue;
                    ret.add(accessibleDataset);
                }
                catch (Exception e) {
                    logger.errorV((Throwable)e, "Failed to read dataset %s", new Object[]{datasetLoc.getFullName()});
                }
            }
            List list = ret;
            return list;
        }
    }

    private List<SerializedRecipe> listRecipes_autoTxn(String projectKey) throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.recipesDAO.listUnsafe(projectKey);
        }
        try (Transaction t = this.transactionService.beginRead();){
            List<SerializedRecipe> list = this.recipesDAO.listUnsafe(projectKey);
            return list;
        }
    }

    private List<AnalysisCoreParams> listAnalyses_autoTxn(String projectKey) throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.analysisCoreDAO.listUnsafe(projectKey);
        }
        try (Transaction t = this.transactionService.beginRead();){
            List<AnalysisCoreParams> list = this.analysisCoreDAO.listUnsafe(projectKey);
            return list;
        }
    }

    private List<SavedModel> listSavedModels_autoTxn(String projectKey) throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.savedModelsDAO.listUnsafe(projectKey);
        }
        try (Transaction t = this.transactionService.beginRead();){
            List<SavedModel> list = this.savedModelsDAO.listUnsafe(projectKey);
            return list;
        }
    }

    private List<ManagedFolder> listManagedFolders_autoTxn(String projectKey) throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.managedFolderDAO.listUnsafe(projectKey);
        }
        try (Transaction t = this.transactionService.beginRead();){
            List<ManagedFolder> list = this.managedFolderDAO.listUnsafe(projectKey);
            return list;
        }
    }

    private List<WebApp> listWebApps_autoTxn(String projectKey) throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.webAppsDAO.listUnsafe(projectKey);
        }
        try (Transaction t = this.transactionService.beginRead();){
            List<WebApp> list = this.webAppsDAO.listUnsafe(projectKey);
            return list;
        }
    }

    private List<MLTask> list_MLTask_autTxn(String projectKey, String analysisId) throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.analysisCRUDService.listRawMLTasks(projectKey, analysisId);
        }
        try (Transaction t = this.transactionService.beginRead();){
            List<MLTask> list = this.analysisCRUDService.listRawMLTasks(projectKey, analysisId);
            return list;
        }
    }

    private SavedModel getSavedModelFromLoc_autTxn(AnyLoc loc) throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.smCRUDService.getMandatory(loc.getProjectKey(), loc.getId());
        }
        try (Transaction t = this.transactionService.beginRead();){
            SavedModel savedModel = this.smCRUDService.getMandatory(loc.getProjectKey(), loc.getId());
            return savedModel;
        }
    }

    private Object getMeta(Object object) {
        try {
            if (object instanceof IPluginifiedHolderMeta.Pluginifiable) {
                Object pMeta = this.getPluginifiableMeta((IPluginifiedHolderMeta.Pluginifiable)object);
                return pMeta instanceof UnavailablePluginItemInfo ? null : pMeta;
            }
            if (object instanceof SerializedRecipe) {
                return RecipeRegistry.getMeta((SerializedRecipe)object);
            }
            if (object instanceof SerializedDataset) {
                return DatasetHandlerFactory.getMeta(((SerializedDataset)object).getSubtype());
            }
            if (object instanceof Scenario) {
                return ScenarioRegistry.getMeta(((Scenario)object).getType());
            }
            if (object instanceof WebApp) {
                return WebAppRegistry.getMeta(((WebApp)object).getSubtype());
            }
            if (object instanceof LoadedCustomWebApp) {
                return WebAppRegistry.getMeta(((LoadedCustomWebApp)object).webappType);
            }
            if (object instanceof Cluster) {
                return ClusterRegistry.getMeta((Cluster)object);
            }
            if (object instanceof ProjectStandardsCheck) {
                return ProjectStandardsConfigurableCheckRegistry.getMeta((ProjectStandardsCheck)object);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Cannot find meta for " + object.getClass().getCanonicalName()), (Throwable)e);
        }
        return null;
    }

    private String getCategoryName(Object object) {
        try {
            if (object instanceof IPluginifiedHolderMeta.Pluginifiable) {
                return ((IPluginifiedHolderMeta.Pluginifiable)object).objectType;
            }
            if (object instanceof TaggableObjectsService.TaggableObject) {
                return ((TaggableObjectsService.TaggableObject)object).getTaggableType().toHumanReadableString();
            }
            if (object instanceof LoadedCustomWebApp) {
                return "webapp";
            }
            if (object instanceof Cluster) {
                return "cluster";
            }
            if (object instanceof ProjectStandardsCheck) {
                return "PROJECT_STANDARDS_CHECK";
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Cannot find category for " + object.getClass().getCanonicalName()));
        }
        return null;
    }

    private String getObjectId(Object object) {
        try {
            if (object instanceof IPluginifiedHolderMeta.Pluginifiable) {
                return ((IPluginifiedHolderMeta.Pluginifiable)object).elementType;
            }
            if (object instanceof TaggableObjectsService.TaggableObject) {
                return ((TaggableObjectsService.TaggableObject)object).getId();
            }
            if (object instanceof LoadedCustomWebApp) {
                return ((LoadedCustomWebApp)object).getId();
            }
            if (object instanceof Cluster) {
                return ((Cluster)object).id;
            }
            if (object instanceof ProjectStandardsCheck) {
                return ((ProjectStandardsCheck)object).id;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Cannot find id for " + object.getClass().getCanonicalName()));
        }
        return null;
    }

    public Object getPluginifiableMeta(IPluginifiedHolderMeta.Pluginifiable object) {
        try {
            Object ret;
            switch (object.objectType) {
                case "RECIPE": {
                    ret = RecipeRegistry.getMeta(object.elementType);
                    break;
                }
                case "DATASET": {
                    ret = DatasetHandlerFactory.getMeta(object.elementType);
                    break;
                }
                case "SCENARIO": {
                    ret = ScenarioRegistry.getMeta(object.elementType);
                    break;
                }
                case "fsProvider": {
                    ret = CustomFSProviderBuildersRegistry.get(object.elementType);
                    break;
                }
                case "format": {
                    ret = FormatFactory.getMeta(object.elementType);
                    break;
                }
                case "probe": {
                    ret = ProbeType.getProbeType(object.elementType);
                    break;
                }
                case "check": {
                    ret = CheckType.getCheckType(object.elementType);
                    break;
                }
                case "trigger": {
                    ret = TriggerRegistry.getMeta(object.elementType);
                    break;
                }
                case "step": {
                    ret = StepRegistry.getMeta(object.elementType);
                    break;
                }
                case "processor": {
                    ret = BaseProcessorsFactory.getMeta(object.elementType);
                    break;
                }
                case "macro": {
                    ret = DSSRunnableRegistry.getMeta(object.elementType);
                    break;
                }
                case "algo": {
                    ret = this.customPythonPredictionAlgoService.get(object.elementType);
                    break;
                }
                case "exporter": {
                    ret = CustomExportersRegistry.getMeta(object.elementType);
                    break;
                }
                case "cluster": {
                    ret = ClusterRegistry.getMeta(object.elementType);
                    break;
                }
                case "agent": {
                    ret = AgentTypesRegistry.getMeta(object.elementType);
                    break;
                }
                case "agentTool": {
                    ret = AgentToolsRegistry.getMeta(object.elementType);
                    break;
                }
                case "guardrail": {
                    ret = GuardrailsRegistry.getMeta(object.elementType);
                    break;
                }
                default: {
                    logger.warnV("Unrecognized pluginifiable meta %s (%s)", new Object[]{object.objectType, object.elementType});
                    return null;
                }
            }
            if (ret != null) {
                return ret;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Cannot find meta for " + object.getClass().getCanonicalName()), (Throwable)e);
        }
        return UnavailablePluginItemInfo.fromObjectTypeAndType(object.objectType, object.elementType);
    }

    private void getAnalysisUsages(AnalysisCoreParams object, String pluginId, Object rootObject, String projectKey, PluginUsages pluginUsages) throws IOException {
        for (ProcessorScriptStep processor : AbstractSqlQueryWithSchemaBuilder.getFlattenedEnabledProcessorsList(object.script)) {
            this.getUsages(new IPluginifiedHolderMeta.Pluginifiable("processor", processor.type, processor), pluginId, rootObject, projectKey, pluginUsages);
        }
        for (MLTask mlTask : this.list_MLTask_autTxn(object.projectKey, object.id)) {
            if (mlTask.taskType != MLTask.MLTaskType.PREDICTION) continue;
            MLTaskLoc loc = new MLTaskLoc(object.projectKey, object.id, mlTask.id);
            for (FullModelId fmi : this.mLBaseService.listCompletedModelIds(loc)) {
                this.getFullModelIdUsages(fmi, pluginId, rootObject, projectKey, pluginUsages);
            }
        }
    }

    private void getSavedModelsUsages(SavedModel sm, String pluginId, Object rootObject, String projectKey, PluginUsages pluginUsages) throws IOException {
        String agentType;
        SavedModel.SavedModelInlineVersion smiv;
        if (sm.getType() == MLTask.MLTaskType.PREDICTION) {
            FullModelId activeFmi;
            try {
                activeFmi = this.predictionSMMgmtService.getActiveVersionFMI(sm);
            }
            catch (IllegalArgumentException e) {
                logger.info((Object)String.format("Failed to retrieve active version for model %s : %s", sm.getId(), ExceptionUtils.getMessageWithCauses((Throwable)e)));
                return;
            }
            this.getFullModelIdUsages(activeFmi, pluginId, rootObject, projectKey, pluginUsages);
        } else if (sm.savedModelType == SavedModel.SavedModelType.PLUGIN_AGENT && (smiv = SavedModelsAgentsBaseService.getActiveOrLatestInlineVersion(sm)) != null && (agentType = smiv.pluginAgentType) != null && agentType.startsWith("agent_" + pluginId + "_")) {
            this.getUsages(new IPluginifiedHolderMeta.Pluginifiable("agent", agentType, sm), pluginId, rootObject, projectKey, pluginUsages);
        }
        if (sm.savedModelType.isAgent() && (smiv = SavedModelsAgentsBaseService.getActiveOrLatestInlineVersion(sm)) != null) {
            List<GuardrailsPipelineSettings.GuardrailsPipelineElement> guardrails = smiv.guardrailsPipelineSettings.guardrails;
            this.getGuardrailsUsages(guardrails, pluginId, rootObject, projectKey, pluginUsages);
        }
    }

    private void getAgentToolUsages(AgentTool agentTool, String pluginId, Object rootObject, String projectKey, PluginUsages pluginUsages) throws IOException {
        if (agentTool.type.startsWith("Custom_agent_tool_" + pluginId + "_")) {
            this.getUsages(new IPluginifiedHolderMeta.Pluginifiable("agentTool", agentTool.type, agentTool), pluginId, rootObject, projectKey, pluginUsages);
        }
    }

    private void getPromptStudioUsages(PromptStudio promptStudio, String pluginId, PromptStudio rootObject, String projectKey, PluginUsages pluginUsages) throws IOException {
        for (PromptStudio.PromptStudioPrompt prompt : promptStudio.prompts) {
            List<GuardrailsPipelineSettings.GuardrailsPipelineElement> guardrails = prompt.prompt.guardrailsPipelineSettings.guardrails;
            this.getGuardrailsUsages(guardrails, pluginId, rootObject, projectKey, pluginUsages);
        }
    }

    private void getConnectionUsages(DSSConnection connection, String pluginId, Object rootObject, String projectKey, PluginUsages pluginUsages) throws IOException {
        if (connection instanceof AbstractLLMConnection) {
            List<GuardrailsPipelineSettings.GuardrailsPipelineElement> guardrails = ((AbstractLLMConnection)connection).getLLMConnectionParams().guardrailsPipelineSettings.guardrails;
            this.getGuardrailsUsages(guardrails, pluginId, rootObject, projectKey, pluginUsages);
        }
    }

    private void getGuardrailsUsages(List<GuardrailsPipelineSettings.GuardrailsPipelineElement> guardrails, String pluginId, Object rootObject, String projectKey, PluginUsages pluginUsages) throws IOException {
        for (GuardrailsPipelineSettings.GuardrailsPipelineElement guardrail : guardrails) {
            if (!guardrail.type.startsWith("Custom_guardrail_" + pluginId + "_")) continue;
            this.getUsages(new IPluginifiedHolderMeta.Pluginifiable("guardrail", guardrail.type, guardrail), pluginId, rootObject, projectKey, pluginUsages);
        }
    }

    private void getRecipeUsages(SerializedRecipe recipe, String pluginId, Object rootObject, String projectKey, PluginUsages pluginUsages) throws IOException {
        this.getUsages(recipe, pluginId, rootObject, projectKey, pluginUsages);
        if (Objects.equals(recipe.type, "prompt")) {
            String payload;
            if (TransactionContext.hasAttachedTransaction()) {
                payload = this.recipesDAO.getPayloadOrNull(recipe.projectKey, recipe.name);
            } else {
                try (Transaction t = this.transactionService.beginRead();){
                    payload = this.recipesDAO.getPayloadOrNull(recipe.projectKey, recipe.name);
                }
            }
            if (StringUtils.isNotBlank((String)payload)) {
                PromptRecipePayloadParams params = (PromptRecipePayloadParams)JSON.parse((String)payload, PromptRecipePayloadParams.class);
                List<GuardrailsPipelineSettings.GuardrailsPipelineElement> guardrails = params.prompt.guardrailsPipelineSettings.guardrails;
                this.getGuardrailsUsages(guardrails, pluginId, recipe, projectKey, pluginUsages);
            }
        }
    }

    private void getLambdaServicesUsages(LambdaService ls, String pluginId, Object rootObject, String projectKey, PluginUsages pluginUsages) {
        for (DSSLambdaEndpointConfig endpoint : ls.endpoints) {
            String modelRef;
            if (endpoint.type != LambdaEndpointConfig.EndpointType.STD_PREDICTION && endpoint.type != LambdaEndpointConfig.EndpointType.STD_CLUSTERING || StringUtils.isBlank((String)(modelRef = ((DSSPredictionEndpointConfig)endpoint).modelRef))) continue;
            AnyLoc modelLoc = AnyLoc.resolveSmart(ls.projectKey, modelRef);
            try {
                SavedModel sm = this.getSavedModelFromLoc_autTxn(modelLoc);
                this.getSavedModelsUsages(sm, pluginId, rootObject, projectKey, pluginUsages);
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "Unable to list saved model '%s' usage", new Object[]{modelLoc.getFullName()});
            }
        }
    }

    private void getFullModelIdUsages(FullModelId fmi, String pluginId, Object rootObject, String projectKey, PluginUsages pluginUsages) throws IOException {
        Map<String, MLPluginsService.PluginInfo> usedPlugins = null;
        try {
            usedPlugins = this.mlPluginsService.getUsedPlugins(fmi);
        }
        catch (IllegalArgumentException e) {
            logger.info((Object)("Unable to list fmi '" + String.valueOf(fmi) + "' usages"), (Throwable)e);
        }
        if (usedPlugins != null && usedPlugins.containsKey(pluginId)) {
            this.getUsagesFromMLPlugins(usedPlugins.get(pluginId), pluginId, rootObject, projectKey, pluginUsages);
        }
    }

    private void getUsagesFromMLPlugins(MLPluginsService.PluginInfo pluginInfo, String pluginId, Object rootObject, String projectKey, PluginUsages pluginUsages) throws IOException {
        for (String algoId : pluginInfo.customAlgos) {
            LoadedCustomPythonPredictionAlgoDesc desc = this.customPythonPredictionAlgoService.get(pluginId, algoId);
            this.getUsages(new IPluginifiedHolderMeta.Pluginifiable("algo", desc.getType(), desc), pluginId, rootObject, projectKey, pluginUsages);
        }
    }

    private DatasetExploreSettings getDatasetExploreSettings(String projectKey, String datasetSmartName) throws IOException {
        return this.exploresService.getUnsafe(projectKey, datasetSmartName);
    }

    private void getWebappExploreUsage(String projectKey, LoadedCustomWebApp webApp, SerializedDataset dataset, PluginUsages pluginUsages) throws IOException {
        AnyLoc loc = new AnyLoc(dataset.projectKey, dataset.name);
        DatasetExploreSettings dsExploreSettings = this.getDatasetExploreSettings(projectKey, loc.getSmartName(projectKey));
        for (DatasetExploreSettings.DatasetChart dsChart : dsExploreSettings.charts) {
            if (dsChart.def == null || ChartType.webapp != dsChart.def.type || !StringUtils.equals((String)dsChart.def.webAppType, (String)webApp.webappType)) continue;
            this.getUsages(webApp, webApp.getOwnerPluginId(), dataset, projectKey, pluginUsages);
        }
    }

    private void getVirtualWebappUsage(String projectKey, String pluginId, PluginUsages pluginUsages) throws IOException {
        List<SavedModel> savedModels = this.listSavedModels_autoTxn(projectKey);
        List<ManagedFolder> managedFolders = this.listManagedFolders_autoTxn(projectKey);
        Collection webApps = this.customWebAppsService.list();
        if (!webApps.isEmpty()) {
            for (LoadedCustomWebApp curWebApp : webApps) {
                if (!CollectionUtils.isNotEmpty(curWebApp.desc.roles)) continue;
                for (CustomWebAppDesc.WebAppRole r : curWebApp.desc.roles) {
                    if (ITaggingService.TaggableType.SAVED_MODEL == r.type) {
                        for (SavedModel sm : savedModels) {
                            if (!StringUtils.isEmpty((String)r.contentType) && !StringUtils.startsWith((String)sm.contentType, (String)r.contentType)) continue;
                            this.getUsages(curWebApp, pluginId, sm, projectKey, pluginUsages);
                        }
                        continue;
                    }
                    if (ITaggingService.TaggableType.MANAGED_FOLDER != r.type) continue;
                    for (ManagedFolder mf : managedFolders) {
                        if (!StringUtils.isEmpty((String)r.contentType) && !StringUtils.startsWith((String)mf.contentType, (String)r.contentType)) continue;
                        this.getUsages(curWebApp, pluginId, mf, projectKey, pluginUsages);
                    }
                }
            }
        }
    }

    private void getUsages(Object object, String pluginId, Object rootObject, String projectKey, PluginUsages toFill) throws IOException {
        IPluginifiedMeta pluginifiedMeta;
        IElementLoadedDesc desc;
        Object meta = this.getMeta(object);
        if (meta instanceof IPluginifiedMeta && (desc = (pluginifiedMeta = (IPluginifiedMeta)meta).getLoadedDesc()) != null && StringUtils.equals((String)pluginId, (String)desc.getOwnerPluginId())) {
            toFill.usages.add(this.makeUsage(desc.getType(), desc.getFolderName(), rootObject, projectKey));
        }
        if (meta instanceof IPluginifiedHolderMeta) {
            String payload;
            IPluginifiedHolderMeta pluginifiedHolderMeta = (IPluginifiedHolderMeta)meta;
            if (object instanceof SerializedRecipe) {
                if (TransactionContext.hasAttachedTransaction()) {
                    payload = this.recipesDAO.getPayloadOrNull(((SerializedRecipe)object).getProjectKey(), ((SerializedRecipe)object).getId());
                } else {
                    try (Transaction t = this.transactionService.beginRead();){
                        payload = this.recipesDAO.getPayloadOrNull(((SerializedRecipe)object).getProjectKey(), ((SerializedRecipe)object).getId());
                    }
                }
            } else {
                payload = null;
            }
            try {
                for (IPluginifiedHolderMeta.Pluginifiable subObject : pluginifiedHolderMeta.getPluginifiables(object, payload)) {
                    this.getUsages(subObject, pluginId, rootObject, projectKey, toFill);
                }
            }
            catch (UnavailableTypeException ute) {
                MissingType missingType = new MissingType(ute.missingType, this.getCategoryName(object), projectKey, this.getObjectId(object), ute.missingPluginId);
                logger.warnV("Found missing type %s for %s %s in project %s", new Object[]{missingType.missingType, missingType.objectType, missingType.objectId, projectKey});
                toFill.missingTypes.add(missingType);
            }
        }
    }

    private PluginUsage makeUsage(String elementType, String elementKind, Object rootObject, String contextProjectKey) {
        PluginUsage usage = new PluginUsage();
        usage.elementType = elementType;
        usage.elementKind = elementKind.indexOf(47) > 0 ? elementKind.substring(0, elementKind.indexOf(47)) : elementKind;
        if (rootObject instanceof TaggableObjectsService.TaggableObject) {
            TaggableObjectsService.TaggableObject taggableObject = (TaggableObjectsService.TaggableObject)rootObject;
            AnyLoc loc = new AnyLoc(taggableObject.getProjectKey(), taggableObject.getId());
            usage.projectKey = contextProjectKey;
            usage.objectId = loc.getSmartName(contextProjectKey);
            usage.objectType = taggableObject.getTaggableType().name();
        }
        if (rootObject instanceof Cluster) {
            Cluster cluster = (Cluster)rootObject;
            usage.projectKey = null;
            usage.objectId = cluster.id;
            usage.objectType = "CLUSTER";
        }
        if (rootObject instanceof DSSConnection) {
            DSSConnection connection = (DSSConnection)rootObject;
            usage.projectKey = null;
            usage.objectId = connection.name;
            usage.objectType = "CONNECTION";
        }
        if (rootObject instanceof ProjectStandardsCheck) {
            ProjectStandardsCheck check = (ProjectStandardsCheck)rootObject;
            usage.projectKey = null;
            usage.objectId = this.getObjectId(check);
            usage.objectType = this.getCategoryName(check);
        }
        return usage;
    }

    public static void addExporterComponentToList(List<IPluginifiedHolderMeta.Pluginifiable> components, ExportParams exportParams) {
        if (exportParams.destinationType == ExportParams.ExportDestinationType.CUSTOM_MANAGED) {
            components.add(new IPluginifiedHolderMeta.Pluginifiable("exporter", exportParams.exporterType, exportParams.config));
        } else if (exportParams.destinationType != ExportParams.ExportDestinationType.DATASET) {
            if (StringUtils.isNotBlank((String)exportParams.exporterType)) {
                components.add(new IPluginifiedHolderMeta.Pluginifiable("exporter", exportParams.exporterType, exportParams.config));
            } else {
                components.add(new IPluginifiedHolderMeta.Pluginifiable("format", exportParams.format.type, exportParams.format.params));
            }
        }
    }

    public static StepMeta.UnavailableStepInfo checkChecks(List<? extends DataQualityRule> rules, Step step) {
        for (DataQualityRule dataQualityRule : rules) {
            if (!(dataQualityRule instanceof CustomPythonCheck)) continue;
            CustomPythonCheck customPythonCheck = (CustomPythonCheck)dataQualityRule;
            if (null != customPythonCheck.checkType) continue;
            return new StepMeta.UnavailableStepInfo(step, UnavailablePluginItemInfo.fromObjectTypeAndType("custom_python", customPythonCheck.type));
        }
        return null;
    }

    public StepMeta.UnavailableStepInfo checkFlowComputableSpecs(Scenario scenario, Step step, List<FlowComputableSpecification> flowComputableSpecs) throws Exception {
        for (FlowComputableSpecification clear : flowComputableSpecs) {
            Object object = clear.getObjectOrNull(scenario.getProjectKey(), this.datasetsDAO, this.managedFolderDAO, this.savedModelsDAO, this.modelEvaluationStoresDAO, this.retrievableKnowledgeDAO);
            UnavailablePluginItemInfo unavailablePluginItemInfo = null;
            if (object instanceof Dataset) {
                unavailablePluginItemInfo = this.checkDataset(((Dataset)object).getModel());
            } else if (object instanceof ManagedFolder) {
                unavailablePluginItemInfo = this.checkManagedFolder((ManagedFolder)object);
            }
            if (unavailablePluginItemInfo == null) continue;
            return new StepMeta.UnavailableStepInfo(step, unavailablePluginItemInfo);
        }
        return null;
    }

    public UnavailablePluginItemInfo checkManagedFolder(ManagedFolder object) {
        if (object.type.startsWith("fsprovider")) {
            try {
                CustomFSProviderBuildersRegistry.get(object.type);
            }
            catch (UnavailableDSSObjectException e) {
                logger.error((Object)("Unavailable " + object.type), (Throwable)((Object)e));
                return e.unavailableStepInfo;
            }
        }
        return null;
    }

    public UnavailablePluginItemInfo checkDataset(SerializedDataset serializedDataset) {
        DatasetHandler.DatasetMeta<?, ?> meta = DatasetHandlerFactory.getMeta(serializedDataset.getSubtype());
        List<IPluginifiedHolderMeta.Pluginifiable> pluginifiables = meta.getPluginifiables(serializedDataset, null);
        for (IPluginifiedHolderMeta.Pluginifiable pluginifiable : pluginifiables) {
            Object pMeta = this.getPluginifiableMeta(pluginifiable);
            if (!(pMeta instanceof UnavailablePluginItemInfo)) continue;
            return (UnavailablePluginItemInfo)pMeta;
        }
        return null;
    }

    public Object getFlowComputableSpecObject(Scenario sc, FlowComputableSpecification fcs) throws Exception {
        return fcs.getObjectOrNull(sc.getProjectKey(), this.datasetsDAO, this.managedFolderDAO, this.savedModelsDAO, this.modelEvaluationStoresDAO, this.retrievableKnowledgeDAO);
    }

    public static class PluginUsages {
        public Set<PluginUsage> usages = Sets.newHashSet();
        public Set<MissingType> missingTypes = Sets.newHashSet();

        public PluginUsagesStatistics getStatistics() {
            PluginUsagesStatistics ret = new PluginUsagesStatistics();
            ret.objectAnalysisErrors = this.missingTypes.size();
            if (this.usages.isEmpty()) {
                return ret;
            }
            HashSet<String> projectIds = new HashSet<String>();
            HashSet<String> usedElemTypes = new HashSet<String>();
            for (PluginUsage usage : this.usages) {
                projectIds.add(usage.projectKey);
                usedElemTypes.add(usage.elementType);
            }
            ret.projectCount = projectIds.size();
            ret.usedElemCount = usedElemTypes.size();
            return ret;
        }

        public static class PluginUsagesStatistics {
            public int projectCount = 0;
            public int usedElemCount = 0;
            public int objectAnalysisErrors = 0;
        }
    }

    public static class MissingType {
        public final String missingType;
        public final String objectType;
        public final String projectKey;
        public final String objectId;
        public final String pluginId;

        public MissingType(String missingType, String objectType, String projectKey, String objectId, String pluginId) {
            this.missingType = missingType;
            this.objectType = objectType;
            this.projectKey = projectKey;
            this.objectId = objectId;
            this.pluginId = pluginId;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof MissingType) {
                MissingType castedOther = (MissingType)other;
                return Objects.equals(this.missingType, castedOther.missingType) && Objects.equals(this.objectType, castedOther.objectType) && Objects.equals(this.objectId, castedOther.objectId) && Objects.equals(this.projectKey, castedOther.projectKey);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.missingType, this.objectType, this.objectId, this.projectKey);
        }
    }

    public static class PluginUsage {
        public String elementKind;
        public String elementType;
        public String objectType;
        public String projectKey;
        public String objectId;

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof PluginUsage) {
                PluginUsage castedOther = (PluginUsage)other;
                return Objects.equals(this.elementKind, castedOther.elementKind) && Objects.equals(this.elementType, castedOther.elementType) && Objects.equals(this.objectType, castedOther.objectType) && Objects.equals(this.objectId, castedOther.objectId) && Objects.equals(this.projectKey, castedOther.projectKey);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.elementKind, this.elementType, this.objectType, this.objectId, this.projectKey);
        }
    }
}

