/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.ConnectionMetadataDAO;
import com.dataiku.dip.util.CachedJSONFile;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class ConnectionMetadataDAOImpl
implements ConnectionMetadataDAO {
    private CachedJSONFile<MetadataFile> cf = new CachedJSONFile(ApplicationConfigurator.getFile((String[])new String[]{"data-catalog", "connections_metadata.json"}), MetadataFile.class);

    @Override
    public synchronized void save(ConnectionMetadataDAO.ConnectionMetadata connectionMetadata) throws IOException {
        assert (connectionMetadata.dssConnectionName != null);
        MetadataFile current = (MetadataFile)this.cf.get();
        if (current == null) {
            current = new MetadataFile();
        }
        current.connections.put(connectionMetadata.dssConnectionName, connectionMetadata);
        this.cf.write((Object)current);
    }

    @Override
    public void save(Collection<ConnectionMetadataDAO.ConnectionMetadata> cm) throws IOException {
        if (cm == null || cm.isEmpty()) {
            return;
        }
        MetadataFile current = (MetadataFile)this.cf.get();
        if (current == null) {
            current = new MetadataFile();
        }
        for (ConnectionMetadataDAO.ConnectionMetadata connectionMetadata : cm) {
            assert (connectionMetadata.dssConnectionName != null);
            current.connections.put(connectionMetadata.dssConnectionName, connectionMetadata);
        }
        this.cf.write((Object)current);
    }

    @Override
    public synchronized Map<String, ConnectionMetadataDAO.ConnectionMetadata> getAll() throws IOException {
        MetadataFile mf = (MetadataFile)this.cf.getUnsafe();
        if (mf == null) {
            return new HashMap<String, ConnectionMetadataDAO.ConnectionMetadata>();
        }
        return mf.connections;
    }

    static class MetadataFile {
        Map<String, ConnectionMetadataDAO.ConnectionMetadata> connections = new HashMap<String, ConnectionMetadataDAO.ConnectionMetadata>();

        MetadataFile() {
        }
    }
}

