/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.dao.ProjectStandardsConfigurationDAO;
import com.dataiku.dip.projectstandards.ProjectStandardsConfiguration;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedProjectStandardsConfigurationDAO
implements ProjectStandardsConfigurationDAO {
    private static final RelFile CONFIGURATION_FILE = RelFile.global((String)"project-standards.json");

    @Override
    public void save(ProjectStandardsConfiguration projectStandardsConfiguration) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.writeObject(CONFIGURATION_FILE, (Object)projectStandardsConfiguration);
    }

    @Override
    public ProjectStandardsConfiguration getUnsafe() throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        if (t.isFile(CONFIGURATION_FILE)) {
            return (ProjectStandardsConfiguration)t.readObjectUnsafe(CONFIGURATION_FILE, ProjectStandardsConfiguration.class);
        }
        return new ProjectStandardsConfiguration();
    }

    @Override
    @Nonnull
    public ProjectStandardsConfiguration read() throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        return (ProjectStandardsConfiguration)t.readObjectDefault(CONFIGURATION_FILE, ProjectStandardsConfiguration.class);
    }
}

