/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.MiscCodes;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dao.HashesModel;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.sql.queries.DeleteQueryBuilder;
import com.dataiku.dip.sql.queries.InsertQueryBuilder;
import com.dataiku.dip.sql.queries.SimpleSelectQueryBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.collect.ImmutableList;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Service;

@Service
public class FlowStateInternalDB
extends AbstractDSSDBService {
    private static final String DB_NAME = "flow_state";
    private static final int SCHEMA_VERSION = 1;
    private static final String SRC_DATASET_HASH_TABLE = "SRC_DATASET_HASH";
    private static final String DATASET_SETTINGS_HASH_TABLE = "DATASET_SETTINGS_HASH";
    private static final String RECIPE_CODE_HASH_TABLE = "RECIPE_CODE_HASH";
    private static final String GENERATOR_HASH_TABLE = "GENERATOR_HASH";
    private static final String TARGET_DS_COLUMN = "TARGET_DS";
    private static final SchemaColumn TARGET_DS_SCHEMA_COLUMN = new SchemaColumn("TARGET_DS", Type.STRING);
    private static final String TARGET_PARTITION_COLUMN = "TARGET_PARTITION";
    private static final SchemaColumn TARGET_PARTITION_SCHEMA_COLUMN = new SchemaColumn("TARGET_PARTITION", Type.STRING);
    private static final String SOURCE_DS_COLUMN = "SOURCE_DS";
    private static final SchemaColumn SOURCE_DS_SCHEMA_COLUMN = new SchemaColumn("SOURCE_DS", Type.STRING);
    private static final String SOURCE_PARTITION_COLUMN = "SOURCE_PARTITION";
    private static final SchemaColumn SOURCE_PARTITION_SCHEMA_COLUMN = new SchemaColumn("SOURCE_PARTITION", Type.STRING);
    private static final String VALUE_COLUMN = "VALUE";
    private static final SchemaColumn VALUE_SCHEMA_COLUMN = new SchemaColumn("VALUE", Type.STRING);
    private static final String PROPAGATEDON_COLUMN = "PROPAGATEDON";
    private static final SchemaColumn PROPAGATEDON_SCHEMA_COLUMN = new SchemaColumn("PROPAGATEDON", Type.BIGINT);
    private static final String REASON_COLUMN = "REASON";
    private static final SchemaColumn REASON_SCHEMA_COLUMN = new SchemaColumn("REASON", Type.STRING);
    private static final String RECIPE_ID_COLUMN = "RECIPE_ID";
    private static final SchemaColumn RECIPE_ID_SCHEMA_COLUMN = new SchemaColumn("RECIPE_ID", Type.STRING);
    private static final String GENERATOR_ID_COLUMN = "GENERATOR_ID";
    private static final SchemaColumn GENERATOR_ID_SCHEMA_COLUMN = new SchemaColumn("GENERATOR_ID", Type.STRING);
    private static final SchemaColumn[] SRC_DATASET_HASH_COLUMNS = new SchemaColumn[]{TARGET_DS_SCHEMA_COLUMN, TARGET_PARTITION_SCHEMA_COLUMN, SOURCE_DS_SCHEMA_COLUMN, SOURCE_PARTITION_SCHEMA_COLUMN, VALUE_SCHEMA_COLUMN, PROPAGATEDON_SCHEMA_COLUMN, REASON_SCHEMA_COLUMN};
    private static final SchemaColumn[] DATASET_SETTINGS_HASH_COLUMNS = new SchemaColumn[]{TARGET_DS_SCHEMA_COLUMN, TARGET_PARTITION_SCHEMA_COLUMN, VALUE_SCHEMA_COLUMN, PROPAGATEDON_SCHEMA_COLUMN, REASON_SCHEMA_COLUMN};
    private static final SchemaColumn[] RECIPE_CODE_HASH_COLUMNS = new SchemaColumn[]{TARGET_DS_SCHEMA_COLUMN, TARGET_PARTITION_SCHEMA_COLUMN, RECIPE_ID_SCHEMA_COLUMN, VALUE_SCHEMA_COLUMN, PROPAGATEDON_SCHEMA_COLUMN, REASON_SCHEMA_COLUMN};
    private static final SchemaColumn[] GENERATOR_HASH_COLUMNS = new SchemaColumn[]{TARGET_DS_SCHEMA_COLUMN, TARGET_PARTITION_SCHEMA_COLUMN, GENERATOR_ID_SCHEMA_COLUMN, VALUE_SCHEMA_COLUMN, PROPAGATEDON_SCHEMA_COLUMN, REASON_SCHEMA_COLUMN};
    public static final List<String> TABLES = ImmutableList.of((Object)"SRC_DATASET_HASH", (Object)"DATASET_SETTINGS_HASH", (Object)"RECIPE_CODE_HASH", (Object)"GENERATOR_HASH");
    private final String getSrcDatasetHash = SimpleSelectQueryBuilder.selectAll().from(this.resolveTable("SRC_DATASET_HASH"), "SRC_DATASET_HASH").wheres("TARGET_DS", "TARGET_PARTITION", "SOURCE_DS", "SOURCE_PARTITION").toSQL(this.getDialect());
    private final String getDatasetSettings = SimpleSelectQueryBuilder.selectAll().from(this.resolveTable("DATASET_SETTINGS_HASH"), "DATASET_SETTINGS_HASH").wheres("TARGET_DS", "TARGET_PARTITION").toSQL(this.getDialect());
    private final String getRecipeCode = SimpleSelectQueryBuilder.selectAll().from(this.resolveTable("RECIPE_CODE_HASH"), "RECIPE_CODE_HASH").wheres("TARGET_DS", "TARGET_PARTITION", "RECIPE_ID").toSQL(this.getDialect());
    private final String getGeneratorTimestamp = SimpleSelectQueryBuilder.selectAll().from(this.resolveTable("GENERATOR_HASH"), "GENERATOR_HASH").wheres("TARGET_DS", "TARGET_PARTITION", "GENERATOR_ID").toSQL(this.getDialect());
    private static DKULogger logger = DKULogger.getLogger((String)"dku.timestamps.sql");

    public FlowStateInternalDB() {
        super(ApplicationConfigurator.getDatabaseFile(DB_NAME), DB_NAME, DB_NAME, 1, true);
    }

    @PostConstruct
    public void init() throws SQLException {
        this.create();
    }

    @Override
    protected void initDB(int currentSchemaVersion, DSSDBConnection conn) throws CodedSQLException {
        block9: {
            try {
                if (currentSchemaVersion != 0) break block9;
                try (Statement st2 = conn.createStatement();){
                    this.createTable(SRC_DATASET_HASH_TABLE, SRC_DATASET_HASH_COLUMNS, null, st2);
                    this.createTable(DATASET_SETTINGS_HASH_TABLE, DATASET_SETTINGS_HASH_COLUMNS, null, st2);
                    this.createTable(RECIPE_CODE_HASH_TABLE, RECIPE_CODE_HASH_COLUMNS, null, st2);
                    this.createTable(GENERATOR_HASH_TABLE, GENERATOR_HASH_COLUMNS, null, st2);
                    this.createAnonymousIndex(SRC_DATASET_HASH_TABLE, new String[]{TARGET_DS_COLUMN, TARGET_PARTITION_COLUMN, SOURCE_DS_COLUMN, SOURCE_PARTITION_COLUMN}, st2);
                    this.createAnonymousIndex(DATASET_SETTINGS_HASH_TABLE, new String[]{TARGET_DS_COLUMN, TARGET_PARTITION_COLUMN}, st2);
                    this.createAnonymousIndex(RECIPE_CODE_HASH_TABLE, new String[]{TARGET_DS_COLUMN, TARGET_PARTITION_COLUMN, RECIPE_ID_COLUMN}, st2);
                    this.createAnonymousIndex(GENERATOR_HASH_TABLE, new String[]{TARGET_DS_COLUMN, TARGET_PARTITION_COLUMN, GENERATOR_ID_COLUMN}, st2);
                }
            }
            catch (CodedSQLException e) {
                throw e;
            }
            catch (SQLException e) {
                throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
    }

    public HashesModel.SrcDatasetHashInfo getPropagatedDatasetHash(DSSDBConnection conn, String targetDS, String targetPartition, String sourceDS, String sourcePartition) throws SQLException {
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getSrcDatasetHash);
        ps2.setString(1, targetDS);
        ps2.setString(2, targetPartition);
        ps2.setString(3, sourceDS);
        ps2.setString(4, sourcePartition);
        ps2.execute();
        try (ResultSet rs2 = ps2.getResultSet();){
            if (rs2.next()) {
                HashesModel.SrcDatasetHashInfo srcDatasetHashInfo = new HashesModel.SrcDatasetHashInfo(targetDS, targetPartition, sourceDS, sourcePartition, rs2.getString(VALUE_COLUMN), rs2.getLong(PROPAGATEDON_COLUMN), rs2.getString(VALUE_COLUMN));
                return srcDatasetHashInfo;
            }
            HashesModel.SrcDatasetHashInfo srcDatasetHashInfo = null;
            return srcDatasetHashInfo;
        }
    }

    public HashesModel.DatasetSettingsHashInfo getPropagatedTargetSettingsHash(DSSDBConnection conn, String targetDS, String targetPartition) throws SQLException {
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getDatasetSettings);
        ps2.setString(1, targetDS);
        ps2.setString(2, targetPartition);
        ps2.execute();
        try (ResultSet rs2 = ps2.getResultSet();){
            if (rs2.next()) {
                HashesModel.DatasetSettingsHashInfo datasetSettingsHashInfo = new HashesModel.DatasetSettingsHashInfo(targetDS, targetPartition, rs2.getString(VALUE_COLUMN), rs2.getLong(PROPAGATEDON_COLUMN), rs2.getString(VALUE_COLUMN));
                return datasetSettingsHashInfo;
            }
            HashesModel.DatasetSettingsHashInfo datasetSettingsHashInfo = null;
            return datasetSettingsHashInfo;
        }
    }

    public HashesModel.RecipeCodeHashInfo getPropagatedRecipeCodeHash(DSSDBConnection conn, String targetDS, String targetPartition, String recipeFullName) throws SQLException {
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getRecipeCode);
        ps2.setString(1, targetDS);
        ps2.setString(2, targetPartition);
        ps2.setString(3, recipeFullName);
        ps2.execute();
        try (ResultSet rs2 = ps2.getResultSet();){
            if (rs2.next()) {
                HashesModel.RecipeCodeHashInfo recipeCodeHashInfo = new HashesModel.RecipeCodeHashInfo(targetDS, targetPartition, recipeFullName, rs2.getString(VALUE_COLUMN), rs2.getLong(PROPAGATEDON_COLUMN), rs2.getString(VALUE_COLUMN));
                return recipeCodeHashInfo;
            }
            HashesModel.RecipeCodeHashInfo recipeCodeHashInfo = null;
            return recipeCodeHashInfo;
        }
    }

    public HashesModel.GeneratorHashInfo getPropagatedGeneratorTaskHash(DSSDBConnection conn, String targetDS, String targetPartition, String taskId) throws SQLException {
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getGeneratorTimestamp);
        ps2.setString(1, targetDS);
        ps2.setString(2, targetPartition);
        ps2.setString(3, taskId);
        ps2.execute();
        try (ResultSet rs2 = ps2.getResultSet();){
            if (rs2.next()) {
                HashesModel.GeneratorHashInfo generatorHashInfo = new HashesModel.GeneratorHashInfo(targetDS, targetPartition, taskId, rs2.getString(VALUE_COLUMN), rs2.getLong(PROPAGATEDON_COLUMN), rs2.getString(VALUE_COLUMN));
                return generatorHashInfo;
            }
            HashesModel.GeneratorHashInfo generatorHashInfo = null;
            return generatorHashInfo;
        }
    }

    public void propagateHashes(DSSDBConnection conn, List<HashesModel.PropagatedHashInfo> list) throws SQLException {
        long before = System.currentTimeMillis();
        logger.infoV("Starting to propagate %d hashes", new Object[]{list.size()});
        try (PreparedStatement deleteSrc = conn.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable(SRC_DATASET_HASH_TABLE)).withParameterizedEqualWheres(TARGET_DS_COLUMN, TARGET_PARTITION_COLUMN, SOURCE_DS_COLUMN, SOURCE_PARTITION_COLUMN).toSql(this.getDialect()));
             PreparedStatement insertSrcDataset = conn.prepareNonPersistedStatement(InsertQueryBuilder.insertInto(this.resolveTable(SRC_DATASET_HASH_TABLE)).addColumns(SRC_DATASET_HASH_COLUMNS).toSQL(this.getDialect()));
             PreparedStatement deleteSettings = conn.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable(DATASET_SETTINGS_HASH_TABLE)).withParameterizedEqualWheres(TARGET_DS_COLUMN, TARGET_PARTITION_COLUMN).toSql(this.getDialect()));
             PreparedStatement insertDatasetSettings = conn.prepareNonPersistedStatement(InsertQueryBuilder.insertInto(this.resolveTable(DATASET_SETTINGS_HASH_TABLE)).addColumns(DATASET_SETTINGS_HASH_COLUMNS).toSQL(this.getDialect()));
             PreparedStatement deleteRecipeCode = conn.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable(RECIPE_CODE_HASH_TABLE)).withParameterizedEqualWheres(TARGET_DS_COLUMN, TARGET_PARTITION_COLUMN, RECIPE_ID_COLUMN).toSql(this.getDialect()));
             PreparedStatement insertRecipeCode = conn.prepareNonPersistedStatement(InsertQueryBuilder.insertInto(this.resolveTable(RECIPE_CODE_HASH_TABLE)).addColumns(RECIPE_CODE_HASH_COLUMNS).toSQL(this.getDialect()));
             PreparedStatement deleteGenerator = conn.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable(GENERATOR_HASH_TABLE)).withParameterizedEqualWheres(TARGET_DS_COLUMN, TARGET_PARTITION_COLUMN, GENERATOR_ID_COLUMN).toSql(this.getDialect()));
             PreparedStatement insertGenerator = conn.prepareNonPersistedStatement(InsertQueryBuilder.insertInto(this.resolveTable(GENERATOR_HASH_TABLE)).addColumns(GENERATOR_HASH_COLUMNS).toSQL(this.getDialect()));){
            for (HashesModel.PropagatedHashInfo phi : list) {
                if (phi instanceof HashesModel.SrcDatasetHashInfo) {
                    HashesModel.SrcDatasetHashInfo src = (HashesModel.SrcDatasetHashInfo)phi;
                    deleteSrc.setString(1, src.targetDS);
                    deleteSrc.setString(2, src.targetPartition);
                    deleteSrc.setString(3, src.sourceDS);
                    deleteSrc.setString(4, src.sourcePartition);
                    deleteSrc.execute();
                    insertSrcDataset.setString(1, src.targetDS);
                    insertSrcDataset.setString(2, src.targetPartition);
                    insertSrcDataset.setString(3, src.sourceDS);
                    insertSrcDataset.setString(4, src.sourcePartition);
                    insertSrcDataset.setString(5, src.propagatedHash);
                    insertSrcDataset.setLong(6, System.currentTimeMillis());
                    insertSrcDataset.setString(7, src.reason);
                    insertSrcDataset.execute();
                    continue;
                }
                if (phi instanceof HashesModel.DatasetSettingsHashInfo) {
                    HashesModel.DatasetSettingsHashInfo ds = (HashesModel.DatasetSettingsHashInfo)phi;
                    deleteSettings.setString(1, ds.targetDS);
                    deleteSettings.setString(2, ds.targetPartition);
                    deleteSettings.execute();
                    insertDatasetSettings.setString(1, ds.targetDS);
                    insertDatasetSettings.setString(2, ds.targetPartition);
                    insertDatasetSettings.setString(3, ds.propagatedHash);
                    insertDatasetSettings.setLong(4, System.currentTimeMillis());
                    insertDatasetSettings.setString(5, ds.reason);
                    insertDatasetSettings.execute();
                    continue;
                }
                if (phi instanceof HashesModel.RecipeCodeHashInfo) {
                    HashesModel.RecipeCodeHashInfo rc = (HashesModel.RecipeCodeHashInfo)phi;
                    deleteRecipeCode.setString(1, rc.targetDS);
                    deleteRecipeCode.setString(2, rc.targetPartition);
                    deleteRecipeCode.setString(3, rc.recipeFullName);
                    deleteRecipeCode.execute();
                    insertRecipeCode.setString(1, rc.targetDS);
                    insertRecipeCode.setString(2, rc.targetPartition);
                    insertRecipeCode.setString(3, rc.recipeFullName);
                    insertRecipeCode.setString(4, rc.propagatedHash);
                    insertRecipeCode.setLong(5, System.currentTimeMillis());
                    insertRecipeCode.setString(6, rc.reason);
                    insertRecipeCode.execute();
                    continue;
                }
                if (!(phi instanceof HashesModel.GeneratorHashInfo)) continue;
                HashesModel.GeneratorHashInfo gh = (HashesModel.GeneratorHashInfo)phi;
                deleteGenerator.setString(1, gh.targetDS);
                deleteGenerator.setString(2, gh.targetPartition);
                deleteGenerator.setString(3, gh.taskId);
                deleteGenerator.execute();
                insertGenerator.setString(1, gh.targetDS);
                insertGenerator.setString(2, gh.targetPartition);
                insertGenerator.setString(3, gh.taskId);
                insertGenerator.setString(4, gh.propagatedHash);
                insertGenerator.setLong(5, System.currentTimeMillis());
                insertGenerator.setString(6, gh.reason);
                insertGenerator.execute();
            }
            conn.commit();
            logger.infoV("Hashes propagated in %d ms", new Object[]{System.currentTimeMillis() - before});
        }
    }

    /*
     * Exception decompiling
     */
    public List<HashesModel.PropagatedHashInfo> getAllPropagatedFor(DSSDBConnection conn, String targetDS, String targetPartition) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void clearForDataset(DSSDBConnection conn, String fullDatasetName) throws SQLException {
        try {
            try (PreparedStatement ps2 = conn.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable(SRC_DATASET_HASH_TABLE)).withParameterizedEqualWheres(TARGET_DS_COLUMN).toSql(this.getDialect()));){
                ps2.setString(1, fullDatasetName);
                ps2.execute();
            }
            ps2 = conn.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable(RECIPE_CODE_HASH_TABLE)).withParameterizedEqualWheres(TARGET_DS_COLUMN).toSql(this.getDialect()));
            try {
                ps2.setString(1, fullDatasetName);
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            ps2 = conn.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable(GENERATOR_HASH_TABLE)).withParameterizedEqualWheres(TARGET_DS_COLUMN).toSql(this.getDialect()));
            try {
                ps2.setString(1, fullDatasetName);
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            ps2 = conn.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable(DATASET_SETTINGS_HASH_TABLE)).withParameterizedEqualWheres(TARGET_DS_COLUMN).toSql(this.getDialect()));
            try {
                ps2.setString(1, fullDatasetName);
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            conn.commit();
        }
        catch (SQLException e) {
            conn.rollback();
            throw e;
        }
    }

    public void clearForDatasetPartitions(DSSDBConnection conn, String fullDatasetName, List<String> partitionIds) throws SQLException {
        try {
            for (String pid : partitionIds) {
                try (PreparedStatement ps2 = conn.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable(SRC_DATASET_HASH_TABLE)).withParameterizedEqualWheres(TARGET_DS_COLUMN, TARGET_PARTITION_COLUMN).toSql(this.getDialect()));){
                    ps2.setString(1, fullDatasetName);
                    ps2.setString(2, pid);
                    ps2.execute();
                }
                ps2 = conn.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable(RECIPE_CODE_HASH_TABLE)).withParameterizedEqualWheres(TARGET_DS_COLUMN, TARGET_PARTITION_COLUMN).toSql(this.getDialect()));
                try {
                    ps2.setString(1, fullDatasetName);
                    ps2.setString(2, pid);
                    ps2.execute();
                }
                finally {
                    if (ps2 != null) {
                        ps2.close();
                    }
                }
                ps2 = conn.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable(GENERATOR_HASH_TABLE)).withParameterizedEqualWheres(TARGET_DS_COLUMN, TARGET_PARTITION_COLUMN).toSql(this.getDialect()));
                try {
                    ps2.setString(1, fullDatasetName);
                    ps2.setString(2, pid);
                    ps2.execute();
                }
                finally {
                    if (ps2 != null) {
                        ps2.close();
                    }
                }
                ps2 = conn.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable(DATASET_SETTINGS_HASH_TABLE)).withParameterizedEqualWheres(TARGET_DS_COLUMN, TARGET_PARTITION_COLUMN).toSql(this.getDialect()));
                try {
                    ps2.setString(1, fullDatasetName);
                    ps2.setString(2, pid);
                    ps2.execute();
                }
                finally {
                    if (ps2 == null) continue;
                    ps2.close();
                }
            }
            conn.commit();
        }
        catch (SQLException e) {
            conn.rollback();
            throw e;
        }
    }
}

