/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.common;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.common.CodeBasedThingHelper;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ProcessResourceUsageMonitor;
import com.dataiku.dip.resourceusage.WithMaybePid;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.InsecureProcessesLaunchService;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.log4j.Level;
import org.springframework.beans.factory.annotation.Autowired;

public class JobProcessExecution {
    @Autowired
    private InsecureProcessesLaunchService insecureLaunchService;
    protected final AuthCtx authCtx;
    protected final String projectKey;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.code.base");

    public JobProcessExecution(AuthCtx authCtx, String projectKey) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        SpringUtils.getInstance().autowire((Object)this);
    }

    protected void prepareExecOutputConsumer(DKUtils.ExecOutputConsumer eoc, DKUtils.LineSubscription fwr) throws Exception {
        eoc.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withOutputConsumer((DKUtils.ExecSubscription)fwr);
    }

    protected void checkErrorsFromLogSniffers() {
    }

    protected void processStarted(IsolableProcess p) {
    }

    protected LineSubscriptionProvider getFileLoggingSubscription(File logFile) throws FileNotFoundException {
        final OutputStreamWriter fwr = new OutputStreamWriter((OutputStream)new FileOutputStream(logFile), StandardCharsets.UTF_8);
        return new LineSubscriptionProvider(){

            @Override
            public void close() throws Exception {
                fwr.close();
            }

            @Override
            public DKUtils.LineSubscription get() {
                return new DKUtils.OutputWriterSubscription((Writer)fwr, false);
            }
        };
    }

    public CodeBasedThingHelper.ExecutionResult executeNoFail(ProcessBuilder builder, Object optionalInput, File logOutputFile, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, boolean forceDisableImpersonation) throws Exception {
        RegularProcess p;
        File processRunDir = builder.directory();
        assert (processRunDir != null);
        CodeBasedThingHelper.ExecutionResult result = new CodeBasedThingHelper.ExecutionResult();
        result.logOutputFile = logOutputFile;
        if (forceDisableImpersonation) {
            logger.trace((Object)("Run command securely, as user " + System.getProperty("user.name")));
            p = new RegularProcess(builder, processRunDir);
            p.start();
        } else {
            logger.trace((Object)("Run command insecurely, from user " + System.getProperty("user.name")));
            p = this.insecureLaunchService.launch(this.authCtx, this.projectKey, cgrouppableProcessType, processRunDir, builder);
        }
        this.processStarted((IsolableProcess)p);
        try (LineSubscriptionProvider fwrProvider = this.getFileLoggingSubscription(result.logOutputFile);){
            DKUtils.ExecOutputConsumer eoc = new DKUtils.ExecOutputConsumer().withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withErrorConsumer((DKUtils.ExecSubscription)fwrProvider.get());
            this.prepareExecOutputConsumer(eoc, fwrProvider.get());
            eoc.start(p.getInputStream(), p.getErrorStream(), null);
            Object inFeeder = null;
            if (optionalInput != null) {
                OutputStream processOutputStream = p.getOutputStream();
                if (optionalInput instanceof String) {
                    PrintStream stream = new PrintStream(processOutputStream);
                    stream.append((String)optionalInput);
                    stream.close();
                    processOutputStream.close();
                } else if (optionalInput instanceof CodeBasedThingHelper.OptionalInputFactory) {
                    inFeeder = ((CodeBasedThingHelper.OptionalInputFactory)optionalInput).prepareInputFeeder(processOutputStream);
                    ((Thread)inFeeder).start();
                } else {
                    throw new Exception("Cannot handle optional input of type : " + optionalInput.getClass().getCanonicalName());
                }
            }
            if (inFeeder != null) {
                logger.info((Object)("Process reads from " + inFeeder.getClass().getCanonicalName()));
            }
            ComputeResourceUsage cru = ComputeResourceUsage.forLocalProcess();
            ProcessResourceUsageMonitor resourceMonitorThread = null;
            if (cgrouppableProcessType != null || builder.command().get(0).contains("spark-submit")) {
                cru.reportStartNoFail();
                resourceMonitorThread = new ProcessResourceUsageMonitor(cru, builder.command().get(0), (WithMaybePid)p);
                resourceMonitorThread.start();
            }
            result.returnValue = p.waitFor();
            eoc.finish();
            if (resourceMonitorThread != null) {
                resourceMonitorThread.finish(true);
                cru.reportCompleteNoFail();
            }
            this.checkErrorsFromLogSniffers();
            if (inFeeder != null) {
                ((Thread)inFeeder).join();
            }
        }
        return result;
    }

    public static interface LineSubscriptionProvider
    extends AutoCloseable {
        public DKUtils.LineSubscription get() throws FileNotFoundException;
    }
}

