/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.Initializable;
import com.dataiku.dip.dataflow.exec.stream.ToDatasetStreamer;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.SingleInputRowProcessor;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPuller;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SISORecipeRunner
implements FlowRunnable,
Initializable {
    protected JobActivity activity;
    protected FlowRecipe recipe;
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    private JobAuthCtxService authCtxService;

    @Override
    public void run() throws Exception {
        FlowDataset inputFD = this.activity.getSubgraph().getSingleSourceDataset();
        FlowDataset outputFD = this.activity.getSubgraph().getSingleTargetDataset();
        Dataset inputDS = inputFD.getMandatory(this.datasetsDAO);
        Dataset outputDS = outputFD.getMandatory(this.datasetsDAO);
        Schema input_schema = inputDS.getSchema();
        StreamableDatasetSelection ds = StreamableDatasetSelection.full();
        StreamColumnFactory cf = new StreamColumnFactory();
        StreamRowFactory rf = new StreamRowFactory();
        SerializedRecipe.RecipeOutput recipeOutput = this.recipe.getModel().getSingleOutput("main");
        Output.WriteMode writeMode = recipeOutput.getWriteMode();
        try (DatasetHandler outputDatasetHandler = DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), outputDS);){
            if (writeMode == Output.WriteMode.OVERWRITE && !outputDatasetHandler.outputHandlesClear()) {
                if (outputDatasetHandler instanceof AbstractFSDatasetHandler) {
                    ((AbstractFSDatasetHandler)outputDatasetHandler).clearPartitions(Arrays.asList(this.activity.getSubgraph().getTargetPartition(outputFD)));
                }
                writeMode = Output.WriteMode.APPEND;
            }
        }
        ToDatasetStreamer output = ToDatasetStreamer.newWithAutoBucketing(this.authCtxService.getAuthCtx(), outputDS, this.activity.getSubgraph().getTargetPartition(outputFD), (ColumnFactory)cf, this.activity.warnContext, writeMode);
        SingleInputRowProcessor out = output.getAsProcessor();
        if (inputDS.getPartitioningSchema().isPartitioned()) {
            ds.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.SELECTED;
            ds.selectedPartitions = new ArrayList();
            for (Partition p : this.activity.getSubgraph().getSourcePartitions(inputFD)) {
                ds.selectedPartitions.add(p.id());
            }
        }
        RowInputStream is = UniversalSingleThreadPuller.pull(this.authCtxService.getAuthCtx(), inputDS, ds, (ColumnFactory)cf, this.activity.warnContext);
        Schema outputSchema = new Schema();
        assert (input_schema != null);
        this.processInputOutput(is, out, (ColumnFactory)cf, (ColumnFactory)cf, input_schema, outputSchema, (RowFactory)rf);
        out.postProcess();
    }

    public abstract void processInputOutput(RowInputStream var1, SingleInputRowProcessor var2, ColumnFactory var3, ColumnFactory var4, Schema var5, Schema var6, RowFactory var7) throws Exception;
}

