/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.pivot;

import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import java.util.ArrayList;
import java.util.List;

public class PivotElement {
    public List<String> keyColumns = new ArrayList<String>();
    public PivotValueLimit valueLimit;
    public int topnLimit;
    public int minOccLimit;
    public List<List<String>> explicitValues = new ArrayList<List<String>>();
    public boolean globalCount = true;
    public List<GroupingRecipePayloadParams.GroupingValue> valueColumns = new ArrayList<GroupingRecipePayloadParams.GroupingValue>();

    public boolean isSameKeyColumnsDefinition(PivotElement other) {
        return this.keyColumns.equals(other.keyColumns);
    }

    public boolean isSameKeyDefinition(PivotElement other) {
        if (!this.isSameKeyColumnsDefinition(other)) {
            return false;
        }
        if (this.valueLimit != other.valueLimit) {
            return false;
        }
        if (this.valueLimit == PivotValueLimit.TOP_N && this.topnLimit != other.topnLimit) {
            return false;
        }
        if (this.valueLimit == PivotValueLimit.AT_LEAST_N_OCC && this.minOccLimit != other.minOccLimit) {
            return false;
        }
        return this.valueLimit != PivotValueLimit.EXPLICIT || this.explicitValues.equals(other.explicitValues);
    }

    public GroupingRecipePayloadParams.GroupingValue groupingValueForColumn(String column) {
        for (GroupingRecipePayloadParams.GroupingValue valueColumn : this.valueColumns) {
            if (!column.equals(valueColumn.column)) continue;
            return valueColumn;
        }
        throw new IllegalArgumentException("Cannot find aggregates for column " + column);
    }

    public static enum PivotValueLimit {
        NO_LIMIT,
        TOP_N,
        AT_LEAST_N_OCC,
        EXPLICIT;

    }
}

