/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sampling;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.sampling.SamplingRecipeStatusComputer;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class SamplingRecipeSchemaComputer
extends RecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    @Autowired
    private TransactionService transactionService;
    private String payload;

    public SamplingRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public void setPayload(String payload) {
        this.payload = payload;
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            Preconditions.checkArgument((boolean)role.equals("main"), (Object)("Recipe only has output role 'main', got: " + role));
            this.recipesValidationService.checkComplianceWithRecipeDesc(this.authCtx, this.recipe);
            ArrayList arrayList = Lists.newArrayList((Object[])new Schema[]{this.getSchema()});
            return arrayList;
        }
    }

    private Schema getSchema() throws Exception {
        SamplingRecipeStatusComputer sc = new SamplingRecipeStatusComputer(this.recipe, this.payload);
        SamplingRecipeStatusComputer.SamplingRecipeStatus status = sc.fastStatusIgnorePartitions(this.authCtx);
        return status.outputSchema;
    }
}

