/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.split;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.GenericRecipeCreator;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SplitRecipeCreator
extends GenericRecipeCreator {
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.split.creator");

    public SplitRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, JsonObject data) throws IOException {
        SplitRecipePayloadParams params = new SplitRecipePayloadParams();
        RecipeCreationUtils.setupAllEnginesCreationParams(this.authCtx, recipe.projectKey, params.engineParams);
        Dataset inputDataset = this.datasetAccessService.getMandatory(recipe.getSingleInput("main").getLoc(recipe.getProjectKey()));
        RecipeCreationUtils.switchToHiveserverForHiveDataset(inputDataset, params.engineParams);
        params.engineParams.lowerCaseSchemaIfEngineRequiresIt = true;
        return JSON.json((Object)params);
    }

    @Override
    public RecipeCreator.CreationResult copy_NT(String projectKey, SerializedRecipe.SerializedRecipeAndPayload source, JsonObject copyData) throws Exception {
        assert (StringUtils.isNotBlank((String)projectKey));
        assert (this.meta.getType().equals(source.recipe.type));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)source.recipe.name), (Object)"Recipe has no name");
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
            ArrayList<String> refs = new ArrayList<String>();
            ArrayList<Integer> mapping = new ArrayList<Integer>();
            RecipeCreator.CopySettings settings = (RecipeCreator.CopySettings)JSON.parse((JsonElement)copyData, RecipeCreator.CopySettings.class);
            List<SerializedRecipe.RecipeOutput> replacements = settings.outputs.get((Object)"main").items;
            for (SerializedRecipe.RecipeOutput newOutput : replacements) {
                AnyLoc loc = AnyLoc.resolveSmart(projectKey, newOutput.ref);
                String creationResult = loc.getSmartName(projectKey);
                int index = refs.indexOf(creationResult);
                if (index < 0) {
                    mapping.add(refs.size());
                    refs.add(creationResult);
                    continue;
                }
                mapping.add(index);
            }
            SerializedRecipe copy = this.copyCore((String)projectKey, (SerializedRecipe)source.recipe, (String)source.payload, (JsonObject)copyData).recipe;
            SplitRecipePayloadParams params = (SplitRecipePayloadParams)JSON.parse((String)source.payload, SplitRecipePayloadParams.class);
            if (params.valueSplits != null) {
                for (SplitRecipePayloadParams.ValueSplitDesc valueSplitDesc : params.valueSplits) {
                    if (valueSplitDesc.outputIndex < 0) continue;
                    valueSplitDesc.outputIndex = (Integer)mapping.get(valueSplitDesc.outputIndex);
                }
            }
            if (params.filterSplits != null) {
                for (SplitRecipePayloadParams.FilterSplitDesc filterSplitDesc : params.filterSplits) {
                    if (filterSplitDesc.outputIndex < 0) continue;
                    filterSplitDesc.outputIndex = (Integer)mapping.get(filterSplitDesc.outputIndex);
                }
            }
            if (params.defaultOutputIndex >= 0) {
                params.defaultOutputIndex = (Integer)mapping.get(params.defaultOutputIndex);
            }
            String payload = JSON.pretty((Object)params);
            this.recipeSaveService.create(projectKey, copy, payload);
            t.commitV("Created %s recipe %s", new Object[]{copy.type, copy.name});
            RecipeCreator.CreationResult creationResult = new RecipeCreator.CreationResult().withId(copy.name);
            return creationResult;
        }
    }
}

