/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.DelegateFSDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class FastPathDatasetTypeStraightener {
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    private static Logger logger = Logger.getLogger((String)"dip.sync.fast.type.compat");

    public FastPathDatasetTypeStraightener() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public boolean isEquivalentTo(Dataset ds, String ... types) {
        HashSet accepted = Sets.newHashSet((Object[])types);
        if (accepted.contains(ds.getType())) {
            return true;
        }
        if ("FilesInFolder".equals(ds.getType())) {
            BuiltinFSDatasets.FilesInFolderConfig config = ds.getParamsAs(BuiltinFSDatasets.FilesInFolderConfig.class);
            ManagedFolder odb = this.getFolderOrNull(ds.getProjectKey(), config.folderSmartId);
            return odb != null && accepted.contains(odb.type);
        }
        if ("UploadedFiles".equals(ds.getType())) {
            BuiltinFSDatasets.UploadedFilesConfig config = ds.getParamsAs(BuiltinFSDatasets.UploadedFilesConfig.class);
            if (StringUtils.isNotBlank((String)config.getConnection()) && config.uploadedConfig != null && StringUtils.isNotBlank((String)config.uploadFSProviderType)) {
                return accepted.contains(config.uploadFSProviderType);
            }
            return false;
        }
        return false;
    }

    public DSSConnection getConnectionUnsafeUnexpandedOrNull(AuthCtx authCtx, Dataset ds, String ... types) throws IOException, DKUSecurityException {
        String connectionName;
        HashSet accepted = Sets.newHashSet((Object[])types);
        if (accepted.contains(ds.getType())) {
            connectionName = ds.getParams().getConnection();
        } else if ("FilesInFolder".equals(ds.getType())) {
            BuiltinFSDatasets.FilesInFolderConfig config = ds.getParamsAs(BuiltinFSDatasets.FilesInFolderConfig.class);
            ManagedFolder odb = this.getFolderOrNull(ds.getProjectKey(), config.folderSmartId);
            connectionName = odb != null ? odb.getParams().getConnection() : null;
        } else {
            connectionName = "UploadedFiles".equals(ds.getType()) ? ds.getParams().getConnection() : null;
        }
        if (StringUtils.isBlank((String)connectionName)) {
            return null;
        }
        return this.connectionsDAO.getConnectionUnsafeUnexpanded(authCtx, connectionName);
    }

    public DSSConnection getMandatoryConnectionUnsafeUnexpanded(AuthCtx authCtx, Dataset ds, String ... types) throws IOException, DKUSecurityException {
        DSSConnection conn = this.getConnectionUnsafeUnexpandedOrNull(authCtx, ds, types);
        if (conn == null) {
            throw new IOException("Connection not found for dataset " + ds.getFullName());
        }
        return conn;
    }

    private ManagedFolder getFolderOrNull(String projectKey, String smartId) {
        if (StringUtils.isNotBlank((String)smartId)) {
            try {
                AnyLoc loc = DatasetLocUtils.DatasetLoc.resolveSmart(projectKey, smartId);
                return (ManagedFolder)this.managedFolderDAO.getOrNullUnsafe(loc);
            }
            catch (IOException e) {
                logger.warn((Object)"Unable to check type compatibility for files-in-folder dataset", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public <T extends AbstractFSDatasetHandler> T getDatasetHandler(AuthCtx authCtx, Dataset ds) throws IOException {
        if ("FilesInFolder".equals(ds.getType()) || "UploadedFiles".equals(ds.getType())) {
            DelegateFSDatasetHandler delegated = (DelegateFSDatasetHandler)DatasetHandlerFactory.build(authCtx, ds);
            return (T)delegated.getRealHandler();
        }
        return (T)((AbstractFSDatasetHandler)DatasetHandlerFactory.build(authCtx, ds));
    }
}

