/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.utils.DKULogger;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class FastpathUtils {
    private static final Pattern SNOWFLAKE_DATE_ERROR = Pattern.compile("\\bDate\\b ('[0-9]+\\/[0-9]+\\/[0-9]+') \\bis not recognized\\b");
    private static final Pattern SNOWFLAKE_UNKNOWN_STAGE_PATTERN = Pattern.compile("Stage.*does not exist or not authorized");
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.fastpath");

    public static boolean containsColumn(List<SchemaColumn> inputColumnNames, String columnName) {
        for (SchemaColumn col : inputColumnNames) {
            if (!col.getName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public static String getPartitionValue(String columnName, Partition partition) {
        Map dimensionValues = partition.getDimensionValues();
        if (!dimensionValues.containsKey(columnName)) {
            throw new IllegalStateException("Missing partition value: " + columnName + " in partition: " + String.valueOf(partition));
        }
        return ((DimensionValue)dimensionValues.get(columnName)).id();
    }

    public static boolean hasInputPartitions(List<Partition> inputPartitions) {
        return inputPartitions != null && !inputPartitions.isEmpty() && inputPartitions.stream().anyMatch(partition -> !partition.isNP());
    }

    public static Schema getTemporaryTableSchemaForCloudSync(Dataset inputDS, Dataset outputDS) {
        Set outputPartitionDimensionSet = outputDS.getPartitioningSchema().getDimensionNamesSet();
        List filteredColumns = inputDS.getSchema().getColumns().stream().filter(input -> !outputPartitionDimensionSet.contains(input.getName())).collect(Collectors.toList());
        return new Schema(filteredColumns, inputDS.getSchema().userModified);
    }

    public static boolean inputDatasetHasDateOnlyColumn(Dataset inputDataset) {
        return inputDataset.getSchema().columns.stream().anyMatch(sc -> sc.getType() == Type.DATEONLY);
    }

    public static void adjustTemporaryTableSchemaForCsvInput(Schema temporaryTableSchema) {
        for (SchemaColumn column : temporaryTableSchema.getColumns()) {
            if (column.getType() != Type.DATEONLY) continue;
            column.setType(Type.STRING);
            column.maxLength = 20;
        }
    }

    public static Schema getTemporaryTableSchemaForDBSync(Dataset inputDS, Dataset outputDS) {
        List filteredColumns = outputDS.getSchema().getCopy().getColumns().stream().filter(outputColumn -> inputDS.getSchema().hasColumn(outputColumn.getName())).collect(Collectors.toList());
        return new Schema(filteredColumns, outputDS.getSchema().userModified);
    }

    public static SQLException checkDateFormatError(Exception exc, Pattern errorDate, String database) {
        String error = exc.getMessage();
        Matcher m = errorDate.matcher(error);
        if (m.find()) {
            logger.error((Object)("Invalid date suspected, " + m.group(1) + " not in expected format. "), (Throwable)exc);
            return new SQLException("Invalid date " + m.group(1) + ", dates must be in the 'yyyy-MM-dd' format to use fast-write into " + database);
        }
        return null;
    }

    public static SQLException sanitizeSnowflakeExceptions(Exception exception) {
        Matcher stageMatcher = SNOWFLAKE_UNKNOWN_STAGE_PATTERN.matcher(exception.getMessage());
        if (stageMatcher.find()) {
            return new SQLException("The external stage was not found. Maybe you need to qualify it with the schema and/or database name in the cloud storage connection settings?", exception);
        }
        return FastpathUtils.checkDateFormatError(exception, SNOWFLAKE_DATE_ERROR, "Snowflake");
    }

    public static String placeSnowflakeStageInRootPath(String rootPath, String pathToReplace, String snowflakeExternalStageName, String connectionName) {
        if (StringUtils.isNotBlank((String)snowflakeExternalStageName)) {
            if (rootPath.startsWith(pathToReplace)) {
                rootPath = rootPath.replaceFirst(pathToReplace, "@" + snowflakeExternalStageName);
            } else {
                throw new IllegalArgumentException(String.format("An external stage '%s' and path is defined in the '%s' connection, but the dataset location '%s' is not within the defined external stage path '%s'", snowflakeExternalStageName, connectionName, rootPath, pathToReplace));
            }
        }
        return rootPath;
    }
}

