/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graph.utils;

import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.partitioning.Partition;
import com.google.common.collect.Lists;

public class SubgraphUtils {
    public static void addSubgraphSourcesToOtherSubgraphSources(RunnableSubgraph fromSubgraph, RunnableSubgraph toSubgraph) {
        for (FlowComputable flowComputable : fromSubgraph.getSources()) {
            if (!toSubgraph.getSources().contains(flowComputable)) {
                toSubgraph.addSource_NoRole(flowComputable);
            }
            for (Partition p : fromSubgraph.getSourcePartitions(flowComputable)) {
                if (toSubgraph.getSourcePartitions().containsKey(flowComputable.getFullId())) {
                    toSubgraph.getSourcePartitions().get(flowComputable.getFullId()).add(p);
                    continue;
                }
                toSubgraph.getSourcePartitions().put(flowComputable.getFullId(), Lists.newArrayList((Object[])new Partition[]{p}));
            }
        }
    }

    public static void addSubgraphTargetsToOtherSubgraphSources(RunnableSubgraph fromSubgraph, RunnableSubgraph toSubgraph) {
        for (FlowComputable flowComputable : fromSubgraph.getTargets()) {
            if (!toSubgraph.getSources().contains(flowComputable)) {
                toSubgraph.addSource_NoRole(flowComputable);
            }
            if (toSubgraph.getSourcePartitions().containsKey(flowComputable.getFullId())) {
                toSubgraph.getSourcePartitions().get(flowComputable.getFullId()).add(fromSubgraph.getTargetPartition(flowComputable));
                continue;
            }
            toSubgraph.getSourcePartitions().put(flowComputable.getFullId(), Lists.newArrayList((Object[])new Partition[]{fromSubgraph.getTargetPartition(flowComputable)}));
        }
    }

    public static void addSubgraphTargetsToOtherSubgraphTargets(RunnableSubgraph fromSubgraph, RunnableSubgraph toSubgraph) {
        for (FlowComputable flowComputable : fromSubgraph.getTargets()) {
            if (!toSubgraph.getTargets().contains(flowComputable)) {
                toSubgraph.addTarget_NoRole(flowComputable);
            }
            toSubgraph.getTargetPartitions().put(flowComputable.getFullId(), fromSubgraph.getTargetPartition(flowComputable));
        }
    }
}

