/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.Job;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowModelEvaluationStore;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.dataflow.graphtools.PipelinesViewFakeJobComputer;
import com.dataiku.dip.dataflow.pipeline.AbstractPipelineRunnableSubgraph;
import com.dataiku.dip.dataflow.pipeline.PipelineabilityEvaluator;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class PipelinesView
extends AbstractFlowTool.FlowView {
    private static final String PIPELINES_NOT_ENABLED_ERROR_MESSAGE = "%s pipelines are not enabled in this project, go to the project settings to enable them";
    @Autowired
    private ProjectsDAO projectsDAO;
    private PipelinesViewState state;
    private Map<String, String> pipelinesNamesCache;
    private final RecipePipelineHelper.PipelineType pipelineType;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.tools.pipelines");

    public PipelinesView(AuthCtx authCtx, String projectKey, RecipePipelineHelper.PipelineType pipelineType) {
        super(authCtx, projectKey);
        this.pipelineType = pipelineType;
    }

    @Override
    public AbstractFlowTool.FlowState getFlowState(JsonObject options) throws Exception {
        if (this.state != null) {
            Collection<String> currentFocus = this.state.focused;
            this.computeState();
            this.state.focused = currentFocus;
        } else {
            this.computeState();
        }
        return this.state;
    }

    @Override
    public synchronized PipelinesViewState computeState() throws Exception {
        this.state = new PipelinesViewState();
        this.pipelinesNamesCache = new HashMap<String, String>();
        try (Transaction tr = this.transactionService.beginRead();){
            PipelinesView.checkPipelinesEnabled(this.projectsDAO.getOrNullUnsafe(this.projectKey), this.pipelineType);
            FutureProgressState.checkInterrupt();
            ProjectFlowGraph graph = new ProjectFlowGraph();
            graph.buildForProject(this.projectKey, false, false);
            this.computePipelinesAndAddRecipes(graph, this.pipelineType);
            this.addNotPipelinedRecipes(graph, this.pipelineType);
            this.addVirtualizableDatasets();
        }
        return this.state;
    }

    static void checkPipelinesEnabled(SerializedProject sp, RecipePipelineHelper.PipelineType pipelineType) throws InterruptedException {
        FutureProgressState.checkInterrupt();
        if (pipelineType == RecipePipelineHelper.PipelineType.SPARK && !sp.settings.flowBuildSettings.mergeSparkPipelines) {
            throw ErrorContext.iaef((String)PIPELINES_NOT_ENABLED_ERROR_MESSAGE, (Object)"Spark", (Object[])new Object[0]);
        }
        if (pipelineType == RecipePipelineHelper.PipelineType.SQL && !sp.settings.flowBuildSettings.mergeSqlPipelines) {
            throw ErrorContext.iaef((String)PIPELINES_NOT_ENABLED_ERROR_MESSAGE, (Object)"SQL", (Object[])new Object[0]);
        }
    }

    @Override
    public void setFocus(Collection<String> focused) throws Exception {
        if (this.state == null) {
            this.computeState();
        }
        this.state.focused = focused == null ? new HashSet<String>() : focused;
    }

    private void addNotPipelinedRecipes(FlowGraph graph, RecipePipelineHelper.PipelineType pipelineType) throws DKUSecurityException, InterruptedException {
        PipelineabilityEvaluator spe = new PipelineabilityEvaluator(pipelineType);
        for (FlowRecipe fr : graph.recipes) {
            FutureProgressState.checkInterrupt();
            PipelineabilityEvaluator.Pipelineability p = spe.isPipelineable(fr, this.authCtx);
            if (p == PipelineabilityEvaluator.NOT_PIPELINEABLE) continue;
            this.addRecipePipelineabilityInfo(fr, p);
        }
    }

    private void addVirtualizableDatasets() throws IOException, InterruptedException {
        for (SerializedDataset sd : this.datasetsDAO.listUnsafe(this.projectKey)) {
            FutureProgressState.checkInterrupt();
            try {
                if (!sd.flowOptions.virtualizable) continue;
                this.addVirtualizableDataset(sd.name);
            }
            catch (Exception e) {
                logger.info((Object)"Failed to get dataset settings", (Throwable)e);
            }
        }
    }

    private String getPipelineName(String pipelineId) {
        if (!this.pipelinesNamesCache.containsKey(pipelineId)) {
            int idx = this.pipelinesNamesCache.size() + 1;
            this.pipelinesNamesCache.put(pipelineId, "Pipeline " + idx);
        }
        return this.pipelinesNamesCache.get(pipelineId);
    }

    private void computePipelinesAndAddRecipes(FlowGraph graph, RecipePipelineHelper.PipelineType pipelineType) throws Exception {
        JobDef jobDef = this.makeJobDef(graph);
        Job fakeJob = new PipelinesViewFakeJobComputer(this.authCtx, jobDef, graph).compute(pipelineType);
        this.processActivity(fakeJob.topLevelActivity);
    }

    private void processActivity(JobActivity root) throws InterruptedException {
        RunnableSubgraph subgraph = root.getSubgraph();
        if (subgraph instanceof AbstractPipelineRunnableSubgraph) {
            AbstractPipelineRunnableSubgraph pipelineSubgraph = (AbstractPipelineRunnableSubgraph)subgraph;
            for (JobActivity includedActivity : pipelineSubgraph.getAllIncludedActivitiesWithRoot()) {
                FutureProgressState.checkInterrupt();
                if (!(includedActivity.getSubgraph() instanceof RecipeRunnableSubgraph)) continue;
                RecipeRunnableSubgraph includedSubgraph = (RecipeRunnableSubgraph)includedActivity.getSubgraph();
                this.addPipelinedRecipe(includedSubgraph.getRecipe(), pipelineSubgraph.id());
            }
        }
        for (JobActivity activity : root.dependencies) {
            this.processActivity(activity);
        }
    }

    private void addRecipePipelineabilityInfo(FlowRecipe fr, PipelineabilityEvaluator.Pipelineability p) {
        String nodeId = GraphIds.forRecipe(fr);
        RecipePipelineState val = this.state.valueByNode.containsKey(nodeId) ? (RecipePipelineState)this.state.valueByNode.get(nodeId) : new RecipePipelineState();
        val.allowStart = p.start;
        val.allowMerge = p.merge;
        this.state.valueByNode.put(nodeId, val);
    }

    private void addPipelinedRecipe(FlowRecipe fr, String pipelineId) {
        RecipePipelineState val = new RecipePipelineState();
        String nodeId = GraphIds.forRecipe(fr);
        val.pipelineId = this.getPipelineName(pipelineId);
        this.state.valueByNode.put(nodeId, val);
    }

    private void addVirtualizableDataset(String name) {
        DatasetPipelineState val = new DatasetPipelineState();
        val.virtualizable = true;
        String nodeId = GraphIds.forDataset(this.projectKey, name);
        this.state.valueByNode.put(nodeId, val);
    }

    private JobDef makeJobDef(FlowGraph graph) {
        String name;
        JobDef def = new JobDef();
        def.id = "Fake";
        def.name = "Fake";
        def.projectKey = this.projectKey;
        def.type = JobDef.JobType.RECURSIVE_FORCED_BUILD;
        for (FlowDataset fd : graph.datasets.values()) {
            if (fd.getPredecessors().isEmpty() || !fd.getSuccessors().isEmpty()) continue;
            name = AnyLoc.resolveFull(fd.getFullId()).getId();
            def.outputs.add(new JobDef.JobOutput(this.projectKey, name, null));
        }
        for (FlowSavedModel sfm : graph.models.values()) {
            if (sfm.getPredecessors().isEmpty() || !sfm.getSuccessors().isEmpty()) continue;
            name = AnyLoc.resolveFull(sfm.getFullId()).getId();
            def.outputs.add(new JobDef.JobOutput(this.projectKey, name, null));
        }
        for (FlowModelEvaluationStore fmes : graph.evaluationStores.values()) {
            if (fmes.getPredecessors().isEmpty() || !fmes.getSuccessors().isEmpty()) continue;
            name = AnyLoc.resolveFull(fmes.getFullId()).getId();
            def.outputs.add(new JobDef.JobOutput(this.projectKey, name, null));
        }
        for (FlowManagedFolder fmf : graph.folders.values()) {
            if (fmf.getPredecessors().isEmpty() || !fmf.getSuccessors().isEmpty()) continue;
            name = AnyLoc.resolveFull(fmf.getFullId()).getId();
            def.outputs.add(new JobDef.JobOutput(this.projectKey, name, null));
        }
        return def;
    }

    public class PipelinesViewState
    implements AbstractFlowTool.FlowState {
        Map<String, PipelineNodeState> valueByNode = new HashMap<String, PipelineNodeState>();
        public Collection<String> focused = new HashSet<String>();
    }

    public class RecipePipelineState
    extends PipelineNodeState {
        public boolean allowMerge;
        public boolean allowStart;
    }

    public class DatasetPipelineState
    extends PipelineNodeState {
        boolean virtualizable;
    }

    abstract class PipelineNodeState {
        String pipelineId;

        PipelineNodeState() {
        }
    }
}

