/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.jobrunner.status;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.dataflow.ActivityState;
import com.dataiku.dip.dataflow.graph.utils.GraphSerializerCommon;
import com.dataiku.dip.dataflow.jobrunner.JobRuntimeSummary;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobStatus;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.services.FlowExecutionService2;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.j2py.annotations.PyModel;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.log4j.Logger;

@PyModel
public class EnhancedSerializedJobStatus {
    public boolean removed;
    public PublicUser initiator;
    public SerializedJobStatus baseStatus;
    public Map<String, List<String>> activityIdsByRecipeName = new HashMap<String, List<String>>();
    public List<YarnLog> yarnLogs;
    public List<K8SLog> k8sLogs;
    public StepJobStatus stepRun;
    GlobalState globalState = new GlobalState();
    public Map<String, RecipeState> stateByGraphNodeId = new HashMap<String, RecipeState>();
    public String errorMessage;
    public SerializedError error;
    public SmartLogTail logTail;
    public String logTailActivityId = null;
    public JobRuntimeSummary runtimeSummary;
    private static Logger logger = Logger.getLogger((String)"dku.job");

    public EnhancedSerializedJobStatus(SerializedJobStatus baseStatus) {
        this.baseStatus = baseStatus;
        this.compute();
    }

    private void compute() {
        File jobFolder = FlowJobUtils.jobFolder(false, this.baseStatus.def.projectKey, this.baseStatus.def.id);
        Pattern yarnLogPattern = Pattern.compile("^(.*)\\.(application_[0-9]{13}_[0-9]{4})\\.log$");
        ArrayList yarnLogList = Lists.newArrayList();
        if (jobFolder.exists()) {
            for (File f : jobFolder.listFiles()) {
                Iterator<Object> activityId;
                Matcher yarnLogMatcher;
                if (!f.isFile() || !(yarnLogMatcher = yarnLogPattern.matcher(f.getName())).matches() || !this.baseStatus.activities.containsKey(activityId = yarnLogMatcher.group(1))) continue;
                String yarnAppId = yarnLogMatcher.group(2);
                yarnLogList.add(new YarnLog((String)((Object)activityId), yarnAppId));
            }
        }
        if (yarnLogList.size() > 0) {
            this.yarnLogs = yarnLogList;
        }
        Pattern k8sLogPattern = Pattern.compile("^(.*)\\.pod.log$");
        ArrayList k8sLogList = Lists.newArrayList();
        if (jobFolder.exists()) {
            for (String activityId : this.baseStatus.activities.keySet()) {
                File activityFolder = new File(jobFolder, activityId);
                if (!activityFolder.exists()) continue;
                for (File f : FileUtils.listFiles((File)activityFolder, (String[])new String[]{"log"}, (boolean)true)) {
                    Matcher k8sLogMatcher;
                    if (!f.isFile() || !(k8sLogMatcher = k8sLogPattern.matcher(f.getName())).matches()) continue;
                    String podName = k8sLogMatcher.group(1);
                    k8sLogList.add(new K8SLog(activityId, podName));
                }
            }
        }
        if (k8sLogList.size() > 0) {
            this.k8sLogs = k8sLogList;
        }
        ArrayListMultimap statesPerRecipeName = ArrayListMultimap.create();
        HashMap<String, String> recipeTypePerRecipeName = new HashMap<String, String>();
        HashMap<String, MutableInt> warningsPerRecipeName = new HashMap<String, MutableInt>();
        for (SerializedJobActivityStatus sjas : this.baseStatus.activities.values()) {
            ArrayList<String> recipeNames = new ArrayList<String>();
            if (sjas.activityType == SerializedJobActivityStatus.ActivityType.SPARK_PIPELINE || sjas.activityType == SerializedJobActivityStatus.ActivityType.SQL_PIPELINE) {
                for (SerializedJobActivityStatus.PipelineRecipe pipelineRecipe : sjas.pipelineRecipes) {
                    recipeNames.add(pipelineRecipe.recipeName);
                    recipeTypePerRecipeName.put(pipelineRecipe.recipeName, pipelineRecipe.recipeType);
                }
            } else {
                recipeNames.add(sjas.recipeName);
                recipeTypePerRecipeName.put(sjas.recipeName, sjas.recipeType);
            }
            for (String recipeName : recipeNames) {
                List<String> list = this.activityIdsByRecipeName.get(recipeName);
                if (list == null) {
                    list = new ArrayList<String>();
                    this.activityIdsByRecipeName.put(recipeName, list);
                }
                list.add(sjas.activityId);
                statesPerRecipeName.put((Object)recipeName, (Object)sjas.state);
                if (sjas.getWarningsTotalCount() <= 0) continue;
                if (warningsPerRecipeName.get(recipeName) != null) {
                    ((MutableInt)warningsPerRecipeName.get(recipeName)).increment();
                    continue;
                }
                warningsPerRecipeName.put(recipeName, new MutableInt(1));
            }
        }
        for (String recipeName : statesPerRecipeName.keySet()) {
            String graphNodeId = GraphSerializerCommon.graphVizEscape("recipe_" + recipeName);
            RecipeState rs2 = new RecipeState();
            rs2.recipeName = recipeName;
            rs2.recipeType = (String)recipeTypePerRecipeName.get(recipeName);
            rs2.uiFilterExpr = rs2.recipeName;
            if (warningsPerRecipeName.get(recipeName) != null) {
                this.globalState.warning += ((MutableInt)warningsPerRecipeName.get(recipeName)).intValue();
                rs2.warning = ((MutableInt)warningsPerRecipeName.get(recipeName)).intValue();
            }
            for (ActivityState state : statesPerRecipeName.get((Object)recipeName)) {
                ++this.globalState.total;
                ++rs2.total;
                switch (state) {
                    case ABORTED: {
                        ++this.globalState.aborted;
                        ++rs2.aborted;
                        break;
                    }
                    case WAITING: {
                        break;
                    }
                    case DONE: {
                        ++this.globalState.done;
                        ++rs2.done;
                        break;
                    }
                    case FAILED: {
                        ++this.globalState.failed;
                        ++rs2.failed;
                        break;
                    }
                    case NOT_STARTED: {
                        ++this.globalState.notStarted;
                        ++rs2.notStarted;
                        break;
                    }
                    case RUNNING: {
                        ++this.globalState.running;
                        ++rs2.running;
                        break;
                    }
                    case SKIPPED: {
                        ++this.globalState.skipped;
                        ++rs2.skipped;
                    }
                }
            }
            if (rs2.warning > 0) {
                rs2.done -= rs2.warning;
            }
            rs2.state = rs2.failed + rs2.done + rs2.running + rs2.warning + rs2.aborted + rs2.skipped == 0 ? "NOT_STARTED" : (rs2.aborted > 0 ? "ABORTED" : (rs2.failed > 0 ? "FAILED" : (rs2.done + rs2.warning + rs2.skipped < rs2.total ? "RUNNING" : (rs2.warning > 0 ? "WARNING" : (rs2.skipped > 0 ? "SKIPPED" : "DONE")))));
            this.stateByGraphNodeId.put(graphNodeId, rs2);
        }
        try {
            for (SerializedJobActivityStatus activity : this.baseStatus.activities.values()) {
                File activityLogFile;
                if (activity.state != ActivityState.FAILED) continue;
                if (activity.firstFailure != null) {
                    this.error = activity.firstFailure;
                    this.errorMessage = activity.firstFailure.detailedMessage;
                }
                if (!(activityLogFile = DKUFileUtils.getWithin((File)FlowJobUtils.jobFolder(false, this.baseStatus.def.projectKey, this.baseStatus.def.id), (String[])new String[]{activity.activityId + ".log"})).exists()) continue;
                String logTail = DKUtils.tailFile((File)activityLogFile, (int)300);
                this.logTail = FlowJobUtils.getSmartLogTail(logTail, activity.activityId);
                this.logTailActivityId = activity.activityId;
            }
            if (this.error == null && this.baseStatus.unexpectedFailure != null) {
                this.error = this.baseStatus.unexpectedFailure;
                this.errorMessage = this.baseStatus.unexpectedFailure.detailedMessage;
                File jobLogFile = FlowJobUtils.jobLogOutputFile(false, this.baseStatus.def.projectKey, this.baseStatus.def.id);
                if (jobLogFile.exists()) {
                    this.logTail = FlowJobUtils.getSmartLogTail(DKUtils.tailFile((File)jobLogFile, (int)300), null);
                }
            }
            if (this.error == null && this.baseStatus.checksFailure != null) {
                this.error = this.baseStatus.checksFailure;
                this.errorMessage = this.baseStatus.checksFailure.detailedMessage;
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not retrieve error details", (Throwable)e);
        }
    }

    public static class GlobalState {
        int notStarted = 0;
        int failed = 0;
        int done = 0;
        int running = 0;
        int total = 0;
        int skipped = 0;
        int aborted = 0;
        int warning = 0;
    }

    public static class YarnLog {
        public String activityId;
        public String yarnAppId;

        public YarnLog(String activityId, String yarnAppId) {
            this.activityId = activityId;
            this.yarnAppId = yarnAppId;
        }
    }

    public static class K8SLog {
        public String activityId;
        public String podName;

        public K8SLog(String activityId, String podName) {
            this.activityId = activityId;
            this.podName = podName;
        }
    }

    public static class RecipeState {
        String recipeType;
        String recipeName;
        String uiFilterExpr;
        String state;
        int notStarted = 0;
        int failed = 0;
        int done = 0;
        int running = 0;
        int total = 0;
        int skipped = 0;
        int aborted = 0;
        int warning = 0;
    }

    public static class StepJobStatus {
        public String projectKey;
        public String scenarioId;
        public String stepId;
        public String scenarioRunId;
        public String runId;

        public static StepJobStatus create(FlowExecutionService2.JobSummary js) {
            if (js.scenarioId == null || js.scenarioId.length() == 0) {
                return null;
            }
            StepJobStatus sjs = new StepJobStatus();
            sjs.projectKey = js.scenarioProjectKey;
            sjs.scenarioId = js.scenarioId;
            sjs.stepId = js.stepId;
            sjs.scenarioRunId = js.scenarioRunId;
            sjs.runId = js.stepRunId;
            return sjs;
        }
    }
}

