/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.dataflow.JobActivity;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AccessibilityGraph {
    private final List<Node> nodes = Lists.newArrayList();
    private final List<Edge> edges = Lists.newArrayList();

    AccessibilityGraph(Collection<JobActivity> activities) {
        HashMap nodeNoById = Maps.newHashMap();
        for (JobActivity activity : activities) {
            Node n = new Node(activity);
            nodeNoById.put(n.id(), this.nodes.size());
            this.nodes.add(n);
        }
        for (Node n : this.nodes) {
            for (JobActivity activity : n.activity().dependencies) {
                String nId = new Node(activity).id();
                if (!nodeNoById.containsKey(nId)) continue;
                this.edges.add(new Edge(this.nodes.get((Integer)nodeNoById.get(nId)), n));
            }
        }
    }

    List<JobActivity> getRoots() {
        ArrayList ret = Lists.newArrayList();
        for (Node n : this.getRootNodes()) {
            ret.add(n.activity());
        }
        return ret;
    }

    private Set<Node> getRootNodes() {
        HashSet ret = Sets.newHashSet();
        for (Node n : this.nodes) {
            if (!this.getChildren(n).isEmpty()) continue;
            ret.add(n);
        }
        return ret;
    }

    private Set<Node> getParents(Node n) {
        HashSet ret = Sets.newHashSet();
        for (Edge e : this.edges) {
            if (e.child != n) continue;
            ret.add(e.parent);
        }
        return ret;
    }

    private Set<Node> getChildren(Node n) {
        HashSet ret = Sets.newHashSet();
        for (Edge e : this.edges) {
            if (e.parent != n) continue;
            ret.add(e.child);
        }
        return ret;
    }

    List<JobActivity> orderDepthFirst() {
        ArrayList ret = Lists.newArrayList();
        for (Node n : this.orderNodesDepthFirst()) {
            ret.add(n.activity());
        }
        return ret;
    }

    private List<Node> orderNodesDepthFirst() {
        ArrayList visited = Lists.newArrayList();
        for (Node root : this.getRootNodes()) {
            this.visit(root, visited);
        }
        return visited;
    }

    public void visit(Node n, List<Node> visited) {
        if (visited.contains(n)) {
            return;
        }
        for (Node s : this.getParents(n)) {
            this.visit(s, visited);
        }
        if (visited.contains(n)) {
            throw new IllegalArgumentException("Activity graph contains a directed cycle");
        }
        visited.add(n);
    }

    public class Node {
        private final JobActivity activity;

        public Node(JobActivity activity) {
            this.activity = activity;
        }

        public JobActivity activity() {
            return this.activity;
        }

        public String id() {
            return this.activity.id();
        }
    }

    public class Edge {
        private final Node child;
        private final Node parent;

        Edge(Node parent, Node child) {
            this.parent = parent;
            this.child = child;
        }
    }
}

