/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.pivot.PivotElementsModalitiesSnapshot;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeSchemaComputer;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.VisualSqlRecipePipelineHelper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.PivotRecipeService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.util.AnyLoc;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class PivotRecipePipelineHelper
extends VisualSqlRecipePipelineHelper {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private PivotRecipeService pivotService;
    private PivotRecipePayloadParams params;

    public PivotRecipePipelineHelper(AuthCtx authCtx, SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, JobActivity jobActivity) {
        super(authCtx, recipe, payload, pipelineType, jobActivity);
    }

    @Override
    protected void parseParams() {
        this.params = this.pivotService.loadParams(this.payload, this.recipe);
        this.engineParams = this.params.engineParams;
    }

    @Override
    protected String generateSqlQuery(JobActivity activity, SQLDialect dialect) throws Exception {
        return this.pivotService.generatePivotingSQL(activity, dialect, this.params, true);
    }

    @Override
    protected boolean isValidConfiguration() {
        return super.isValidConfiguration() && !this.isSchemaAlwaysComputed() && this.areModalitiesUpToDate();
    }

    @Override
    VisualSQLRecipePayloadParams getParams() {
        return this.params;
    }

    private boolean areModalitiesUpToDate() {
        String outRef = this.recipe.getSingleOutput((String)"main").ref;
        AnyLoc loc = AnyLoc.resolveSmart(this.recipe.projectKey, outRef);
        try {
            SerializedDataset mandatory = (SerializedDataset)this.datasetsDAO.getMandatory(loc);
            Dataset d = Dataset.fromSerialized(mandatory);
            PivotElementsModalitiesSnapshot modalities = PivotRecipeSchemaComputer.getPivotElementsModalitiesIfUptodate(this.params, d.getSchema());
            return modalities != null;
        }
        catch (IOException e) {
            logger.warnV((Throwable)e, "Unable to get dataset %s to get pivot recipe modalities", new Object[]{loc.getFullName()});
            return false;
        }
    }

    private boolean isSchemaAlwaysComputed() {
        return this.params.schemaComputation == PivotRecipePayloadParams.SchemaComputation.ALWAYS;
    }
}

