/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.sort;

import com.dataiku.dip.datalayer.sort.NumberedRow;
import com.dataiku.dip.datalayer.sort.RowAndFileMark;
import com.dataiku.dip.datalayer.sort.SimpleRowsFileReader;
import com.dataiku.dip.datalayer.sort.SpilledRows;
import com.dataiku.dip.utils.NotImplementedException;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SpilledRowsIterator
implements Iterator<RowAndFileMark> {
    private final int rowCount;
    private final long fileStart;
    private final long firstRowNumber;
    protected final SimpleRowsFileReader fileReader;
    private int rowsRead = 0;
    private NumberedRow currentRow = null;
    private Mark currentRowMark = null;

    public SpilledRowsIterator(SimpleRowsFileReader fileReader, SpilledRows spilledRows) throws IOException {
        this.fileReader = fileReader;
        this.rowCount = spilledRows.rowCount;
        this.fileStart = spilledRows.fileStart;
        this.firstRowNumber = spilledRows.firstRowNumber;
        fileReader.position(this.fileStart);
        this.rowsRead = 0;
        this.currentRow = null;
    }

    public Mark mark() throws IOException {
        return new Mark(this.rowsRead, this.fileReader.position());
    }

    public void reset(Mark mark) throws IOException {
        if (this.rowsRead == mark.rowsRead) {
            return;
        }
        this.fileReader.position(mark.position);
        this.rowsRead = mark.rowsRead;
        this.currentRow = null;
    }

    private void advance() throws IOException {
        this.currentRowMark = this.mark();
        this.currentRow = new NumberedRow(this.fileReader.next(), this.firstRowNumber + (long)this.rowsRead);
        ++this.rowsRead;
    }

    @Override
    public boolean hasNext() {
        return this.rowsRead < this.rowCount;
    }

    @Override
    public RowAndFileMark next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            this.advance();
            return new RowAndFileMark(this.currentRow, this.currentRowMark);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to iterate", e);
        }
    }

    @Override
    public void remove() {
        throw new NotImplementedException();
    }

    public static class Mark {
        private final int rowsRead;
        private final long position;

        public Mark(int rowsRead, long position) {
            this.rowsRead = rowsRead;
            this.position = position;
        }
    }
}

