/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.utils;

import com.dataiku.dip.datalayer.FilteringProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.utils.DKULogger;
import java.util.Random;

public class RandomRatioSamplingProcessorOutput
extends FilteringProcessorOutput {
    private double proba;
    private long received;
    private long emitted;
    private Random rnd = new Random();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.sampling.random");

    public RandomRatioSamplingProcessorOutput(ProcessorOutput downstream, double proba, Long seed) {
        super(downstream);
        this.proba = proba;
        if (seed != null) {
            this.rnd = new Random(seed);
        }
    }

    public void emitRow(Row row) throws Exception {
        ++this.received;
        double v = this.rnd.nextDouble();
        if (v < this.proba) {
            ++this.emitted;
            this.downstream.emitRow(row);
        }
        if (this.received % 100000L == 0L) {
            logger.infoV("Random sampling received=%s emitted=%s", new Object[]{this.received, this.emitted});
        }
    }

    public void lastRowEmitted() throws Exception {
        logger.infoV("Done random sampling received=%s emitted=%s", new Object[]{this.received, this.emitted});
        super.lastRowEmitted();
    }
}

