/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality;

import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

@PolyJSON(value={@Mapping(value=Unknown.class, type="UNKNOWN"), @Mapping(value=Manual.class, type="MANUAL"), @Mapping(value=ScenarioStep.class, type="SCENARIO"), @Mapping(value=RedactedScenarioStep.class, type="REDACTED_SCENARIO"), @Mapping(value=Build.class, type="BUILD"), @Mapping(value=RedactedBuild.class, type="REDACTED_BUILD"), @Mapping(value=External.class, type="EXTERNAL"), @Mapping(value=PublicAPI.class, type="PUBLIC_API"), @Mapping(value=Test.class, type="TEST")}, enumClass=DataQualityRunType.class)
public abstract class DataQualityRunOrigin {
    public DataQualityRunType type = (DataQualityRunType)JSON.getEnumType((Object)this);

    public static DataQualityRunOrigin parse(@Nullable String serialized) {
        if (StringUtils.isBlank((CharSequence)serialized)) {
            return new Unknown();
        }
        return (DataQualityRunOrigin)JSON.parse((String)serialized, DataQualityRunOrigin.class);
    }

    public boolean isMultiPartitionCapable() {
        return this instanceof Build || this instanceof Manual || this instanceof ScenarioStep;
    }

    public boolean sameRunAs(DataQualityRunOrigin o2) {
        if (this instanceof Build && o2 instanceof Build) {
            return ((Build)this).jobId.equals(((Build)o2).jobId);
        }
        if (this instanceof ScenarioStep && o2 instanceof ScenarioStep) {
            return ((ScenarioStep)this).scenarioId.equals(((ScenarioStep)o2).scenarioId) && ((ScenarioStep)this).runId.equals(((ScenarioStep)o2).runId);
        }
        if (this instanceof Manual && o2 instanceof Manual) {
            return ((Manual)this).runId.equals(((Manual)o2).runId);
        }
        return false;
    }

    public static enum DataQualityRunType {
        UNKNOWN,
        MANUAL,
        SCENARIO,
        REDACTED_SCENARIO,
        BUILD,
        REDACTED_BUILD,
        EXTERNAL,
        PUBLIC_API,
        TEST;

    }

    public static class Unknown
    extends DataQualityRunOrigin {
    }

    public static class Build
    extends AbstractBuild {
        public String projectKey;
        public String jobId;

        private Build() {
        }

        public Build(String projectKey, String jobId) {
            this.projectKey = projectKey;
            this.jobId = jobId;
        }
    }

    public static class Manual
    extends DataQualityRunOrigin {
        public String runId = SecretKeyGenerator.generateSmall();
    }

    public static class ScenarioStep
    extends AbstractScenarioStep {
        public String projectKey;
        public String scenarioId;
        public String runId;

        private ScenarioStep() {
        }

        public ScenarioStep(String projectKey, String scenarioId, String runId) {
            this.projectKey = projectKey;
            this.scenarioId = scenarioId;
            this.runId = runId;
        }
    }

    public static class RedactedBuild
    extends AbstractScenarioStep {
    }

    public static abstract class AbstractBuild
    extends DataQualityRunOrigin {
    }

    public static class RedactedScenarioStep
    extends AbstractScenarioStep {
    }

    public static abstract class AbstractScenarioStep
    extends DataQualityRunOrigin {
    }

    public static class PublicAPI
    extends DataQualityRunOrigin {
    }

    public static class External
    extends DataQualityRunOrigin {
    }

    public static class Test
    extends DataQualityRunOrigin {
    }
}

