/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.DatasetSelectionToMemTable;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@UIModel
public class StreamableDatasetSelection
extends DatasetSelection {
    @Nullable
    public boolean useMemTable;

    public static StreamableDatasetSelection fromSamplingParam(SamplingParam sp) {
        StreamableDatasetSelection result = (StreamableDatasetSelection)((Object)JSON.parse((String)JSON.json((Object)sp), StreamableDatasetSelection.class));
        if (sp instanceof DatasetSelection) {
            StreamableDatasetSelection.copyVariablesContext(result.filter, ((DatasetSelection)sp).filter);
        }
        return result;
    }

    private static void copyVariablesContext(FilterDesc result, FilterDesc other) {
        if (result != null && other != null) {
            result.expressionVariablesContext = other.expressionVariablesContext;
            if (result.uiData != null && result.uiData.conditions != null && other.uiData != null && other.uiData.conditions != null) {
                for (int i = 0; i < result.uiData.conditions.size() && i < other.uiData.conditions.size(); ++i) {
                    FilterDesc.FilterUiCondition condition = (FilterDesc.FilterUiCondition)result.uiData.conditions.get(i);
                    FilterDesc.FilterUiCondition otherCondition = (FilterDesc.FilterUiCondition)other.uiData.conditions.get(i);
                    if (condition == null || otherCondition == null) continue;
                    StreamableDatasetSelection.copyVariablesContext(condition.subCondition, otherCondition.subCondition);
                }
            }
        }
    }

    public DatasetSelectionToMemTable asToMemTable() {
        assert (this.useMemTable);
        return (DatasetSelectionToMemTable)((Object)JSON.parse((String)JSON.json((Object)((Object)this)), DatasetSelectionToMemTable.class));
    }

    public static StreamableDatasetSelection full() {
        StreamableDatasetSelection ds = new StreamableDatasetSelection();
        return ds;
    }

    public static StreamableDatasetSelection head100K() {
        StreamableDatasetSelection ds = new StreamableDatasetSelection();
        ds.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.ALL;
        ds.samplingMethod = SamplingParam.SamplingMethod.HEAD_SEQUENTIAL;
        ds.maxRecords = 100000L;
        ds.seed = 1337L;
        return ds;
    }

    public static StreamableDatasetSelection head10K() {
        StreamableDatasetSelection ds = new StreamableDatasetSelection();
        ds.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.ALL;
        ds.samplingMethod = SamplingParam.SamplingMethod.HEAD_SEQUENTIAL;
        ds.maxRecords = 10000L;
        return ds;
    }

    public StreamableDatasetSelection withSelectedPartitionIds(List<String> ids) {
        this.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.SELECTED;
        this.selectedPartitions = ids;
        return this;
    }

    public StreamableDatasetSelection withSelectedPartitions(List<Partition> partitions) {
        this.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.SELECTED;
        this.selectedPartitions = new ArrayList();
        for (Partition p : partitions) {
            this.selectedPartitions.add(p.id());
        }
        return this;
    }

    public StreamableDatasetSelection withAddedSelectedPartitions(List<Partition> partitions) {
        this.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.SELECTED;
        if (this.selectedPartitions == null) {
            this.selectedPartitions = new ArrayList();
        }
        for (Partition p : partitions) {
            this.selectedPartitions.add(p.id());
        }
        return this;
    }

    public static StreamableDatasetSelection columnOrdered100k(String column, boolean ascending) {
        StreamableDatasetSelection ds = new StreamableDatasetSelection();
        ds.samplingMethod = SamplingParam.SamplingMethod.COLUMN_ORDERED;
        ds.column = column;
        ds.ascending = ascending;
        ds.maxRecords = 100000L;
        ds.seed = 1337L;
        return ds;
    }
}

