/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.experimentsdb;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.datasets.experimentsdb.ExperimentsDBDatasetHandler;
import com.dataiku.dip.datasets.experimentsdb.ExperimentsDBDatasetParams;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.server.SerializedMemTableSimple;
import com.dataiku.dip.shaker.services.TypeInferrer2;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class ExperimentsDBDatasetTestHandler
implements DatasetTestHandler {
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    protected DatasetsDAO datasetDAO;
    @Autowired
    protected TransactionService transactionService;
    private ExperimentsDBDatasetHandler datasetHandler;
    private final TypeInferrer2 inferer = new TypeInferrer2();

    public ExperimentsDBDatasetTestHandler(ExperimentsDBDatasetHandler datasetHandler) {
        this.datasetHandler = datasetHandler;
    }

    @Override
    public void close() throws IOException {
        if (this.datasetHandler != null) {
            try {
                this.datasetHandler.close();
            }
            finally {
                this.datasetHandler = null;
            }
        }
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) throws Exception {
        return new InfoMessage.InfoMessages();
    }

    @Override
    public DatasetTestHandler.SchemaConsistencyResult testSchemaConsistency() throws Exception {
        Dataset dataset = this.datasetHandler.getDataset();
        ExperimentsDBDatasetParams params = dataset.getParamsAs(ExperimentsDBDatasetParams.class);
        DatasetTestHandler.SchemaConsistencyResult scr = new DatasetTestHandler.SchemaConsistencyResult();
        scr.empty = false;
        scr.result = new SchemaDetection.SchemaDetectionResult();
        scr.result.detectedSchema = ExperimentsDBDatasetHandler.getSchema(params.scope, params.format);
        scr.result.type = SchemaDetection.SchemaHandlingType.FIXED_TYPE_AND_SCHEMA;
        scr.result.usedMode = SchemaDetection.Mode.DETECTION_PREFER_DATA;
        return scr;
    }

    public ExperimentsDBDatasetTestResult test(AuthCtx liu) throws IOException, DKUSecurityException {
        ExperimentsDBDatasetTestResult ret;
        block9: {
            Dataset dataset = this.datasetHandler.getDataset();
            try (Transaction t = this.transactionService.beginRead();){
                this.permissionsService.checkProjectPrivileges(liu, dataset.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
            ret = new ExperimentsDBDatasetTestResult();
            ret.suggestedName = DatasetInspector.slufigyAndUnicize(dataset.getProjectKey(), this.datasetHandler.suggestName(), this.datasetDAO, this.transactionService);
            ret.querySchema = dataset.getSchema();
            PublicAPIControllerBase.logger.info((Object)"Gathering table preview");
            try {
                RowsInputSplit split = this.datasetHandler.getSampleSplit();
                MemTable mt = new MemTable();
                split.push((ProcessorOutput)new MemTableAppendingOutput(mt), mt, mt, new ExtractionLimit(10L), null, null);
                this.inferer.processFullAuto(null, mt);
                SerializedMemTableSimple smt = new SerializedMemTableSimple();
                smt.fromMemTable(mt, 0, mt.nrows());
                ret.preview = smt;
            }
            catch (Exception e) {
                PublicAPIControllerBase.logger.error((Object)"Failed to get preview", (Throwable)e);
                ret.previewErrorMsg = e.getMessage();
                if (ret.previewErrorMsg != null) break block9;
                ret.previewErrorMsg = e.toString();
            }
        }
        return ret;
    }

    public static class ExperimentsDBDatasetTestResult {
        public SerializedMemTableSimple preview;
        public String previewErrorMsg;
        public String suggestedName;
        public Schema querySchema;
    }
}

