/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.DatabricksConnection;
import com.dataiku.dip.connections.DatabricksVolumeConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.MetastoreAwareDatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BlobLikeDatasetHandler;
import com.dataiku.dip.datasets.fs.BlobLikeResplitOutput;
import com.dataiku.dip.datasets.fs.BlobLikeSingleFileOutputWriter;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.DatabricksVolumeDatasetTestHandler;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.formats.delta.DeltaFormat;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.formats.CompressibleFormatParams;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatMeta;
import com.dataiku.dip.input.formats.hive.rcfile.RCFileFormatMeta;
import com.dataiku.dip.input.formats.hive.sequencefile.SequenceFileFormatMeta;
import com.dataiku.dip.input.formats.parquet.ParquetFormatMeta;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.FSDatasetBrowseService;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DatabricksVolumeDatasetHandler
extends BlobLikeDatasetHandler<BuiltinFSDatasets.DatabricksVolumeDatasetConfig>
implements FSDatasetBrowseService.BrowsableHandler,
MetastoreAwareDatasetHandler {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.databricksVolume");

    public DatabricksVolumeDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        super(authCtx, dataset);
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return BuiltinFSDatasets.DATABRICKS_VOLUME_META;
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException, DKUSecurityException, CodedException {
        return new DatabricksVolumeDatasetTestHandler(this.authCtx, this, (DatasetHandler)this, this.dataset);
    }

    @Override
    public String getDSSConnectionForHive() {
        throw new IllegalArgumentException("unreachable");
    }

    @Override
    public SQLUtils.SQLTable getResolvedHiveTableRef(boolean databaseIsMandatory) {
        String database = null;
        database = !StringUtils.isBlank((String)((BuiltinFSDatasets.DatabricksVolumeDatasetConfig)this.resolvedConfig).metastoreDatabaseName) ? ((BuiltinFSDatasets.DatabricksVolumeDatasetConfig)this.resolvedConfig).metastoreDatabaseName : this.getConnection().params.defaultMetastoreDatabase;
        if (databaseIsMandatory && StringUtils.isBlank((String)database)) {
            throw ErrorContext.iae((String)("Could not determine metastore database for dataset " + this.dataset.getFullName() + ", please check config"));
        }
        String table = null;
        table = !StringUtils.isBlank((String)((BuiltinFSDatasets.DatabricksVolumeDatasetConfig)this.resolvedConfig).metastoreTableName) ? ((BuiltinFSDatasets.DatabricksVolumeDatasetConfig)this.resolvedConfig).metastoreTableName : this.dataset.getName();
        String schema = database == null ? null : database.toLowerCase(Locale.ENGLISH);
        String table1 = table == null ? null : table.toLowerCase(Locale.ENGLISH);
        return new SQLUtils.SQLTable(null, schema, table1, true);
    }

    @Override
    public SQLUtils.SQLTable getUnresolvedHiveTableRef() {
        String database = null;
        BuiltinFSDatasets.DatabricksVolumeDatasetConfig rawConfig = (BuiltinFSDatasets.DatabricksVolumeDatasetConfig)this.config;
        database = !StringUtils.isBlank((String)rawConfig.metastoreDatabaseName) ? rawConfig.metastoreDatabaseName : this.getConnection().params.defaultMetastoreDatabase;
        String table = null;
        table = !StringUtils.isBlank((String)rawConfig.metastoreTableName) ? rawConfig.metastoreTableName : this.dataset.getName();
        return new SQLUtils.SQLTable(null, database, table, true);
    }

    @Override
    public AbstractFSDatasetHandler.FSProviderAndPath getProviderInternal(@Nullable String path) throws IOException, CodedException, DKUSecurityException {
        String providerPath = path == null ? ((BuiltinFSDatasets.DatabricksVolumeDatasetConfig)this.resolvedConfig).path : path;
        FSProvider provider = FSProviderFactory.getProvider("DatabricksVolume", this.authCtx, this.dataset.getProjectKey(), this.resolvedConfig, providerPath, this.getConnection());
        return new AbstractFSDatasetHandler.FSProviderAndPath(provider, providerPath);
    }

    @Override
    public String getInformationalRootPath() throws IOException, DKUSecurityException, CodedException {
        String providerRoot = "dbfs:/Volumes/" + this.getConnection().params.catalog + "/" + this.getConnection().params.schema + "/" + this.getVolume() + PathUtils.makeLeadingNoTrailing((String)this.getTypedProvider().getRootWithinBucket());
        if (this.isSingleFile()) {
            String singleFile = this.getSingleFile();
            providerRoot = providerRoot.endsWith("/") ? providerRoot.substring(0, providerRoot.length() - 1) : providerRoot;
            singleFile = singleFile.startsWith("/") ? singleFile.substring(1) : singleFile;
            return providerRoot + "/" + singleFile;
        }
        return providerRoot;
    }

    @Override
    protected List<AbstractSQLConnection.CustomDatabaseProperty> getHDFSExtraConf() throws IOException, DKUSecurityException {
        ArrayList ret = Lists.newArrayList();
        return ret;
    }

    @Override
    public DatabricksVolumeConnection getConnection() {
        try {
            DSSConnection connection = ConnectionsDAO.get().getMandatoryConnection(this.authCtx, ((BuiltinFSDatasets.DatabricksVolumeDatasetConfig)this.resolvedConfig).connection);
            if (connection instanceof DatabricksConnection) {
                return ((DatabricksConnection)connection).asDatabricksVolumeConnection();
            }
            if (connection instanceof DatabricksVolumeConnection) {
                return (DatabricksVolumeConnection)connection;
            }
            throw new IOException("Unexpected connection type " + connection.type);
        }
        catch (DKUSecurityException | IOException e) {
            throw new RuntimeException("Failed to get connection", e);
        }
    }

    public String getVolume() {
        if (StringUtils.isNotBlank((String)this.getConnection().params.chvolume)) {
            return this.getConnection().params.chvolume;
        }
        return ((BuiltinFSDatasets.DatabricksVolumeDatasetConfig)this.resolvedConfig).volume;
    }

    @Override
    public String getFullyQualifiedRootPath() throws IOException, DKUSecurityException, CodedException, InterruptedException {
        String providerRoot = "dbfs:/Volumes/" + this.getConnection().params.catalog + "/" + this.getConnection().params.schema + "/" + this.getVolume() + PathUtils.makeLeadingNoTrailing((String)this.getTypedProvider().getRootWithinBucket());
        if (this.isSingleFile()) {
            return providerRoot + "/" + this.getSingleFile();
        }
        return providerRoot;
    }

    @Override
    public DSSConnection getHDFSAbleConnection() {
        return this.getConnection();
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, final WarningsContext warningsContext) throws Exception {
        String compress;
        ConnectionUtils.checkConnectionWritable(this.authCtx, ((BuiltinFSDatasets.DatabricksVolumeDatasetConfig)this.resolvedConfig).connection);
        if (this.dataset.getFormatType().equals(DeltaFormat.META.getType())) {
            throw new UnsupportedOperationException("Delta format can only be written with the Spark engine");
        }
        if (this.dataset.getFormatType().equals(ParquetFormatMeta.META.getType()) || this.dataset.getFormatType().equals(SequenceFileFormatMeta.META.getType()) || this.dataset.getFormatType().equals(RCFileFormatMeta.META.getType()) || this.dataset.getFormatType().equals(ORCFileFormatMeta.META.getType())) {
            throw new UnsupportedOperationException(this.dataset.getFormatType() + " format can only be written to databricks volumes");
        }
        String string = compress = this.dataset.getFormatParams() instanceof CompressibleFormatParams ? ((CompressibleFormatParams)this.dataset.getFormatParams()).compress : "";
        if (this.isSingleFile()) {
            final String path = this.getSingleFile();
            return new Output(){

                public OutputWriter getWriter(Output.WriteMode mode) throws IOException, CodedException, DKUSecurityException {
                    return new BlobLikeSingleFileOutputWriter(DatabricksVolumeDatasetHandler.this.authCtx, DatabricksVolumeDatasetHandler.this.dataset.getProjectKey(), DatabricksVolumeDatasetHandler.this.getTypedProvider(), path, DatabricksVolumeDatasetHandler.this.dataset.getFormatType(), DatabricksVolumeDatasetHandler.this.dataset.getFormatParams(), DatabricksVolumeDatasetHandler.this.dataset.getSchema(), warningsContext, mode, compress);
                }
            };
        }
        String prefix = targetPartition == null ? "/" : FilePartitioner.computePartitionRelPathAsFolder(targetPartition, this.dataset.getPartitioningSchema());
        BlobLikeResplitOutput output = new BlobLikeResplitOutput(this.authCtx, this.dataset.getProjectKey(), this.getTypedProvider(), prefix, targetSplit, resplitFactor, this.dataset.getFormatType(), this.dataset.getFormatParams(), this.dataset.getSchema(), warningsContext, compress, this.dataset.getModel().readWriteOptions);
        output.setMaxSplitChunkSize(4000000000L);
        return output;
    }
}

