/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.HiveableDatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractHDFSableDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.datasets.fs.HDFSDatasetTestHandler;
import com.dataiku.dip.datasets.fs.HDFSProvider;
import com.dataiku.dip.datasets.fs.hdfs.HDFSPermissionsHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.delta.DeltaFormat;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.fs.FilesSelectionRules;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatMeta;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileOutput;
import com.dataiku.dip.input.formats.hive.rcfile.RCFileFormatConfig;
import com.dataiku.dip.input.formats.hive.rcfile.RCFileFormatMeta;
import com.dataiku.dip.input.formats.hive.rcfile.RCFileOutput;
import com.dataiku.dip.input.formats.hive.sequencefile.SequenceFileFormatConfig;
import com.dataiku.dip.input.formats.hive.sequencefile.SequenceFileFormatMeta;
import com.dataiku.dip.input.formats.hive.sequencefile.SequenceFileOutput;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatMeta;
import com.dataiku.dip.input.formats.parquet.ParquetOutput;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.output.HDFSOutput;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.output.OutputStreamOutputWriter;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.FilePartition;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.FSDatasetBrowseService;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.VariablesUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.springframework.beans.factory.annotation.Autowired;

public class HDFSDatasetHandler
extends AbstractHDFSableDatasetHandler
implements FSDatasetBrowseService.BrowsableHandler,
HiveableDatasetHandler {
    private final Config rawConfig;
    private final Config resolvedConfig;
    private final HDFSConnection conn;
    private final String connectionRootWithinURIAuthority;
    private final String configuredDatasetRootWithinAuthority;
    private final String configuredDatasetInConnectionRoot;
    private final String effectiveDatasetRootWithinAuthority;
    private final String effectiveDatasetPathWithinConnectionRoot;
    private final String connectionRootSchemeAndAuthority;
    private final List<SimpleKeyValue> fsExtraConf;
    private final boolean extraConfDefinesDefaultFS;
    @Autowired
    private IImpersonationResolverService impersonationService;
    @Autowired
    private PasswordEncryptionService cryptoService;
    private volatile boolean locationInfoPrinted;
    private FileSystem iFS = null;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.hdfs");

    public HDFSDatasetHandler(AuthCtx authCtx, Dataset dataset, boolean onlyForHiveMetadata) {
        super(authCtx, dataset);
        SpringUtils.getInstance().autowire((Object)this);
        this.rawConfig = (Config)Preconditions.checkNotNull((Object)dataset.getParamsAs(Config.class), (Object)"Dataset has no params");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.rawConfig.connection), (Object)("Dataset " + dataset.getFullName() + " has no connection"));
        this.resolvedConfig = (Config)JSON.deepCopy((Object)this.rawConfig);
        this.resolvedConfig.path = VariablesUtils.expand(dataset.getProjectKey(), this.resolvedConfig.path);
        this.resolvedConfig.hiveDatabase = VariablesUtils.expand(dataset.getProjectKey(), this.resolvedConfig.hiveDatabase);
        this.resolvedConfig.hiveTableName = VariablesUtils.expand(dataset.getProjectKey(), this.resolvedConfig.hiveTableName);
        try {
            this.conn = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, this.resolvedConfig.connection, HDFSConnection.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to get HDFS connection:", e);
        }
        HDFSConnection.RootAndExtraConf rec = null;
        if (!onlyForHiveMetadata) {
            try {
                rec = this.conn.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, dataset.getProjectKey()), HDFSConnection.RootAndExtraConf.class);
            }
            catch (DKUSecurityException | IOException e1) {
                throw new IllegalArgumentException("Failed to get HDFS credentials", e1);
            }
            this.fsExtraConf = Lists.newArrayList();
            try {
                HadoopSettings hadoopSettings = new ClusterSelector().selectForProject(authCtx, dataset.getProjectKey()).getHadoopSettings();
                this.fsExtraConf.addAll(hadoopSettings.extraConf.getAsSimpleKeyValueList());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to get Hadoop settings:", e);
            }
            this.fsExtraConf.addAll(rec.getExtraConfAsSimpleKeyValue());
            this.extraConfDefinesDefaultFS = this.extraConfHasDefaultFS(this.fsExtraConf);
        } else {
            rec = this.conn.getUnresolvedRootAndExtraConf(authCtx, dataset.getProjectKey());
            this.fsExtraConf = null;
            this.extraConfDefinesDefaultFS = false;
        }
        try {
            URI connectionRootURI = new URI(StringUtils.defaultIfEmpty((String)rec.root, (String)""));
            this.connectionRootSchemeAndAuthority = connectionRootURI.getScheme() != null && connectionRootURI.getAuthority() != null ? connectionRootURI.getScheme() + "://" + connectionRootURI.getAuthority() : null;
            this.connectionRootWithinURIAuthority = connectionRootURI.getPath();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot resolve connection root URI", e);
        }
        this.configuredDatasetInConnectionRoot = PathUtils.slashes((String)this.resolvedConfig.path, (Boolean)true, (Boolean)false, (boolean)true, (String)"/");
        this.effectiveDatasetPathWithinConnectionRoot = dataset.isManaged() && this.conn.getParams().aclSynchronizationMode == HDFSConnection.ACLSynchronizationMode.SUBDIRECTORY && this.impersonationService.isEnabled() ? PathUtils.slashes((String)(this.configuredDatasetInConnectionRoot + "/data/"), (Boolean)true, (Boolean)false, (boolean)true, (String)"/") : this.configuredDatasetInConnectionRoot;
        this.configuredDatasetRootWithinAuthority = PathUtils.concatLNT((String[])new String[]{this.connectionRootWithinURIAuthority, this.configuredDatasetInConnectionRoot});
        this.effectiveDatasetRootWithinAuthority = PathUtils.concatLNT((String[])new String[]{this.connectionRootWithinURIAuthority, this.effectiveDatasetPathWithinConnectionRoot});
    }

    @Override
    protected void printLocationInfo() {
        if (!this.locationInfoPrinted) {
            logger.debugV("HDFS dataset handler dataset=%s connection=%s cpr=%s resolvedPath=%s connRootSA=%sconnRootWithinSA=%s configuredRootPathWithinSA=%s effectiveRootPathWithinSA=%s", new Object[]{this.dataset.getFullName(), this.resolvedConfig.connection, this.conn.getUnresolvedRootForDisplayOnly(), this.resolvedConfig.path, this.connectionRootSchemeAndAuthority, this.connectionRootWithinURIAuthority, this.configuredDatasetRootWithinAuthority, this.effectiveDatasetRootWithinAuthority});
            this.locationInfoPrinted = true;
        }
    }

    private boolean extraConfHasDefaultFS(List<SimpleKeyValue> extraConf) {
        for (SimpleKeyValue p : extraConf) {
            if (!"fs.defaultFS".equals(p.key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AbstractFSDatasetHandler.FSProviderAndPath getProviderInternal(String path) throws IOException, DKUSecurityException, CodedException {
        this.printLocationInfo();
        String providerPath = path == null ? this.effectiveDatasetPathWithinConnectionRoot : path;
        FSProvider provider = FSProviderFactory.getProvider("HDFS", this.authCtx, this.dataset.getProjectKey(), this.resolvedConfig, providerPath, this.getConnection());
        return new AbstractFSDatasetHandler.FSProviderAndPath(provider, providerPath);
    }

    public HDFSProvider getTypedProvider() throws IOException, DKUSecurityException, CodedException {
        return (HDFSProvider)this.getProvider();
    }

    @Override
    public String getDSSConnectionForHive() {
        return this.resolvedConfig.connection;
    }

    @Override
    public SQLUtils.SQLTable getResolvedHiveTableRef(boolean databaseIsMandatory) {
        String database = null;
        database = !StringUtils.isBlank((String)this.resolvedConfig.hiveDatabase) ? this.resolvedConfig.hiveDatabase : this.getConnection().params.defaultDatabase;
        if (databaseIsMandatory && StringUtils.isBlank((String)database)) {
            throw ErrorContext.iae((String)("Could not determine Hive database for dataset " + this.dataset.getFullName() + ", please check config"));
        }
        String table = null;
        table = !StringUtils.isBlank((String)this.resolvedConfig.hiveTableName) ? this.resolvedConfig.hiveTableName : this.dataset.getName();
        String schema = database == null ? null : database.toLowerCase(Locale.ENGLISH);
        String table1 = table == null ? null : table.toLowerCase(Locale.ENGLISH);
        return new SQLUtils.SQLTable(null, schema, table1, true);
    }

    @Override
    public SQLUtils.SQLTable getUnresolvedHiveTableRef() {
        String database = null;
        database = !StringUtils.isBlank((String)this.rawConfig.hiveDatabase) ? this.rawConfig.hiveDatabase : this.getConnection().params.defaultDatabase;
        String table = null;
        table = !StringUtils.isBlank((String)this.rawConfig.hiveTableName) ? this.rawConfig.hiveTableName : this.dataset.getName();
        return new SQLUtils.SQLTable(null, database, table, true);
    }

    public UserGroupInformation makeUGI() throws DKUSecurityException, IOException {
        UserGroupInformation ret = null;
        if (this.impersonationService.isEnabled() && this.authCtx.getAuthSource() != AuthCtx.AuthSource.NONE) {
            String hadoopUserToImpersonate = this.impersonationService.getTargetUser((String)this.dataset.getProjectKey(), (AuthCtx)this.authCtx).hadoopUser;
            ret = UserGroupInformation.createProxyUser((String)hadoopUserToImpersonate, (UserGroupInformation)UserGroupInformation.getLoginUser());
        } else {
            ret = UserGroupInformation.getCurrentUser();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Built impersonated Hadoop UGI for " + this.dataset.getFullName() + ": " + String.valueOf(ret)));
        }
        return ret;
    }

    public HDFSConnection getConnection() {
        return this.conn;
    }

    @Override
    public DSSConnection getHDFSAbleConnection() {
        return this.getConnection();
    }

    public String getConfiguredDatasetRootPathWithinAuthority() {
        return this.configuredDatasetRootWithinAuthority;
    }

    public String getConnectionRootPathWithinAuthority() {
        return PathUtils.slashes((String)this.connectionRootWithinURIAuthority, (Boolean)true, (Boolean)false, (boolean)true, (String)"/");
    }

    public boolean overridePreCreateManagedDatasetFolderBeforeMetastoreSyncForRecipes() {
        return this.conn.params.overridePreCreateManagedDatasetFolderBeforeMetastoreSyncForRecipes;
    }

    @Override
    protected List<FSPath> enumerateFilesystem(String prefix, FSEnumerationSettings enumerationSettings) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        this.printLocationInfo();
        logger.info((Object)("Enumerating Filesystem dataset prefix=" + prefix));
        if (this.isSingleFile()) {
            FSPathOrDirectory file = this.getProvider().stat(this.getSingleFile());
            return file == null ? null : Lists.newArrayList((Object[])new FSPath[]{file});
        }
        FSEnumerationResult enumerationResult = this.getProvider().enumerateRecursive(prefix, enumerationSettings);
        if (!enumerationResult.isSuccessful()) {
            throw new DataStoreIOException("Failed to list files", enumerationResult.getError());
        }
        if (!enumerationResult.enumerationPrefixExists()) {
            if (StringUtils.isBlank((String)prefix)) {
                throw new DataStoreIOException("Root path of the dataset does not exist").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_ROOT_PATH_DOES_NOT_EXIST);
            }
            throw new DataStoreIOException("Path does not exist in the dataset: '" + prefix + "'").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_PATH_DOES_NOT_EXIST);
        }
        ArrayList paths = Lists.newArrayList((Iterable)enumerationResult.getPaths());
        if (enumerationSettings.forReadinessComputation && paths.size() == 0 && DKUApp.getParams().getBoolParam("dku.datasets.hdfs.considerFolderExistenceAsImplicitSuccessForReadiness", false)) {
            logger.debug((Object)"Readiness computation, folder exists but no path found. Patching HDFS enumeration to add fake success marker");
            paths.add(new FSPath("/_fake_success"));
        }
        return paths;
    }

    @Override
    public FSEnumerationSettings getEnumerationSettings() {
        FSEnumerationSettings enumerationSettings = new FSEnumerationSettings();
        enumerationSettings.selectionRules = (FilesSelectionRules)JSON.deepCopy((Object)this.resolvedConfig.filesSelectionRules);
        return enumerationSettings;
    }

    @Override
    public FSPath getFirstNonEmptyPath() throws IOException, DKUSecurityException, CodedException {
        this.printLocationInfo();
        logger.info((Object)"Finding first non empty path in dataset");
        if (this.isSingleFile()) {
            FSPathOrDirectory status = this.getProvider().stat("/" + this.getSingleFile());
            return status != null && status.getSize() > 0L ? status : null;
        }
        FSEnumerationSettings enumerationSettings = this.getEnumerationSettings();
        enumerationSettings.firstNonEmpty = true;
        FSEnumerationResult enumerationResult = this.getProvider().enumerateRecursive("/", enumerationSettings);
        if (!enumerationResult.isSuccessful() || !enumerationResult.enumerationPrefixExists()) {
            return null;
        }
        Iterator paths = enumerationResult.getPaths().iterator();
        return paths.hasNext() ? (FSPath)paths.next() : null;
    }

    @Override
    public void createManaged() throws IOException, InterruptedException, DKUSecurityException, CodedException {
        this.printLocationInfo();
        new HDFSPermissionsHandler(this).setGatewayACLCreate(this.authCtx);
        if (this.isSingleFile()) {
            throw new IOException("Could not create root folder on HDFS : " + this.effectiveDatasetRootWithinAuthority);
        }
        this.getTypedProvider().mkdirs("/");
        this.invalidateRootEnumerationCache();
    }

    @Override
    public EnrichedInputStream getStream(FSPath path, FilePartition partition) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        this.printLocationInfo();
        EnrichedInputStream ret = this.isSingleFile() ? this.getProvider().read(this.getSingleFile()) : this.getProvider().read(path.path());
        if (ret != null) {
            ret.setPartition((Partition)partition);
        }
        return ret;
    }

    @Override
    public String getInformationalRootPath() {
        return this.effectiveDatasetRootWithinAuthority;
    }

    @Override
    public String getEffectiveDatasetRootWithinAuthority() {
        return this.effectiveDatasetRootWithinAuthority;
    }

    public String getConnectionRootSchemeAndAuthority() {
        return this.connectionRootSchemeAndAuthority;
    }

    @Override
    public List<SimpleKeyValue> getFSExtraConf() {
        return this.fsExtraConf;
    }

    public Configuration setupHadoopConf(boolean keepDefaultFS) {
        Configuration conf = new Configuration();
        this.addExtraConf(conf, keepDefaultFS);
        return conf;
    }

    public JobConf setupHadoopJobConf(boolean keepDefaultFS) {
        JobConf conf = new JobConf();
        this.addExtraConf((Configuration)conf, keepDefaultFS);
        return conf;
    }

    @Override
    public void addExtraConf(Configuration conf, boolean keepDefaultFS) {
        if (StringUtils.isNotBlank((String)this.connectionRootSchemeAndAuthority) && !"/".equals(this.connectionRootSchemeAndAuthority)) {
            for (SimpleKeyValue extra : this.fsExtraConf) {
                conf.set(extra.key, extra.value);
            }
            if (!keepDefaultFS) {
                conf.set("fs.defaultFS", this.connectionRootSchemeAndAuthority);
            }
        } else if (this.extraConfDefinesDefaultFS) {
            for (SimpleKeyValue extra : this.fsExtraConf) {
                conf.set(extra.key, extra.value);
            }
        }
    }

    public String getFullyQualifiedHDFSPath(String path) throws IOException, InterruptedException, DKUSecurityException {
        this.printLocationInfo();
        FileSystem fs = this.getImpersonatedFS();
        Path p = new Path(path);
        assert (p.isAbsoluteAndSchemeAuthorityNull());
        return new Path(fs.getUri().resolve(p.toUri())).toString();
    }

    @Override
    public String getFullyQualifiedPartitionPath(Partition partition) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        return this.getFullyQualifiedHDFSPath(this.getPartitionPath(partition));
    }

    @Override
    public String getFullyQualifiedRootPath() throws IOException, InterruptedException, DKUSecurityException {
        this.printLocationInfo();
        return this.getFullyQualifiedHDFSPath(this.effectiveDatasetRootWithinAuthority);
    }

    public boolean rootExists() throws IOException, InterruptedException, DKUSecurityException, CodedException {
        return this.getProvider().stat("/") != null;
    }

    public FileSystem getImpersonatedFS() throws IOException, InterruptedException {
        this.printLocationInfo();
        if (this.iFS == null) {
            try {
                this.iFS = (FileSystem)this.makeUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                    @Override
                    public FileSystem run() throws IOException {
                        return HadoopLoader.getFS(HDFSDatasetHandler.this.connectionRootSchemeAndAuthority, HDFSDatasetHandler.this.fsExtraConf);
                    }
                });
            }
            catch (DKUSecurityException e) {
                throw new IOException("Could not get impersonated FS", e);
            }
        }
        return this.iFS;
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        this.printLocationInfo();
        logger.info((Object)"Clear partitions");
        ConnectionUtils.checkConnectionWritable(this.authCtx, this.resolvedConfig.connection);
        HDFSProvider provider = this.getTypedProvider();
        for (Partition p : partitions) {
            new HDFSPermissionsHandler(this).setDataUsabilityAndDeletabilityACL(this.authCtx, p);
        }
        PartitioningScheme scheme = this.dataset.getPartitioningSchema();
        if (scheme != null && (!scheme.isPartitioned() || FilePartitioner.isSchemeRepresentableAsFolder(scheme))) {
            for (Partition p : partitions) {
                logger.info((Object)("Clearing partition as folder : dataset=" + this.dataset.getFullName() + " partition=" + p.id()));
                String partitionPath = FilePartitioner.computePartitionRelPathAsFolder(p, this.dataset.getPartitioningSchema());
                logger.infoV("datasetRootPathWithinAuthority=%s partitionPath=%s", new Object[]{this.effectiveDatasetRootWithinAuthority, partitionPath});
                this.clearPartitionPath(provider, partitionPath);
                logger.info((Object)("Cleared partition '" + p.id() + "': path= " + partitionPath));
            }
        } else {
            for (Partition p : partitions) {
                logger.info((Object)("Clearing partition as set of paths : dataset=" + this.dataset.getFullName() + " partition=" + p.id()));
                List<FSPath> paths = this.enumeratePartition(p, this.getEnumerationSettings());
                this.clearPartitionPaths(provider, paths);
                logger.info((Object)("Cleared partition '" + p.id() + "'"));
            }
        }
        this.invalidateRootEnumerationCache();
    }

    private void clearPartitionPath(HDFSProvider provider, String partitionPath) throws IOException, DKUSecurityException {
        this.printLocationInfo();
        this.checkClearIsNotDangerous();
        if (this.isManaged()) {
            if (provider.stat(partitionPath) != null) {
                provider.deleteRecursive(partitionPath);
            }
        } else {
            provider.makeEmpty(partitionPath);
        }
    }

    private void clearPartitionPaths(HDFSProvider provider, List<FSPath> paths) throws IOException, DKUSecurityException {
        this.printLocationInfo();
        this.checkClearIsNotDangerous();
        if (paths != null) {
            if (this.isManaged()) {
                for (FSPath path : paths) {
                    provider.deleteRecursive(path.path());
                }
            } else if (!paths.isEmpty()) {
                provider.makeEmpty(paths.get(0).path());
            }
        }
    }

    @Override
    public void clearAllData() throws Exception {
        this.printLocationInfo();
        HDFSProvider provider = this.getTypedProvider();
        new HDFSPermissionsHandler(this).setDataUsabilityAndDeletabilityACL(this.authCtx);
        ConnectionUtils.checkConnectionWritable(this.authCtx, this.resolvedConfig.connection);
        this.checkClearIsNotDangerous();
        if (this.isManaged()) {
            if (provider.stat("/") != null) {
                this.getProvider().deleteRecursive("/");
            }
        } else if (this.isSingleFile()) {
            provider.makeEmpty(this.getSingleFile());
        } else {
            provider.makeEmpty("/");
        }
        this.invalidateRootEnumerationCache();
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return BuiltinFSDatasets.HDFS_META;
    }

    @Override
    public void checkConfiguration() throws IllegalArgumentException, IOException {
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException {
        this.printLocationInfo();
        return new HDFSDatasetTestHandler(this.authCtx, this, (DatasetHandler)this, this.dataset);
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        this.printLocationInfo();
        ConnectionUtils.checkConnectionWritable(this.authCtx, this.resolvedConfig.connection);
        if (this.dataset.getFormatType().equals(DeltaFormat.META.getType())) {
            throw new UnsupportedOperationException("Delta format can only be written with the Spark engine");
        }
        if (this.dataset.getFormatType().equals(ParquetFormatMeta.META.getType())) {
            return new ParquetOutput(this.getTypedProvider(), this.getDataset(), targetPartition, targetSplit, warningsContext, this.dataset.getFormatParamsAs(ParquetFormatConfig.class));
        }
        if (this.dataset.getFormatType().equals(SequenceFileFormatMeta.META.getType())) {
            return new SequenceFileOutput(this.getTypedProvider(), this.getDataset(), targetPartition, targetSplit, this.dataset.getFormatParamsAs(SequenceFileFormatConfig.class), warningsContext);
        }
        if (this.dataset.getFormatType().equals(RCFileFormatMeta.META.getType())) {
            return new RCFileOutput(this.getTypedProvider(), this.getDataset(), targetPartition, targetSplit, this.dataset.getFormatParamsAs(RCFileFormatConfig.class), warningsContext);
        }
        if (this.dataset.getFormatType().equals(ORCFileFormatMeta.META.getType())) {
            return new ORCFileOutput(this.getTypedProvider(), this.getDataset(), targetPartition, targetSplit, this.dataset.getFormatParamsAs(ORCFileFormatConfig.class), warningsContext);
        }
        if (!this.isSingleFile()) {
            return new HDFSOutput(this.authCtx, this.dataset.getProjectKey(), this.getTypedProvider(), "/", targetPartition, this.dataset.getPartitioningSchema(), targetSplit, resplitFactor, this.dataset.getFormatType(), this.dataset.getFormatParams(), this.dataset.getSchema(), warningsContext, this.dataset.getModel().readWriteOptions);
        }
        final OutputFormatter formatter = FormatFactory.buildFormatter(this.authCtx, this.dataset.getProjectKey(), this.dataset.getFormatType(), this.dataset.getFormatParams());
        formatter.setOutputSchema(this.dataset.getSchema());
        if (warningsContext != null) {
            formatter.setWarningsContext(warningsContext);
        }
        return new Output(){

            public OutputWriter getWriter(Output.WriteMode mode) throws IOException, DKUSecurityException, CodedException, InterruptedException {
                return new OutputStreamOutputWriter(HDFSDatasetHandler.this.getTypedProvider().write(HDFSDatasetHandler.this.getSingleFile()), formatter);
            }
        };
    }

    @Override
    public boolean executeFastPostCreateOperations() {
        return false;
    }

    @Override
    public void executePreRenameOperations() {
    }

    @Override
    public FSBrowsePath browse(String prefix) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        this.printLocationInfo();
        if (this.isSingleFile()) {
            return this.getProvider().browse("/" + this.getSingleFile(), FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY);
        }
        return this.getProvider().browse(prefix, FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY);
    }

    public Config getResolvedConfig() {
        return this.resolvedConfig;
    }

    public static class Config
    extends AbstractFSDatasetHandler.AbstractFSConfig {
        private static final long serialVersionUID = -1L;
        public boolean metastoreSynchronizationEnabled = true;
        public String hiveDatabase;
        public String hiveTableName;

        public Config() {
        }

        public Config(String path) {
            this.path = path;
        }
    }
}

