/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FsConnection;
import com.dataiku.dip.dataflow.cde.CDEProcessUtils;
import com.dataiku.dip.datasets.fs.ACLAware;
import com.dataiku.dip.datasets.fs.ChrootUtils;
import com.dataiku.dip.datasets.fs.FSLikeFSProvider;
import com.dataiku.dip.datasets.fs.LocalFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.fs.PathToURIConverter;
import com.dataiku.dip.input.stream.AutoEnrichedInputStream;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.google.gson.reflect.TypeToken;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class RemoteFSProvider
extends FSLikeFSProvider
implements ACLAware,
PathToURIConverter {
    private final FsConnection connection;
    private final String connectionName;
    private final String executionId;
    private final String rootPath;
    private final String root;
    private final TicketBasedIntercomAPIClient client;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fs.remote");

    public RemoteFSProvider(DSSConnection connection, String rootPath) throws IOException, DKUSecurityException {
        assert (connection instanceof FsConnection);
        this.connection = (FsConnection)connection;
        this.connectionName = StringUtils.defaultIfBlank((String)connection.name, (String)"");
        this.executionId = System.getenv("DKU_EXECUTION_ID");
        this.rootPath = this.patchRootPath(rootPath);
        this.root = RemoteFSProvider.buildRoot(this.connection.params.root, rootPath);
        this.client = CDEProcessUtils.newIntercomAPIClient();
    }

    private String patchRootPath(String path) {
        String dipHome = ApplicationConfigurator.getFile((String[])new String[0]).getAbsolutePath();
        String preinstalledPluginsDir = ApplicationConfigurator.getPreInstalledPluginsFolder().getAbsolutePath();
        if (path.startsWith(dipHome)) {
            return "${dip.home}/" + path.substring(dipHome.length());
        }
        if (path.startsWith(preinstalledPluginsDir)) {
            return "${dku.install.dir.plugins}/" + path.substring(preinstalledPluginsDir.length());
        }
        return path;
    }

    private static String buildRoot(String connectionRoot, String path) {
        return ChrootUtils.getChrootedPath(connectionRoot, path, false);
    }

    private String makePath(String path) {
        if (path == null) {
            return "/";
        }
        return PathUtils.makeLeadingNoTrailing((String)PathUtils.canonical((String)path));
    }

    private String makeFile(String prefix) {
        String path = this.makePath(prefix);
        return path.isEmpty() || "/".equals(path) ? this.root : PathUtils.concatLNT((String[])new String[]{this.root, path.substring(1)});
    }

    public void close() throws IOException {
        this.client.close();
    }

    public String convertPathToURI(String path) {
        try {
            return (String)this.client.getForm("/tintercom/fsproviders/convert-to-uri", String.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "path", path});
        }
        catch (IOException e) {
            logger.error((Object)"Failed to get real URI path on remote FS", (Throwable)e);
            throw new RuntimeException("Failed to resolve URI", e);
        }
    }

    @Override
    public String getConnectionRootWithinURIAuthority() {
        return StringUtils.defaultIfEmpty((String)this.connection.params.root, (String)"");
    }

    @Override
    public String getRoot() {
        try {
            return (String)this.client.getForm("/tintercom/fsproviders/root", String.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath});
        }
        catch (IOException e) {
            logger.error((Object)"Failed to get real absolute path on remote FS", (Throwable)e);
            throw new RuntimeException("Failed to resolve connection root", e);
        }
    }

    public FSBrowsePath browse(String path, FSProvider.FSBrowseStrategy strategy) throws IOException, DKUSecurityException, CodedException {
        return (FSBrowsePath)this.client.getForm("/tintercom/fsproviders/browse", FSBrowsePath.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "path", path, "strategy", JSON.json((Object)strategy)});
    }

    public FSEnumerationResult enumerateRecursive(String prefix, FSEnumerationSettings enumerationSettings) throws IOException, CodedException, DKUSecurityException {
        return (FSEnumerationResult)this.client.getForm("/tintercom/fsproviders/enumerate", LocalFSProvider.LocalFSEnumerationResult.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "prefix", prefix, "enumerationSettings", JSON.json((Object)enumerationSettings)});
    }

    public FSPathOrDirectory stat(String path) throws IOException, CodedException, DKUSecurityException {
        return (FSPathOrDirectory)this.client.getForm("/tintercom/fsproviders/stat", FSPathOrDirectory.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "path", path});
    }

    public void setLastModified(String path, long lastModified) throws IOException, CodedException, DKUSecurityException {
        this.client.postFormToJSON("/tintercom/fsproviders/last-modified", Void.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "path", path, "lastModified", lastModified});
    }

    public void deleteRecursive(String path) throws IOException, CodedException, DKUSecurityException {
        this.client.delete("/tintercom/fsproviders/delete", Void.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "path", path});
    }

    public void moveDirectory(String from, String to) throws IOException, CodedException, DKUSecurityException {
        this.client.postFormToJSON("/tintercom/fsproviders/move-directory", Void.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "from", from, "to", to});
    }

    public void moveFile(String from, String to) throws IOException, CodedException, DKUSecurityException {
        this.client.postFormToJSON("/tintercom/fsproviders/move-file", Void.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "from", from, "to", to});
    }

    public Map<String, String> getAccessInfo(boolean withSensitiveInfo) throws IOException, CodedException, DKUSecurityException {
        return (Map)this.client.getForm("/tintercom/fsproviders/access-info", (TypeToken)new TypeToken<Map<String, String>>(){}, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "withSensitiveInfo", withSensitiveInfo});
    }

    public void makeEmpty(String path) throws IOException, DKUSecurityException {
        this.client.postFormToJSON("/tintercom/fsproviders/empty", Void.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "path", path});
    }

    public void ensureDirectory(String path) throws IOException, DKUSecurityException {
        this.client.postFormToJSON("/tintercom/fsproviders/ensure-directory", Void.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "path", path});
    }

    @Override
    public void grantFullACLs(AuthCtx authCtx, String projectKey) throws IOException, InterruptedException, DKUSecurityException {
        this.client.postFormToJSON("/tintercom/fsproviders/grant-full-acls", Void.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "projectKey", projectKey});
    }

    @Override
    public void grantReadACLs(AuthCtx authCtx, String projectKey) throws DKUSecurityException, IOException, InterruptedException {
        this.client.postFormToJSON("/tintercom/fsproviders/grant-read-acls", Void.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "projectKey", projectKey});
    }

    @Override
    public void tightenAccess(AuthCtx authCtx) throws IOException, InterruptedException {
        this.client.postFormToJSON("/tintercom/fsproviders/tighten", Void.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath});
    }

    public EnrichedInputStream read(String path) throws IOException, CodedException, DKUSecurityException {
        FSPathOrDirectory file = this.stat(path);
        return new RemoteFSEnrichedInputStream(file.getSize(), path, PathUtils.getLastPathSegment((String)file.path()), file.path(), file.getLastModified());
    }

    public OutputStream write(String path) throws IOException, CodedException, DKUSecurityException {
        TicketBasedIntercomAPIClient writeClient = CDEProcessUtils.newIntercomAPIClient();
        String writePath = this.makeFile(path);
        String fileName = PathUtils.getLastPathSegment((String)writePath);
        RemoteFSWriteThread writerThread = new RemoteFSWriteThread(writeClient, path, fileName);
        writerThread.start();
        return writerThread.getOutputStream();
    }

    public class RemoteFSEnrichedInputStream
    extends AutoEnrichedInputStream {
        public RemoteFSEnrichedInputStream(long size, String pathWithinProvider, String filename, String desc, long lastModified) {
            super(size, pathWithinProvider, filename, desc, () -> lastModified);
        }

        protected InputStream getBasicInputStream() throws IOException {
            final TicketBasedIntercomAPIClient readClient = CDEProcessUtils.newIntercomAPIClient();
            return new FilterInputStream(readClient.getFormToInputStream("/tintercom/fsproviders/read", new Object[]{"connectionName", RemoteFSProvider.this.connectionName, "executionId", RemoteFSProvider.this.executionId, "rootPath", RemoteFSProvider.this.rootPath, "path", this.getPathWithinProvider()})){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        readClient.close();
                    }
                }
            };
        }

        protected InputStream getBasicHeadInputStream(long size) throws IOException {
            return this.getBasicInputStream();
        }
    }

    public class RemoteFSWriteThread
    extends Thread {
        private final TicketBasedIntercomAPIClient writeClient;
        private final String path;
        private final String fileName;
        private final PipedInputStream pin;
        private final PipedOutputStream pos;
        private Throwable thrown;

        public RemoteFSWriteThread(TicketBasedIntercomAPIClient writeClient, String path, String fileName) throws IOException {
            this.writeClient = writeClient;
            this.path = path;
            this.fileName = fileName;
            this.pin = new PipedInputStream();
            this.pos = new PipedOutputStream();
            this.pos.connect(this.pin);
        }

        public OutputStream getOutputStream() {
            return new FilterOutputStream(this.pos){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        try {
                            RemoteFSWriteThread.this.join();
                        }
                        catch (Exception e) {
                            throw new IOException("Error while waiting for writer thread", e);
                        }
                        finally {
                            RemoteFSWriteThread.this.writeClient.close();
                        }
                    }
                    if (RemoteFSWriteThread.this.thrown != null) {
                        throw new IOException("Error in writer thread", RemoteFSWriteThread.this.thrown);
                    }
                }
            };
        }

        @Override
        public void run() {
            try {
                this.writeClient.postFormAndFileToJSON("/tintercom/fsproviders/write", Void.class, this.pin, this.fileName, new Object[]{"connectionName", RemoteFSProvider.this.connectionName, "executionId", RemoteFSProvider.this.executionId, "rootPath", RemoteFSProvider.this.rootPath, "path", this.path});
            }
            catch (Throwable e) {
                logger.error((Object)"Failed to write data", e);
                this.thrown = e;
            }
        }
    }
}

