/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs.plugin;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomPythonElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderBuildersRegistry;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDatasetMeta;
import com.dataiku.dip.datasets.fs.plugin.CustomPythonFSProviderBuilder;
import com.dataiku.dip.datasets.fs.plugin.CustomPythonFSProviderDesc;
import com.dataiku.dip.datasets.fs.plugin.LoadedPythonFSProvider;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.springframework.stereotype.Service;

@Service
public class CustomPythonFSProvidersService
extends CustomPythonElementService<CustomPythonFSProviderDesc, LoadedPythonFSProvider> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fs.plugins.service");

    @Override
    public String getFolderName() {
        return "python-fs-providers";
    }

    @Override
    public String getPrefix() {
        return "fs-provider";
    }

    @Override
    protected String getCodeExtension(LoadedPythonFSProvider desc) {
        return ".py";
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "fsprovider_" + pluginId + "_" + elementId;
    }

    @Override
    public Class<CustomPythonFSProviderDesc> getDescClass() {
        return CustomPythonFSProviderDesc.class;
    }

    @Override
    public Class<LoadedPythonFSProvider> getLoadedDescClass() {
        return LoadedPythonFSProvider.class;
    }

    @Override
    protected void removeElement(LoadedPythonFSProvider desc) {
        CustomFSProviderBuildersRegistry.deregister(desc.fsProviderType);
    }

    @Override
    protected LoadedPythonFSProvider load(String elementType, String pluginId, String elementId, File file) throws IOException {
        logger.debug((Object)("Loading FS provider " + elementType + " from plugin " + pluginId));
        LoadedPythonFSProvider loaded = new LoadedPythonFSProvider(elementType, pluginId, elementId, (CustomPythonFSProviderDesc)JSON.parseFile((File)file, CustomPythonFSProviderDesc.class));
        CustomFSProviderBuildersRegistry.register(new CustomPythonFSProviderBuilder(loaded, this));
        CustomFSProviderDatasetMeta<CustomPythonFSProviderDesc> meta = new CustomFSProviderDatasetMeta<CustomPythonFSProviderDesc>(loaded);
        DatasetHandlerFactory.checkDuplicateDatasetMeta(pluginId, elementId, elementType, CustomFSProviderDatasetMeta.class);
        DatasetHandlerFactory.registerDatasetType(meta);
        return loaded;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomPythonFSProviderDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, CustomPythonFSProvidersService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                return this.messages;
            }
        }.validate();
    }
}

