/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.mongodb;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.mongodb.MongoDBConnectionWrapper;
import com.dataiku.dip.datasets.mongodb.MongoDBDatasetHandler;
import com.dataiku.dip.datasets.mongodb.MongoDBTypeConverter;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import java.util.HashMap;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public abstract class MongoDBDatasetInputHandler {
    protected MongoDBDatasetHandler datasetHandler;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.mongodb");

    public abstract void createManaged() throws Exception;

    public abstract List<Partition> listPartitions() throws Exception;

    public abstract RowsInputSplit getPartitionSplit(Partition var1) throws Exception;

    public abstract FilterResultWithSplits getFilterSplits(InputFilter var1) throws Exception;

    public abstract RowsInputSplit getSingleSplit() throws Exception;

    public abstract RowsInputSplit getSampleSplit() throws Exception;

    public abstract long computePartitionRecords(Partition var1) throws Exception;

    public abstract void clearPartitions(List<Partition> var1) throws Exception;

    protected long executePush(DBObject q, ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
        MongoDBTypeConverter typeConverter = new MongoDBTypeConverter();
        long rowsBefore = listener == null ? 0L : listener.getReadRecords();
        try (MongoDBConnectionWrapper mongoConn = this.datasetHandler.getNewConnection();){
            long l;
            block22: {
                MongoCollection coll = mongoConn.db.getCollection(this.datasetHandler.config.collection);
                logger.info((Object)("Enumerating collection: " + this.datasetHandler.config.collection + " with filter " + q.toString() + (String)(this.datasetHandler.queryFields != null ? " with fields " + String.valueOf(this.datasetHandler.queryFields) : "") + (String)(limit != null && limit.maxRecords > 0L ? " with limit " + limit.maxRecords : "")));
                BasicDBObject bsonFilter = new BasicDBObject(q.toMap());
                FindIterable curs = coll.find((Bson)bsonFilter);
                if (this.datasetHandler.queryFields != null) {
                    curs = curs.projection((Bson)new BasicDBObject(this.datasetHandler.queryFields.toMap()));
                }
                MongoCursor<Document> iterator = MongoDBDatasetInputHandler.getMongoDocumentIterator(limit, (FindIterable<Document>)curs);
                try {
                    List restrictToColumns = null;
                    HashMap<String, SchemaColumn> schemaColumnsMap = new HashMap<String, SchemaColumn>();
                    if (this.datasetHandler.config.strictInputFormat && this.datasetHandler.getDataset().getSchema() != null) {
                        restrictToColumns = this.datasetHandler.getDataset().getSchema().getColumns();
                    }
                    if (this.datasetHandler.getDataset().getSchema() != null) {
                        for (SchemaColumn col : this.datasetHandler.getDataset().getSchema().getColumns()) {
                            schemaColumnsMap.put(col.getName(), col);
                            cf.column(col.getName());
                        }
                    }
                    long rowsPushed = 0L;
                    while (iterator.hasNext()) {
                        Document obj = (Document)iterator.next();
                        Row r = rf.row();
                        if (restrictToColumns != null) {
                            for (SchemaColumn col : restrictToColumns) {
                                String colName = col.getName();
                                String colValue = typeConverter.fromMongoValue(obj.get((Object)colName), col, this.datasetHandler.config.readDataTypeMismatchBehavior, warningsContext);
                                if (colValue == null) continue;
                                r.put(cf.column(colName), colValue);
                            }
                        } else {
                            for (String colName : obj.keySet()) {
                                String colValue = typeConverter.fromMongoValue(obj.get((Object)colName), (SchemaColumn)schemaColumnsMap.get(colName), this.datasetHandler.config.readDataTypeMismatchBehavior, warningsContext);
                                if (colValue == null) continue;
                                r.put(cf.column(colName), colValue);
                            }
                        }
                        if (listener != null && ++rowsPushed % 50L == 0L) {
                            listener.setData(0L, 0L, rowsBefore + rowsPushed);
                        }
                        out.emitRow(r);
                    }
                    l = rowsPushed;
                    if (iterator == null) break block22;
                }
                catch (Throwable throwable) {
                    if (iterator != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                iterator.close();
            }
            return l;
        }
    }

    private static MongoCursor<Document> getMongoDocumentIterator(ExtractionLimit limit, FindIterable<Document> curs) {
        if (limit != null && limit.maxRecords > 0L) {
            if (limit.maxRecords > Integer.MAX_VALUE) {
                limit.maxRecords = Integer.MAX_VALUE;
            }
            curs = curs.limit((int)limit.maxRecords);
        }
        return curs.iterator();
    }

    public class GlobalSplit
    extends RowsInputSplit {
        protected InputFilter filter;

        GlobalSplit() {
        }

        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            BasicDBObject combinedQuery;
            BasicDBObject filterQuery = null;
            if (out != null) {
                filterQuery = new BasicDBObject();
            }
            if (MongoDBDatasetInputHandler.this.datasetHandler.query == null) {
                combinedQuery = filterQuery;
            } else if (filterQuery == null) {
                combinedQuery = MongoDBDatasetInputHandler.this.datasetHandler.query;
            } else {
                BasicDBList l = new BasicDBList();
                l.add((Object)filterQuery);
                l.add((Object)MongoDBDatasetInputHandler.this.datasetHandler.query);
                combinedQuery = new BasicDBObject("$and", (Object)l);
            }
            return MongoDBDatasetInputHandler.this.executePush((DBObject)combinedQuery, out, cf, rf, limit, listener, warningsContext);
        }

        public String getDesc() {
            return "MongoDB";
        }
    }
}

