/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.streamwrite;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class StreamWriter {
    protected ColumnFactory cf;
    protected final AuthCtx authCtx;
    protected final DatasetHandler outputDH;
    protected final String sourceId;
    protected final int splitId;
    private static Logger logger = Logger.getLogger((String)"dip.stream.writer");

    public StreamWriter(AuthCtx authCtx, DatasetHandler outputDH, String sourceId, int splitId) {
        this.authCtx = authCtx;
        this.outputDH = outputDH;
        this.sourceId = sourceId;
        this.splitId = splitId;
    }

    public abstract void append(Row var1) throws Exception;

    public void checkpoint(String newState) throws Exception {
        this.closeOpenPartitions();
        logger.warn((Object)("Storing state is not supported in DH " + String.valueOf(this.outputDH.getClass())));
    }

    protected abstract void closeOpenPartitions() throws Exception;

    protected abstract void cancelOpenPartitions() throws Exception;

    public void close() throws Exception {
        logger.info((Object)"Closing StreamWriter");
        this.closeOpenPartitions();
    }

    public void cancel() throws Exception {
        logger.info((Object)"Cancelling StreamWriter");
        this.cancelOpenPartitions();
    }

    public void setColumnFactory(ColumnFactory cf) {
        this.cf = cf;
    }

    public ColumnFactory getColumnFactory() {
        return this.cf;
    }

    public String getRecordedState() throws Exception {
        logger.warn((Object)("Storing state is not supported in DH " + String.valueOf(this.outputDH.getClass())));
        return null;
    }

    protected class OpenOutputPartition {
        Partition partition;
        OutputWriter writer;
        Output output;

        protected OpenOutputPartition() {
        }

        public void lastRowEmitted() throws Exception {
            if (this.writer != null) {
                this.writer.lastRowEmitted();
            }
        }

        public void cancel() throws Exception {
            if (this.writer != null) {
                this.writer.cancel();
            }
        }

        public void setupNewOpenOutputPartition(String partitionId) throws Exception, IOException, DKUSecurityException, InterruptedException, CodedException {
            this.partition = PartitionFactory.fromIdentifier(StreamWriter.this.outputDH.getDataset().getPartitioningSchema(), partitionId);
            this.output = StreamWriter.this.outputDH.buildOutput(this.partition, StreamWriter.this.splitId, 1, new WarningsContext());
            this.writer = this.output.getWriter(Output.WriteMode.APPEND);
            this.writer.init(StreamWriter.this.cf);
        }
    }
}

