/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.twitter;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRow;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.twitter.TwitterDatasetUtils;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.partitioning.TimeDimensionValue;
import com.dataiku.dip.security.AuthCtx;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TwitterStream {
    OutputWriter outputWriter;
    DatasetHandler outputDh;
    ColumnFactory cf;
    List<String> colNames;
    private final AuthCtx authCtx;
    private final Dataset dataset;
    Calendar calendar;
    SimpleDateFormat inputDateFormat;
    SimpleDateFormat outputDateFormat;
    TimeDimensionValue currentTDV;
    Partition currentPartition;
    boolean parseUserCreatedAt = false;
    boolean storeKeywords = false;
    final int maxQueueSize = 1000;
    private static Logger logger = Logger.getLogger((String)"dip.twitter");

    public TwitterStream(AuthCtx authCtx, Dataset dataset) {
        this.authCtx = authCtx;
        this.dataset = dataset;
        this.inputDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss ZZZZZ yyyy", Locale.ENGLISH);
        this.inputDateFormat.setLenient(false);
        TimeZone tz = TimeZone.getTimeZone("UTC");
        this.outputDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.'000Z'");
        this.outputDateFormat.setTimeZone(tz);
        this.calendar = Calendar.getInstance();
        this.colNames = new ArrayList<String>();
        for (SchemaColumn c2 : dataset.getSchema().getColumns()) {
            this.colNames.add(c2.getName());
        }
        if (this.colNames.contains("user.created_at")) {
            this.parseUserCreatedAt = true;
        }
        if (this.colNames.contains("keywords")) {
            this.storeKeywords = true;
        }
        this.cf = new StreamColumnFactory();
    }

    public String getName() {
        return this.dataset.getFullName();
    }

    public void process(JSONObject root, List<String> keywords) {
        Date createdAt = null;
        StreamRow row = new StreamRow();
        try {
            createdAt = this.inputDateFormat.parse(TwitterStream.getJSONValue("created_at", root));
        }
        catch (Exception e) {
            return;
        }
        Date userCreatedAt = null;
        if (this.parseUserCreatedAt) {
            try {
                JSONObject user = root.getJSONObject("user");
                userCreatedAt = this.inputDateFormat.parse(user.getString("created_at"));
            }
            catch (ParseException | JSONException e) {
                logger.error((Object)"Failed to parse twitter field user.created_at");
            }
        }
        try {
            if (this.currentPartition == null) {
                this.createPartition(createdAt);
            }
            this.updatePartition(createdAt);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to create or update partition for writing");
        }
        for (String colName : this.colNames) {
            try {
                row.put(this.cf.column(colName), TwitterStream.getJSONValue(colName, root));
            }
            catch (JSONException e) {}
        }
        row.put(this.cf.column("created_at"), this.outputDateFormat.format(createdAt));
        if (this.parseUserCreatedAt && userCreatedAt != null) {
            row.put(this.cf.column("user.created_at"), this.outputDateFormat.format(userCreatedAt));
        }
        if (this.storeKeywords) {
            row.put(this.cf.column("keywords"), new JSONArray(keywords).toString());
        }
        try {
            this.outputWriter.emitRow((Row)row);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to emit row");
        }
    }

    public void close() {
        try {
            this.closePartition();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to close partition");
        }
    }

    static String getJSONValue(String col, JSONObject root) throws JSONException {
        JSONObject cur = root;
        String[] tree = col.split("\\.");
        for (int i = 0; i < tree.length - 1; ++i) {
            cur = cur.getJSONObject(tree[i]);
        }
        Object oval = cur.get(tree[tree.length - 1]);
        return oval == null ? null : oval.toString();
    }

    private void setPartitionDate(Partition p, Date d) {
        this.calendar.setTime(d);
        TimeDimension td = p.getScheme().getSingleTimeDimension();
        this.currentTDV = new TimeDimensionValue(td).withCal(this.calendar);
        p.setDimensionValue(td.getName(), (DimensionValue)this.currentTDV);
    }

    private void createPartition(Date d) throws Exception {
        this.currentPartition = new Partition(this.dataset.getPartitioningSchema());
        this.setPartitionDate(this.currentPartition, d);
        Dataset twitterOutDS = TwitterDatasetUtils.generateTwitterOutputDataset(this.dataset);
        this.outputDh = DatasetHandlerFactory.build(this.authCtx, twitterOutDS);
        Output od = this.outputDh.buildOutput(this.currentPartition, 0, 1, null);
        this.outputWriter = od.getWriter(Output.WriteMode.APPEND);
        this.outputWriter.init(this.cf);
    }

    private void closePartition() throws Exception {
        try {
            this.outputWriter.lastRowEmitted();
        }
        catch (Exception e) {
            logger.error((Object)("Failed to close current partition & emit last row " + this.currentTDV.id()));
            this.outputWriter.cancel();
        }
        finally {
            this.outputDh.close();
        }
    }

    private void updatePartition(Date d) throws Exception {
        this.calendar.setTime(d);
        TimeDimension td = this.currentPartition.getScheme().getSingleTimeDimension();
        TimeDimensionValue tdv = new TimeDimensionValue(td).withCal(this.calendar);
        if (tdv.getCalendar().getTimeInMillis() != this.currentTDV.getCalendar().getTimeInMillis()) {
            this.currentTDV = tdv;
            this.closePartition();
            this.createPartition(d);
        }
    }
}

