/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.docextraction.DocExtractionUtils;
import com.dataiku.dip.docextraction.Page;
import com.dataiku.dip.docextraction.PagesIterator;
import com.dataiku.dip.docextraction.PdfBoxPdfDocumentScreenshotsDrawer;
import com.dataiku.dip.docextraction.PoiPPTXDocumentScreenshotsDrawer;
import com.dataiku.dip.docextraction.Screenshotter;
import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.LibreOfficeUtil;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.org.apache.commons.codec.binary.Hex;
import com.dataiku.dss.shadelib.org.apache.commons.codec.digest.DigestUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;

@Service
public class ScreenshotterService {
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private TransactionService transactionService;
    private Boolean hasLibreOfficeBin = null;
    public static final int MAX_LIBREOFFICE_INSTANCES = DKUApp.getParams().getIntParam("dku.docextraction.pdfconversion.maxLibreOfficeInstances", Integer.valueOf(1));
    public static final long LIBREOFFICE_TIMEOUT_IN_MS = DKUApp.getParams().getLongParam("dku.docextraction.pdfconversion.libreOfficeProcessTimeoutSeconds", 1800L) * 1000L;
    public static final String DONE_FILE_NAME = "done.json";
    public AtomicInteger currentLibreOfficeInstance = new AtomicInteger(0);
    public ConcurrentMap<Integer, ReentrantLock> locks = new ConcurrentHashMap<Integer, ReentrantLock>();
    public static final DKULogger logger = DKULogger.getLogger((String)"dku.screenshotter");

    private boolean isLibreOfficeInstalled() {
        if (this.hasLibreOfficeBin == null) {
            this.hasLibreOfficeBin = LibreOfficeUtil.hasLibreOfficeBin();
        }
        return this.hasLibreOfficeBin;
    }

    public Screenshotter.ScreenshotterResponseOrError extractScreenshotsFromTmpDocumentRef(AuthCtx authCtx, String projectKey, InputRefs.TmpDocumentRef documentRef, Screenshotter.ScreenshotterSettings settings) throws Exception {
        Screenshotter.EnrichedScreenshotterResponseOrError res;
        File tmp = DKUApp.getFile((String[])new String[]{"tmp", "docextraction", "screenshots-extraction", documentRef.tmpFileName});
        if (!tmp.exists()) {
            throw new IOException("Cannot retrieve the associated file from tmp file, try to upload the original file again");
        }
        try (InputStream fileStream = DKUFileUtils.readWithAutoDecompress((File)tmp);){
            res = this.extractScreenshotsFromInputStream(authCtx, projectKey, tmp, fileStream, documentRef.originalFileName, settings);
        }
        res.responseOrError.documentRef = documentRef;
        if (res.responseOrError.ok && !res.responseOrError.hasMoreResults) {
            res.convertedFile.ifPresent(this::cleanTmpFile);
            this.cleanTmpFile(tmp);
        }
        return res.responseOrError;
    }

    public Screenshotter.ScreenshotterResponseOrError extractScreenshotsFromLocalFileDocumentRef(AuthCtx authCtx, String projectKey, InputRefs.LocalFileDocumentRef document, Screenshotter.ScreenshotterSettings settings) throws Exception {
        File docFile;
        String ext = FilenameUtils.getExtension((String)document.multipartFile.getOriginalFilename());
        try {
            File tmpFolder = DSSTempUtils.getTempFolderWithSpecifiName((String)"docextraction", (String)"screenshots-extraction");
            docFile = File.createTempFile("doc" + FilenameUtils.getBaseName((String)document.multipartFile.getOriginalFilename()), "." + ext, tmpFolder);
            FileUtils.copyInputStreamToFile((InputStream)document.multipartFile.getInputStream(), (File)docFile);
        }
        catch (IOException e) {
            throw new IOException("Cannot write the file to tmp folder", e);
        }
        InputRefs.TmpDocumentRef tmpDocumentRef = new InputRefs.TmpDocumentRef();
        tmpDocumentRef.tmpFileName = docFile.getName();
        tmpDocumentRef.originalFileName = document.multipartFile.getOriginalFilename();
        return this.extractScreenshotsFromTmpDocumentRef(authCtx, projectKey, tmpDocumentRef, settings);
    }

    public Screenshotter.ScreenshotterResponseOrError extractScreenshotsFromManagedFolderDocumentRef(AuthCtx authCtx, String projectKey, InputRefs.ManagedFolderDocumentRef documentRef, Screenshotter.ScreenshotterSettings settings) throws Exception {
        Screenshotter.EnrichedScreenshotterResponseOrError enrichedScreenshotterResponseOrError;
        File tmpFile;
        ManagedFolder mf = this.getManagedFolder(projectKey, documentRef.managedFolderId);
        try (ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(authCtx);){
            handler.getProvider();
            EnrichedInputStream docStream = handler.getInputStream(documentRef.filePath);
            try (InputStream inputStream = docStream.rawStream();){
                File tmpFolder = DSSTempUtils.getTempFolderWithSpecifiName((String)"docextraction", (String)"screenshots-extraction");
                tmpFile = File.createTempFile("doc" + FilenameUtils.getBaseName((String)docStream.getFilename()), "." + FilenameUtils.getExtension((String)docStream.getFilename()), tmpFolder);
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tmpFile);
            }
        }
        try (InputStream fileStream = DKUFileUtils.readWithAutoDecompress((File)tmpFile);){
            enrichedScreenshotterResponseOrError = this.extractScreenshotsFromInputStream(authCtx, projectKey, tmpFile, fileStream, documentRef.filePath, settings);
        }
        this.cleanTmpFile(tmpFile);
        if (enrichedScreenshotterResponseOrError.responseOrError.ok && !enrichedScreenshotterResponseOrError.responseOrError.hasMoreResults) {
            enrichedScreenshotterResponseOrError.convertedFile.ifPresent(this::cleanTmpFile);
        }
        enrichedScreenshotterResponseOrError.responseOrError.documentRef = documentRef;
        return enrichedScreenshotterResponseOrError.responseOrError;
    }

    private ManagedFolder getManagedFolder(String projectKey, String documentRef) throws IOException {
        ManagedFolder mf;
        AnyLoc managedFolderLoc = AnyLoc.resolveSmart(projectKey, documentRef);
        if (TransactionContext.hasAttachedTransaction()) {
            mf = (ManagedFolder)this.managedFolderDAO.getMandatoryUnsafe(managedFolderLoc);
        } else {
            try (Transaction t = this.transactionService.beginRead();){
                mf = (ManagedFolder)this.managedFolderDAO.getMandatoryUnsafe(managedFolderLoc);
            }
        }
        return mf;
    }

    private void cleanTmpFile(File tmp) {
        try {
            DKUFileUtils.delete((File)tmp);
        }
        catch (IOException e) {
            logger.info((Object)"Failed to clean doc extraction file from tmp directory");
        }
    }

    private Screenshotter.EnrichedScreenshotterResponseOrError cachedScreenshotterEnrichedResponse(AuthCtx authCtx, String projectKey, File inputFile, String originalFilePath, Screenshotter.ScreenshotterSettings settings, Screenshotter.ScreenshotterSettings.ScreenshotterEngine engine) {
        Screenshotter.ScreenshotterResponseOrError response;
        block10: {
            Screenshotter.ScreenshotterSettings.StorageImpactingSettings scSettings = new Screenshotter.ScreenshotterSettings.StorageImpactingSettings(engine);
            response = new Screenshotter.ScreenshotterResponseOrError();
            response.ok = false;
            if (settings.outputManagedFolderId != null) {
                try {
                    ManagedFolder mf = this.getManagedFolder(projectKey, settings.outputManagedFolderId);
                    String digest = this.getHashFromFileContentAndStorageImpactingSettings(inputFile, scSettings, originalFilePath);
                    String commonPrefixPath = this.getOutputScreenshotCommonPrefixPath(originalFilePath, digest);
                    try (ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(authCtx);){
                        String donePath = this.getOutputScreenshotFullPath(originalFilePath, digest, DONE_FILE_NAME);
                        if (handler.getFile(donePath) != null) {
                            EnrichedInputStream doneFile = handler.getInputStream(donePath);
                            Screenshotter.CachedScreenshotterResponse cachedResponse = (Screenshotter.CachedScreenshotterResponse)JSON.parse((InputStream)doneFile.rawStream(), Screenshotter.CachedScreenshotterResponse.class);
                            response = Screenshotter.ScreenshotterResponseOrError.fromCached(cachedResponse, settings.outputManagedFolderId, commonPrefixPath);
                            break block10;
                        }
                        throw new FileNotFoundException("Could not find done file.");
                    }
                }
                catch (CodedException | DKUSecurityException | IOException | InterruptedException e) {
                    response = Screenshotter.ScreenshotterResponseOrError.fromError(e);
                }
            }
        }
        Screenshotter.EnrichedScreenshotterResponseOrError enriched = new Screenshotter.EnrichedScreenshotterResponseOrError();
        enriched.responseOrError = response;
        return enriched;
    }

    private Screenshotter.EnrichedScreenshotterResponseOrError extractScreenshotsFromInputStream(AuthCtx authCtx, String projectKey, File tmpFile, InputStream fileStream, String originalFilePath, Screenshotter.ScreenshotterSettings settings) throws IOException, UnsupportedOperationException, UnsupportedMediaTypeStatusException {
        String ext = FilenameUtils.getExtension((String)tmpFile.getName()).toLowerCase();
        ErrorContext.check((boolean)StringUtils.isNotBlank((String)ext), (String)"File extension cannot be blank");
        settings.paginationOffset = Objects.requireNonNullElse(settings.paginationOffset, Screenshotter.DEFAULT_PAGINATION_OFFSET);
        settings.paginationSize = Objects.requireNonNullElse(settings.paginationSize, Screenshotter.DEFAULT_PAGINATION_SIZE);
        ErrorContext.check((settings.paginationOffset >= 0 ? 1 : 0) != 0, (String)"Pagination offset cannot be lower than 0");
        ErrorContext.check((settings.paginationSize > 0 ? 1 : 0) != 0, (String)"Pagination size cannot be lower or equal to 0");
        logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "Starting screenshot extraction"));
        switch (ext) {
            case "pdf": {
                return this.generateScreenshotsFromPdfInputStream(authCtx, projectKey, tmpFile, fileStream, Screenshotter.ScreenshotterSettings.ScreenshotterEngine.BACKEND, originalFilePath, settings);
            }
            case "odp": 
            case "ppt": 
            case "odt": 
            case "doc": 
            case "docx": 
            case "xls": 
            case "xlsx": 
            case "xlsb": 
            case "xlsm": 
            case "ods": {
                if (!this.isLibreOfficeInstalled()) {
                    throw new UnsupportedOperationException("LibreOffice must be installed in order to convert " + ext + " files to images. A Dataiku administrator needs to run the following command to install it: " + DKUApp.getInstallFile((String[])new String[]{"scripts", "install", "install-deps.sh"}).getAbsolutePath() + " -with-libreoffice");
                }
                return this.fileToScreenshotsWithLibreOffice(authCtx, projectKey, fileStream, tmpFile, originalFilePath, settings);
            }
            case "pptx": {
                if (!this.isLibreOfficeInstalled()) {
                    logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "LibreOffice is not installed, default method will be used for file: " + tmpFile.getPath()));
                    return this.generateScreenshotsFromPptxInputStream(authCtx, projectKey, tmpFile, fileStream, originalFilePath, settings);
                }
                return this.fileToScreenshotsWithLibreOffice(authCtx, projectKey, fileStream, tmpFile, originalFilePath, settings);
            }
            case "png": 
            case "jpeg": 
            case "jpg": {
                Screenshotter.EnrichedScreenshotterResponseOrError res = new Screenshotter.EnrichedScreenshotterResponseOrError();
                res.responseOrError = this.generateScreenshotsFromImage(authCtx, projectKey, tmpFile, fileStream, originalFilePath, settings);
                return res;
            }
        }
        throw new UnsupportedMediaTypeStatusException("Cannot convert file:" + originalFilePath + " to screenshots because conversion for ." + ext + " files is not supported");
    }

    private Screenshotter.ScreenshotterResponseOrError generateScreenshotsFromImage(AuthCtx authCtx, String projectKey, File tmpFile, InputStream fileStream, String originalFilePath, Screenshotter.ScreenshotterSettings settings) throws IOException {
        BufferedImage img = ImageIO.read(fileStream);
        if (settings.outputManagedFolderId != null) {
            ManagedFolder outputMf = this.getManagedFolder(projectKey, settings.outputManagedFolderId);
            InputRefs.ManagedFolderImagesRef imagesRef = new InputRefs.ManagedFolderImagesRef();
            imagesRef.managedFolderId = settings.outputManagedFolderId;
            String digest = this.getHashFromFileContentAndStorageImpactingSettings(tmpFile, null, originalFilePath);
            imagesRef.commonPrefixPath = this.getOutputScreenshotCommonPrefixPath(originalFilePath, digest);
            try (ManagedFolderHandler handler = (ManagedFolderHandler)outputMf.buildHandler(authCtx);){
                String outputImagePath = this.getOutputScreenshotFullPath(originalFilePath, digest, FilenameUtils.getName((String)originalFilePath));
                imagesRef.imagesPaths.add(this.writeImageToManagedFolder(handler, img, outputImagePath, originalFilePath));
            }
            return Screenshotter.ScreenshotterResponseOrError.fromSuccess(imagesRef, false, 0, 1);
        }
        String content = ScreenshotterService.imageToPngBase64(img);
        InputRefs.InlineImagesRef imagesRef = new InputRefs.InlineImagesRef();
        imagesRef.inlineImages.add(new InputRefs.SingleInlineImage(content, "image/png"));
        return Screenshotter.ScreenshotterResponseOrError.fromSuccess(imagesRef, false, 0, 1);
    }

    private String getOutputScreenshotFullPath(String originalFilePath, String fileAndStorageImpactingSettingsDigest, String screenshotName) {
        return PathUtils.concatLNT((String[])new String[]{this.getOutputScreenshotCommonPrefixPath(originalFilePath, fileAndStorageImpactingSettingsDigest), screenshotName});
    }

    private String getOutputScreenshotCommonPrefixPath(String originalFilePath, String fileAndStorageImpactingSettingsDigest) {
        return PathUtils.concatLNT((String[])new String[]{originalFilePath, "pages-" + fileAndStorageImpactingSettingsDigest});
    }

    private String getHashFromFileContentAndStorageImpactingSettings(File file, Screenshotter.ScreenshotterSettings.StorageImpactingSettings settings, String originalFilePath) throws IOException {
        MessageDigest messageDigest = DigestUtils.getSha1Digest();
        messageDigest.update(Files.readAllBytes(file.toPath()));
        JSON.updateDigest((MessageDigest)messageDigest, (Object)settings);
        logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, (String)(settings == null ? "No storage impacting settings used to generate digest" : "settingsStorage impacting settings used to generate digest: " + String.valueOf(settings))));
        return Hex.encodeHexString((byte[])messageDigest.digest());
    }

    private Screenshotter.EnrichedScreenshotterResponseOrError generateScreenshotsFromPptxInputStream(AuthCtx authCtx, String projectKey, File tmpFile, InputStream fileStream, String originalFilePath, Screenshotter.ScreenshotterSettings settings) throws IOException {
        Screenshotter.EnrichedScreenshotterResponseOrError pptxRes = this.cachedScreenshotterEnrichedResponse(authCtx, projectKey, tmpFile, originalFilePath, settings, Screenshotter.ScreenshotterSettings.ScreenshotterEngine.BACKEND);
        if (pptxRes.responseOrError.ok) {
            logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "Found previously generated screenshots: Not regenerating all screenshots"));
        } else {
            try (PoiPPTXDocumentScreenshotsDrawer pptxDrawer = new PoiPPTXDocumentScreenshotsDrawer(fileStream);){
                pptxRes = new Screenshotter.EnrichedScreenshotterResponseOrError();
                PagesIterator pptxPagesIterator = new PagesIterator(pptxDrawer, settings);
                boolean writeOutputToManagedFolder = settings.outputManagedFolderId != null;
                try {
                    pptxRes.responseOrError = writeOutputToManagedFolder ? this.writeDocumentScreenshotsToManagedFolder(authCtx, pptxPagesIterator, projectKey, originalFilePath, tmpFile, new Screenshotter.ScreenshotterSettings.StorageImpactingSettings(Screenshotter.ScreenshotterSettings.ScreenshotterEngine.BACKEND), settings) : this.generateDocumentScreenshotsAsBase64PngImages(originalFilePath, pptxPagesIterator);
                }
                catch (Exception e) {
                    logger.error((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "Failed to generate screenshots with Apache POI for pptx document"), (Throwable)e);
                    throw new IOException("Failed to generate screenshots with Apache POI for pptx document " + originalFilePath + " . Please consider installing Libreoffice to process it", e);
                }
            }
        }
        return pptxRes;
    }

    private Screenshotter.ScreenshotterResponseOrError generateDocumentScreenshotsAsBase64PngImages(String originalFilePath, PagesIterator pagesIterator) throws IOException {
        InputRefs.InlineImagesRef imagesRef = new InputRefs.InlineImagesRef();
        while (pagesIterator.hasNext()) {
            Page page = pagesIterator.next();
            logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "Drawing page " + page.page_number));
            String base64Image = ScreenshotterService.imageToPngBase64(page.draw());
            imagesRef.inlineImages.add(new InputRefs.SingleInlineImage(base64Image, "image/png"));
        }
        return Screenshotter.ScreenshotterResponseOrError.fromSuccess(imagesRef, pagesIterator.hasNextPaginationResults, pagesIterator.endIndex, pagesIterator.pageCount);
    }

    private String getPageScreenshotFullPath(String originalFilePath, String digest, int pageNumber) {
        return this.getOutputScreenshotFullPath(originalFilePath, digest, "page_" + DocExtractionUtils.padPageNumber(pageNumber) + ".png");
    }

    private Screenshotter.ScreenshotterResponseOrError writeDocumentScreenshotsToManagedFolder(AuthCtx authCtx, PagesIterator pagesIterator, String projectKey, String originalFilePath, File tmpFile, Screenshotter.ScreenshotterSettings.StorageImpactingSettings storageImpactingSettings, Screenshotter.ScreenshotterSettings settings) throws IOException {
        Screenshotter.ScreenshotterResponseOrError result;
        block16: {
            ManagedFolder mf = this.getManagedFolder(projectKey, settings.outputManagedFolderId);
            InputRefs.ManagedFolderImagesRef imagesRef = new InputRefs.ManagedFolderImagesRef();
            imagesRef.managedFolderId = settings.outputManagedFolderId;
            String digest = this.getHashFromFileContentAndStorageImpactingSettings(tmpFile, storageImpactingSettings, originalFilePath);
            try (ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(authCtx);){
                if (pagesIterator.hasNext()) {
                    imagesRef.commonPrefixPath = this.getOutputScreenshotCommonPrefixPath(originalFilePath, digest);
                    while (pagesIterator.hasNext()) {
                        Page page = pagesIterator.next();
                        String outputImagePath = this.getPageScreenshotFullPath(originalFilePath, digest, page.page_number);
                        logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "Drawing page " + page.page_number));
                        this.writeImageToManagedFolder(handler, page.draw(), outputImagePath, originalFilePath);
                        imagesRef.imagesPaths.add(outputImagePath);
                    }
                }
                result = Screenshotter.ScreenshotterResponseOrError.fromSuccess(imagesRef, pagesIterator.hasNextPaginationResults, pagesIterator.endIndex, pagesIterator.pageCount);
                if (pagesIterator.hasNextPaginationResults || DKUApp.getProcessType() != MainLoggingConfigurator.ProcessType.JEK) break block16;
                String donePath = this.getOutputScreenshotFullPath(originalFilePath, digest, DONE_FILE_NAME);
                logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "Done with screenshot generation: dumping done.json in output folder for caching purposes"));
                try (OutputStream ostream = handler.getOutputStream(donePath);){
                    JSON.prettyToStreamAsFile((Object)new Screenshotter.CachedScreenshotterResponse(result), (OutputStream)ostream);
                }
                catch (Exception e) {
                    logger.warn((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "Cannot write done.json to output managed folder, screenshotter cache won't work"), (Throwable)e);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private LibreOfficeExecutionResults convertFileToPDFWithLibreOffice(String inputFilePath, String outputDirPath, String originalFileName, AuthCtx authCtx, String projectKey) {
        int libreOfficeInstance = this.getLibreOfficeInstance();
        ReentrantLock lock = this.locks.computeIfAbsent(libreOfficeInstance, k -> new ReentrantLock());
        lock.lock();
        try {
            DKUtils.ExecutionResults executionResults;
            String userProfileDirectoryPath = outputDirPath + "/instance_" + libreOfficeInstance;
            logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Using LibreOffice user profile in : " + userProfileDirectoryPath));
            ArrayList cmd = Lists.newArrayList();
            cmd.add("soffice");
            cmd.add("-env:UserInstallation=file://" + userProfileDirectoryPath);
            cmd.add("--headless");
            cmd.add("--convert-to");
            cmd.add("pdf");
            cmd.add(inputFilePath);
            cmd.add("--outdir");
            cmd.add(outputDirPath);
            ProcessBuilder pb = new ProcessBuilder(cmd);
            try {
                executionResults = ScreenshotterService.executeProcess(outputDirPath, authCtx, projectKey, libreOfficeInstance, pb);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Interrupted while waiting for LibreOffice execution results"), (Throwable)e);
                LibreOfficeExecutionResults libreOfficeExecutionResults = LibreOfficeExecutionResults.fromError(e);
                lock.unlock();
                return libreOfficeExecutionResults;
            }
            catch (IOException e) {
                logger.error((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Failed to convert file to PDF using LibreOffice"), (Throwable)e);
                LibreOfficeExecutionResults libreOfficeExecutionResults = LibreOfficeExecutionResults.fromError(e);
                lock.unlock();
                return libreOfficeExecutionResults;
            }
            logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Libreoffice stdout: " + executionResults.out));
            if (StringUtils.isNotBlank((String)executionResults.err)) {
                logger.error((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Libreoffice stderr: " + executionResults.err));
            }
            String outputFileName = FilenameUtils.getBaseName((String)inputFilePath) + ".pdf";
            File convertedFile = new File(PathUtils.concatLNT((String[])new String[]{outputDirPath, outputFileName}));
            if (!convertedFile.exists()) {
                StringBuilder message = new StringBuilder();
                message.append("Conversion to pdf using LibreOffice was not successful, it did not fail but did not create the converted pdf for file: ").append(originalFileName);
                logger.warn((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, message.toString()));
                message.append(". Libreoffice stout was: ").append(executionResults.out).append(", Libreoffice stderr was: ").append(executionResults.err);
                LibreOfficeExecutionResults libreOfficeExecutionResults = LibreOfficeExecutionResults.fromMissingOutputFile(executionResults, message.toString());
                return libreOfficeExecutionResults;
            }
            logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Converted file to PDF: " + outputFileName));
            LibreOfficeExecutionResults libreOfficeExecutionResults = LibreOfficeExecutionResults.fromSuccess(new File(PathUtils.concatLNT((String[])new String[]{outputDirPath, outputFileName})), executionResults);
            return libreOfficeExecutionResults;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DKUtils.ExecutionResults executeProcess(String outputDirPath, AuthCtx authCtx, String projectKey, int libreOfficeInstance, ProcessBuilder pb) throws IOException, InterruptedException {
        DKUtils.ExecutionResults executionResults = new DKUtils.ExecutionResults();
        DKUtils.ByteCollectingSubscription outputCollector = new DKUtils.ByteCollectingSubscription();
        DKUtils.ByteCollectingSubscription errorCollector = new DKUtils.ByteCollectingSubscription();
        DKUtils.ExecOutputConsumer outputConsumer = new DKUtils.ExecOutputConsumer().withThreadsBaseName("libreOffice-converter-" + libreOfficeInstance);
        outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)outputCollector);
        outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)errorCollector);
        RegularProcess rp = new RegularProcess(pb, new File(outputDirPath), GeneralSettingsDAO.CGrouppableProcessType.ML_KERNEL, authCtx, projectKey);
        rp.start();
        try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook(() -> {
            try {
                rp.evilKillWholeTree();
            }
            catch (IOException e) {
                logger.error((Object)"Failed to stop LibreOffice conversion process", (Throwable)e);
            }
        });){
            outputConsumer.start(rp.getInputStream(), rp.getErrorStream(), rp.getOutputStream());
            int rv = rp.waitFor(LIBREOFFICE_TIMEOUT_IN_MS);
            logger.info((Object)("LibreOffice conversion process done with code " + rv));
            if (rv == -1) {
                logger.warn((Object)("LibreOffice conversion process has timed out after " + LIBREOFFICE_TIMEOUT_IN_MS / 1000L + " seconds"));
                rp.evilKillWholeTree();
                throw new InterruptedException("LibreOffice conversion process has timed out");
            }
            outputConsumer.finish();
            executionResults.rv = rv;
            executionResults.out = new String(outputCollector.getCollected(), StandardCharsets.UTF_8);
            executionResults.err = new String(errorCollector.getCollected(), StandardCharsets.UTF_8);
        }
        finally {
            outputCollector.close();
            errorCollector.close();
        }
        return executionResults;
    }

    private int getLibreOfficeInstance() {
        return this.currentLibreOfficeInstance.getAndUpdate(i -> (i + 1) % MAX_LIBREOFFICE_INSTANCES) + 1;
    }

    private Screenshotter.EnrichedScreenshotterResponseOrError generateScreenshotsFromPdfInputStream(AuthCtx authCtx, String projectKey, File tmpFile, InputStream fileStream, Screenshotter.ScreenshotterSettings.ScreenshotterEngine engine, String originalFilePath, Screenshotter.ScreenshotterSettings settings) throws IOException {
        Screenshotter.EnrichedScreenshotterResponseOrError res = this.cachedScreenshotterEnrichedResponse(authCtx, projectKey, tmpFile, originalFilePath, settings, Screenshotter.ScreenshotterSettings.ScreenshotterEngine.BACKEND);
        if (res.responseOrError.ok) {
            logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "Found previously generated screenshots: Not regenerating all screenshots"));
        } else {
            res = new Screenshotter.EnrichedScreenshotterResponseOrError();
            boolean writeOutputToManagedFolder = settings.outputManagedFolderId != null;
            try (PdfBoxPdfDocumentScreenshotsDrawer pdfDrawer = new PdfBoxPdfDocumentScreenshotsDrawer(fileStream);){
                PagesIterator pdfPagesIterator = new PagesIterator(pdfDrawer, settings);
                res.responseOrError = writeOutputToManagedFolder ? this.writeDocumentScreenshotsToManagedFolder(authCtx, pdfPagesIterator, projectKey, originalFilePath, tmpFile, new Screenshotter.ScreenshotterSettings.StorageImpactingSettings(engine), settings) : this.generateDocumentScreenshotsAsBase64PngImages(originalFilePath, pdfPagesIterator);
            }
        }
        return res;
    }

    private Screenshotter.EnrichedScreenshotterResponseOrError fileToScreenshotsWithLibreOffice(AuthCtx authCtx, String projectKey, InputStream inputStreamForFallback, File inputFile, String originalFilePath, Screenshotter.ScreenshotterSettings settings) throws IOException, UnsupportedOperationException {
        Screenshotter.EnrichedScreenshotterResponseOrError res = this.cachedScreenshotterEnrichedResponse(authCtx, projectKey, inputFile, originalFilePath, settings, Screenshotter.ScreenshotterSettings.ScreenshotterEngine.LIBRE_OFFICE);
        if (res.responseOrError.ok) {
            logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "Found previously generated screenshots: Not regenerating all screenshots"));
        } else {
            ErrorContext.check((boolean)inputFile.exists(), (String)"The document is not accessible anymore, please try again");
            logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "Using LibreOffice engine to extract content from document"));
            String conversionTmpFolderPath = DSSTempUtils.getTempFolderWithSpecifiName((String)"docextraction", (String)"to-pdf-conversion").getAbsolutePath();
            String digest = this.getHashFromFileContentAndStorageImpactingSettings(inputFile, new Screenshotter.ScreenshotterSettings.StorageImpactingSettings(Screenshotter.ScreenshotterSettings.ScreenshotterEngine.LIBRE_OFFICE), originalFilePath);
            File relatedPdfFile = new File(conversionTmpFolderPath, digest + ".pdf");
            if (!relatedPdfFile.exists()) {
                LibreOfficeExecutionResults libreOfficeExecutionResults = this.convertFileToPDFWithLibreOffice(inputFile.getPath(), conversionTmpFolderPath, originalFilePath, authCtx, projectKey);
                if (!libreOfficeExecutionResults.ok) {
                    String ext = FilenameUtils.getExtension((String)originalFilePath).toLowerCase();
                    if (Objects.equals(ext, "pptx")) {
                        logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "Falling back on default extraction method for pptx file."));
                        return this.generateScreenshotsFromPptxInputStream(authCtx, projectKey, inputFile, inputStreamForFallback, originalFilePath, settings);
                    }
                    if (!this.isLibreOfficeInstalled()) {
                        throw new UnsupportedOperationException("LibreOffice must be installed to convert " + ext + " files to images, administrators can use install-deps.sh with the -with-libreoffice toggle");
                    }
                }
                if (libreOfficeExecutionResults.outputFile.renameTo(relatedPdfFile)) {
                    logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "Renamed converted pdf file to: " + relatedPdfFile.getPath()));
                } else {
                    logger.warn((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "Cannot rename file: " + libreOfficeExecutionResults.outputFile.getPath()));
                    relatedPdfFile = libreOfficeExecutionResults.outputFile;
                }
            }
            try (FileInputStream pdfFileStream = new FileInputStream(relatedPdfFile);){
                res = this.generateScreenshotsFromPdfInputStream(authCtx, projectKey, inputFile, pdfFileStream, Screenshotter.ScreenshotterSettings.ScreenshotterEngine.LIBRE_OFFICE, originalFilePath, settings);
                res.convertedFile = Optional.of(relatedPdfFile);
            }
        }
        return res;
    }

    /*
     * Exception decompiling
     */
    private String writeImageToManagedFolder(ManagedFolderHandler managedFolderHandler, BufferedImage img, String outputImagePath, String originalFilePath) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String imageToPngBase64(BufferedImage img) throws IOException {
        String string;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", outputStream);
            byte[] imageBytes = outputStream.toByteArray();
            string = Base64.getEncoder().encodeToString(imageBytes);
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IOException("Error converting image to Base64", e);
            }
        }
        outputStream.close();
        return string;
    }

    private static class LibreOfficeExecutionResults {
        File outputFile;
        DKUtils.ExecutionResults executionResults;
        public boolean ok;
        public Throwable error;

        private LibreOfficeExecutionResults() {
        }

        public static LibreOfficeExecutionResults fromSuccess(File convertedFile, DKUtils.ExecutionResults executionResults) {
            LibreOfficeExecutionResults resp = new LibreOfficeExecutionResults();
            resp.ok = true;
            resp.outputFile = convertedFile;
            resp.executionResults = executionResults;
            return resp;
        }

        public static LibreOfficeExecutionResults fromError(Throwable e) {
            LibreOfficeExecutionResults resp = new LibreOfficeExecutionResults();
            resp.ok = false;
            resp.error = e;
            return resp;
        }

        public static LibreOfficeExecutionResults fromMissingOutputFile(DKUtils.ExecutionResults executionResults, String message) {
            LibreOfficeExecutionResults resp = new LibreOfficeExecutionResults();
            resp.ok = false;
            resp.executionResults = executionResults;
            resp.error = new Exception(message);
            return resp;
        }
    }
}

