/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow;

import com.dataiku.dip.analysis.docgen.helpers.MDGFileUtil;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.docgen.GenericDocumentGenerationThread;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowDocumentPlaceholderStore;
import com.dataiku.dip.docgen.flow.FlowDocumentUtils;
import com.dataiku.dip.export.hooks.FileExportPostprocessingHookHandler;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class FlowDocumentGenerationThread
extends GenericDocumentGenerationThread<FlowDocumentContext> {
    private final FlowDocumentContext flowDocumentContext;
    private final FlowDocumentPlaceholderStore placeholderStore;

    public FlowDocumentGenerationThread(DSSAuthCtx user, String projectKey, InputStream templateInputStream, String rootUrl) throws IOException {
        super(user, projectKey, templateInputStream, rootUrl, FlowDocumentGenerationThread.buildFuturePayload(projectKey));
        SerializedProject serializedProject;
        try (Transaction ignored = ((TransactionService)SpringUtils.getBean(TransactionService.class)).beginRead();){
            serializedProject = ((ProjectsDAO)SpringUtils.getBean(ProjectsDAO.class)).getMandatoryUnsafe(projectKey);
        }
        this.flowDocumentContext = new FlowDocumentContext(serializedProject, user);
        this.placeholderStore = new FlowDocumentPlaceholderStore();
    }

    @Override
    protected String getDocumentGenerationId() {
        return this.projectKey;
    }

    @Override
    protected String getDocumentGenerationType() {
        return "flow";
    }

    @Override
    public FlowDocumentContext getDocumentGenerationContext() {
        return this.flowDocumentContext;
    }

    public FlowDocumentPlaceholderStore getPlaceholderStore() {
        return this.placeholderStore;
    }

    @Override
    public String getOutputFileName() {
        return FlowDocumentUtils.getDocumentFilename(this.flowDocumentContext);
    }

    private static FuturePayload buildFuturePayload(String projectKey) {
        FuturePayload fp = new FuturePayload();
        fp.action = "flow-document-generation";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(projectKey, ITaggingService.TaggableType.PROJECT.name()).withPart("flow-document-generation"));
        fp.displayName = "Flow document generation";
        return fp;
    }

    @Override
    public void onPost() throws Exception {
        File outputFile = new File(MDGFileUtil.getTmpExportDirectory(this.templateUploadId), this.getOutputFileName());
        FileExportPostprocessingHookHandler.onPostFlowDocumentationExport(this.flowDocumentContext.user, outputFile, this.flowDocumentContext.projectKey);
    }
}

