/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.recipe;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeRegistry;
import java.util.HashMap;

public class RecipeTypePlaceholder
implements FlowPlaceholder.TextPlaceholder<SerializedRecipe> {
    public static HashMap<String, String> recipeTypeUINames = RecipeTypePlaceholder.initRecipeTypeMap();

    @Override
    public Class<SerializedRecipe> getInputType() {
        return SerializedRecipe.class;
    }

    @Override
    public PlaceholderOutput.Text resolve(FlowDocumentContext flowDocumentContext, SerializedRecipe recipe) throws PlaceholderExpectedException {
        String type = recipe.type;
        if (recipeTypeUINames.containsKey(type)) {
            return new PlaceholderOutput.Text(recipeTypeUINames.get(type));
        }
        if (RecipeRegistry.hasMeta(recipe)) {
            String uiType;
            RecipeDesc desc = RecipeRegistry.getMeta(recipe).getRecipeDesc();
            String string = uiType = desc == null ? null : desc.meta.label;
            if (uiType == null) {
                uiType = type.toLowerCase().replaceAll("[_ ]+", " ");
            }
            return new PlaceholderOutput.Text(uiType);
        }
        throw new PlaceholderExpectedException("Unable to retrieve type for the recipe " + recipe.getDisplayName() + ". It might be associated with a plugin or an application that is not installed on this instance.");
    }

    private static HashMap<String, String> initRecipeTypeMap() {
        HashMap<String, String> recipeTypeUINames = new HashMap<String, String>();
        recipeTypeUINames.put("shaker", "Prepare");
        recipeTypeUINames.put("sync", "Sync");
        recipeTypeUINames.put("sampling", "Filter / Sample");
        recipeTypeUINames.put("grouping", "Group");
        recipeTypeUINames.put("upsert", "Upsert");
        recipeTypeUINames.put("distinct", "Distinct");
        recipeTypeUINames.put("window", "Window");
        recipeTypeUINames.put("join", "Join");
        recipeTypeUINames.put("fuzzyjoin", "Fuzzy join");
        recipeTypeUINames.put("geojoin", "Geo join");
        recipeTypeUINames.put("generate_features", "Generate features");
        recipeTypeUINames.put("split", "Split");
        recipeTypeUINames.put("topn", "Top N");
        recipeTypeUINames.put("sort", "Sort");
        recipeTypeUINames.put("pivot", "Pivot");
        recipeTypeUINames.put("vstack", "Stack");
        recipeTypeUINames.put("merge_folder", "Merge folders");
        recipeTypeUINames.put("update", "Push to Editable");
        recipeTypeUINames.put("export", "Export");
        recipeTypeUINames.put("download", "Download");
        recipeTypeUINames.put("python", "Python");
        recipeTypeUINames.put("r", "R");
        recipeTypeUINames.put("julia", "Julia");
        recipeTypeUINames.put("sql_query", "SQL");
        recipeTypeUINames.put("shell", "Shell");
        recipeTypeUINames.put("hive", "Hive");
        recipeTypeUINames.put("impala", "Impala");
        recipeTypeUINames.put("pig", "Pig");
        recipeTypeUINames.put("spark_sql_query", "Spark SQL");
        recipeTypeUINames.put("spark_scala", "Spark Scala");
        recipeTypeUINames.put("pyspark", "PySpark");
        recipeTypeUINames.put("sparkr", "Spark R");
        recipeTypeUINames.put("cpython", "Streaming Python");
        recipeTypeUINames.put("ksql", "Ksql");
        recipeTypeUINames.put("csync", "Streaming Sync");
        recipeTypeUINames.put("streaming_spark_scala", "Streaming Spark");
        recipeTypeUINames.put("clustering_cluster", "Cluster");
        recipeTypeUINames.put("evaluation", "Evaluate");
        recipeTypeUINames.put("prediction_training", "Prediction Training");
        recipeTypeUINames.put("clustering_training", "Clustering Training");
        recipeTypeUINames.put("prediction_scoring", "Prediction Scoring");
        recipeTypeUINames.put("clustering_scoring", "Clustering Scoring");
        recipeTypeUINames.put("standalone_evaluation", "Evaluate (standalone)");
        return recipeTypeUINames;
    }
}

