/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.bivariate.Chi2IndTest;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.grouping.AnumGrouping;
import com.dataiku.dip.eda.worksheets.cards.BivariateCard;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithConfidenceLevel;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.RecipeCompatibleCard;
import com.dataiku.dip.eda.worksheets.cards.fragments.BivariateFrequencyTableFragment;
import com.dataiku.dip.eda.worksheets.models.BinningMode;
import com.dataiku.dip.eda.worksheets.models.Variable;
import java.util.List;

public class Chi2IndTestCard
extends BivariateCard
implements CardWithConfidenceLevel,
RecipeCompatibleCard {
    public static final String TYPE = "chi2_independence_test";
    public int maxValuesX = 5;
    public int maxValuesY = 5;
    public double confidenceLevel;

    @Override
    public void setConfidenceLevel(double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    public Chi2IndTestCard(Variable xColumn, Variable yColumn, int maxValuesX, int maxValuesY, boolean groupWithOthers) {
        this.xColumn = xColumn;
        this.yColumn = yColumn;
        this.maxValuesX = maxValuesX;
        this.maxValuesY = maxValuesY;
    }

    private Chi2IndTestCard() {
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractCompiledCard<MultiComputation, MultiComputation.MultiComputationResult>(){

            @Override
            public MultiComputation getComputationPlan() {
                Computation freqTablePlan = BivariateFrequencyTableFragment.getFrequencyTablePlan(Chi2IndTestCard.this.xColumn.asCategorical(), Chi2IndTestCard.this.yColumn.asCategorical(), BinningMode.AUTO, BinningMode.AUTO, Chi2IndTestCard.this.maxValuesX, Chi2IndTestCard.this.maxValuesY, true, true, null, null);
                Chi2IndTest chi2plan = new Chi2IndTest(new AnumGrouping(Chi2IndTestCard.this.xColumn.name, null, false), new AnumGrouping(Chi2IndTestCard.this.yColumn.name, null, false));
                return new MultiComputation(freqTablePlan, chi2plan);
            }

            @Override
            protected CardResult buildFromFullyAvailableResult(MultiComputation.MultiComputationResult result) {
                BivariateFrequencyTableFragment freqTableData = BivariateFrequencyTableFragment.buildFrequencyTable(result.get(0));
                Chi2IndTest.Chi2IndTestResult chi2 = result.get(1).as(Chi2IndTest.Chi2IndTestResult.class);
                return new Chi2IndTestCardResult(result.collectWarnings(), freqTableData, chi2.statistic, chi2.pvalue, chi2.dof);
            }
        };
    }

    public static class Chi2IndTestCardResult
    extends CardResult {
        public BivariateFrequencyTableFragment freqTableData;
        public double statistic;
        public double pvalue;
        public int dof;

        public Chi2IndTestCardResult(List<String> warnings, BivariateFrequencyTableFragment freqTableData, double statistic, double pvalue, int dof) {
            this.warnings = warnings;
            this.freqTableData = freqTableData;
            this.statistic = statistic;
            this.pvalue = pvalue;
            this.dof = dof;
        }

        private Chi2IndTestCardResult() {
        }
    }
}

