/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.fragments;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.Count;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.computations.univariate.Mean;
import com.dataiku.dip.eda.compute.computations.univariate.Quantiles;
import com.dataiku.dip.eda.compute.computations.univariate.StdDev;
import com.dataiku.dip.eda.worksheets.cards.fragments.CountCompleteFragment;
import com.dataiku.dip.utils.ImmutableValueObject;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import javax.annotation.Nullable;

@UIModel
public class BoxPlotFragment
extends ImmutableValueObject {
    @Nullable
    public Long count;
    @Nullable
    public Long countComplete;
    @Nullable
    public Double min;
    @Nullable
    public Double max;
    @Nullable
    public Double mean;
    @Nullable
    public Double median;
    @Nullable
    public Double pc25;
    @Nullable
    public Double pc75;
    @Nullable
    public Double pc01;
    @Nullable
    public Double pc99;
    @Nullable
    public Double stdDev;

    public static Computation getComputationPlan(String column) {
        return new MultiComputation(new Quantiles(column, Lists.newArrayList((Object[])new Double[]{0.0, 0.01, 0.25, 0.5, 0.75, 0.99, 1.0})), new Mean(column, null), new Count(), new StdDev(column), CountCompleteFragment.getComputationPlan(column));
    }

    public static BoxPlotFragment build(ComputationResult result) {
        BoxPlotFragment boxPlot = new BoxPlotFragment();
        if (!result.isAvailable()) {
            return boxPlot;
        }
        MultiComputation.MultiComputationResult mcr = result.asMulti();
        Quantiles.QuantilesResult quantilesResult = mcr.get(0).isFullyAvailable() ? mcr.get(0).as(Quantiles.QuantilesResult.class) : null;
        Mean.MeanResult meanResult = mcr.get(1).isFullyAvailable() ? mcr.get(1).as(Mean.MeanResult.class) : null;
        Count.CountResult countResult = mcr.get(2).isFullyAvailable() ? mcr.get(2).as(Count.CountResult.class) : null;
        StdDev.StdDevResult stdDevResult = mcr.get(3).isFullyAvailable() ? mcr.get(3).as(StdDev.StdDevResult.class) : null;
        Long countComplete = CountCompleteFragment.buildResult(mcr.get(4));
        if (null != meanResult) {
            boxPlot.mean = meanResult.value;
        }
        if (null != countComplete) {
            boxPlot.countComplete = countComplete;
        }
        if (null != countResult) {
            boxPlot.count = countResult.count;
        }
        if (null != quantilesResult) {
            boxPlot.min = quantilesResult.getMand((double)0.0).quantile;
            boxPlot.max = quantilesResult.getMand((double)1.0).quantile;
            boxPlot.median = quantilesResult.getMand((double)0.5).quantile;
            boxPlot.pc25 = quantilesResult.getMand((double)0.25).quantile;
            boxPlot.pc75 = quantilesResult.getMand((double)0.75).quantile;
            boxPlot.pc99 = quantilesResult.getMand((double)0.99).quantile;
            boxPlot.pc01 = quantilesResult.getMand((double)0.01).quantile;
        }
        if (null != stdDevResult) {
            boxPlot.stdDev = stdDevResult.value;
        }
        return boxPlot;
    }
}

