/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.suggester;

import com.dataiku.dip.eda.worksheets.cards.bivariate_header.BivariateBoxPlotCard;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.BivariateFrequencyTableCard;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.BivariateHistogramCard;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.BivariateSummaryStatsCard;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.MosaicPlotCard;
import com.dataiku.dip.eda.worksheets.queries.SuggestCards;
import com.dataiku.dip.eda.worksheets.suggester.SniffedVariable;
import com.dataiku.dip.eda.worksheets.suggester.Suggester;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BivariateSuggester
implements Suggester {
    @Override
    public List<SuggestCards.SuggestedCard> suggestCards(List<SniffedVariable> sniffedVariables) {
        if (sniffedVariables.size() != 2) {
            return Collections.emptyList();
        }
        SniffedVariable first = sniffedVariables.get(0);
        SniffedVariable second = sniffedVariables.get(1);
        ArrayList<SuggestCards.SuggestedCard> suggestions = new ArrayList<SuggestCards.SuggestedCard>();
        suggestions.add(this.suggestSummaryStats(first, second));
        if (this.canSuggestHistogram(first, second)) {
            suggestions.add(this.suggestHistogram(first, second));
        } else if (this.canSuggestHistogram(second, first)) {
            suggestions.add(this.suggestHistogram(second, first));
        }
        if (first.isLikelyNumerical() && second.isLikelyCategorical()) {
            suggestions.add(this.suggestBoxPlot(first, second));
        } else if (first.isLikelyCategorical() && second.isLikelyNumerical()) {
            suggestions.add(this.suggestBoxPlot(second, first));
        }
        if (first.isLikelyCategorical() && second.isLikelyCategorical()) {
            suggestions.add(this.suggestFrequencyTable(first, second));
            suggestions.add(this.suggestMosaic(first, second));
        }
        return suggestions;
    }

    private SuggestCards.SuggestedCard suggestMosaic(SniffedVariable factor, SniffedVariable response) {
        MosaicPlotCard card = new MosaicPlotCard();
        card.xColumn = Suggester.toVariable(factor);
        card.yColumn = Suggester.toVariable(response);
        return new SuggestCards.SuggestedCard("Mosaic plot", card);
    }

    private boolean canSuggestHistogram(SniffedVariable factor, SniffedVariable response) {
        return factor.isLikelyCategorical() && factor.hasVeryLowCardinality() && response.isLikelyNumerical();
    }

    private SuggestCards.SuggestedCard suggestHistogram(SniffedVariable factor, SniffedVariable response) {
        BivariateHistogramCard card = new BivariateHistogramCard();
        card.xColumn = Suggester.toCategoricalVariable(factor);
        card.yColumn = Suggester.toContinuousVariable(response);
        return new SuggestCards.SuggestedCard("2D histogram", card);
    }

    private SuggestCards.SuggestedCard suggestFrequencyTable(SniffedVariable factor, SniffedVariable response) {
        BivariateFrequencyTableCard card = new BivariateFrequencyTableCard();
        card.xColumn = Suggester.toVariable(factor);
        card.yColumn = Suggester.toVariable(response);
        return new SuggestCards.SuggestedCard("Frequency table", card);
    }

    private SuggestCards.SuggestedCard suggestBoxPlot(SniffedVariable factor, SniffedVariable response) {
        BivariateBoxPlotCard card = new BivariateBoxPlotCard();
        card.xColumn = Suggester.toVariable(factor);
        card.yColumn = Suggester.toVariable(response);
        String cardName = String.format("Box plot: %s by %s", response.name, factor.name);
        return new SuggestCards.SuggestedCard(cardName, card);
    }

    private SuggestCards.SuggestedCard suggestSummaryStats(SniffedVariable factor, SniffedVariable response) {
        BivariateSummaryStatsCard card = new BivariateSummaryStatsCard();
        card.xColumn = Suggester.toVariable(factor);
        card.yColumn = Suggester.toVariable(response);
        return new SuggestCards.SuggestedCard("Summary statistics", card);
    }
}

